/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.panther.container;

import com.github.sanctum.panther.container.ImmutablePantherCollection;
import com.github.sanctum.panther.container.PantherCollection;
import com.github.sanctum.panther.container.PantherEntry;
import com.github.sanctum.panther.container.PantherList;
import com.github.sanctum.panther.container.PantherSet;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public interface PantherMap<K, V>
extends Iterable<PantherEntry.Modifiable<K, V>> {
    public V get(K var1);

    public V put(K var1, V var2);

    public boolean putAll(Iterable<Map.Entry<K, V>> var1);

    public boolean remove(K var1);

    public boolean removeAll(Iterable<Map.Entry<K, V>> var1);

    public boolean containsKey(K var1);

    public boolean containsValue(V var1);

    public int size();

    public void clear();

    default public boolean isEmpty() {
        return this.size() <= 0;
    }

    default public V computeIfAbsent(K key, V value) {
        V test = this.get(key);
        return test != null ? test : this.put(key, value);
    }

    default public V computeIfAbsent(K key, Supplier<V> value) {
        V test = this.get(key);
        return test != null ? test : this.put(key, value.get());
    }

    default public V computeIfAbsent(K key, Function<K, V> function) {
        V test = this.get(key);
        return test != null ? test : this.put(key, function.apply(key));
    }

    default public PantherCollection<PantherEntry.Modifiable<K, V>> entries() {
        PantherSet<PantherEntry.Modifiable<K, V>> keys = new PantherSet<PantherEntry.Modifiable<K, V>>();
        this.forEach(keys::add);
        return keys;
    }

    default public PantherCollection<K> keys() {
        PantherSet keys = new PantherSet();
        this.forEach(entry -> keys.add(entry.getKey()));
        return ImmutablePantherCollection.of(keys);
    }

    default public PantherCollection<V> values() {
        PantherList keys = new PantherList();
        this.forEach(entry -> keys.add(entry.getValue()));
        return keys;
    }

    default public Stream<PantherEntry.Modifiable<K, V>> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }
}

