/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.panther.container;

import com.github.sanctum.panther.container.ImmutablePantherCollection;
import com.github.sanctum.panther.container.ImmutablePantherMap;
import com.github.sanctum.panther.container.PantherCollection;
import com.github.sanctum.panther.container.PantherEntryMap;
import com.github.sanctum.panther.container.PantherList;
import com.github.sanctum.panther.container.PantherMap;
import com.github.sanctum.panther.container.PantherSet;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collector;

public final class PantherCollectors {
    public static <T> Collector<T, ?, PantherList<T>> toList() {
        return Collector.of(PantherList::new, PantherCollection::add, (left, right) -> {
            left.addAll(right);
            return left;
        }, new Collector.Characteristics[0]);
    }

    public static <T> Collector<T, ?, PantherSet<T>> toSet() {
        return Collector.of(PantherSet::new, PantherCollection::add, (left, right) -> {
            left.addAll(right);
            return left;
        }, new Collector.Characteristics[0]);
    }

    public static <T> Collector<T, ?, PantherCollection<T>> toImmutableList() {
        return Collector.of(PantherList::new, PantherCollection::add, (left, right) -> {
            left.addAll(right);
            return ImmutablePantherCollection.of(left);
        }, new Collector.Characteristics[0]);
    }

    public static <T> Collector<T, ?, PantherCollection<T>> toImmutableSet() {
        return Collector.of(PantherSet::new, PantherCollection::add, (left, right) -> {
            left.addAll(right);
            return ImmutablePantherCollection.of(left);
        }, new Collector.Characteristics[0]);
    }

    public static <T, K, U> Collector<T, ?, PantherMap<K, U>> toMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper) {
        return Collector.of(PantherEntryMap::new, PantherCollectors.defaultJavaEntryAccumulation(keyMapper, valueMapper), PantherCollectors.defaultJavaEntryMerger(), new Collector.Characteristics[0]);
    }

    public static <T, K, U> Collector<T, ?, PantherMap<K, U>> toImmutableMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper) {
        return Collector.of(PantherEntryMap::new, PantherCollectors.defaultJavaEntryAccumulation(keyMapper, valueMapper), PantherCollectors.immutableJavaEntryMerger(), new Collector.Characteristics[0]);
    }

    private static <T, K, V> BiConsumer<PantherMap<K, V>, T> defaultJavaEntryAccumulation(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper) {
        return (map, element) -> {
            Object k = keyMapper.apply(element);
            Object v = Objects.requireNonNull(valueMapper.apply(element), "Cannot copy null map entry value for key " + k);
            map.computeIfAbsent(k, v);
        };
    }

    private static <K, V, M extends PantherMap<K, V>> BinaryOperator<M> defaultJavaEntryMerger() {
        return (m1, m2) -> {
            for (Map.Entry entry : m2.entries()) {
                Object k = entry.getKey();
                Object v = Objects.requireNonNull(entry.getValue(), "Cannot merge null map entry value for key " + k);
                m1.computeIfAbsent(k, v);
            }
            return m1;
        };
    }

    private static <K, V> BinaryOperator<PantherMap<K, V>> immutableJavaEntryMerger() {
        return (m1, m2) -> {
            for (Map.Entry entry : m2.entries()) {
                Object k = entry.getKey();
                Object v = Objects.requireNonNull(entry.getValue(), "Cannot merge null immutable map entry value for key " + k);
                m1.computeIfAbsent(k, v);
            }
            return ImmutablePantherMap.of(m1);
        };
    }
}

