/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.panther.container;

import com.github.sanctum.panther.container.PantherCollection;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public abstract class PantherCollectionBase<E>
implements PantherCollection<E> {
    protected final boolean capacityEnforced;
    protected Node head;
    protected Node tail;
    protected int size;
    protected int capacity;

    public PantherCollectionBase() {
        this.capacity = 10;
        this.capacityEnforced = false;
    }

    public PantherCollectionBase(int capacity) {
        this.capacity = capacity;
        this.capacityEnforced = true;
    }

    public PantherCollectionBase(Iterable<E> iterable) {
        this.capacity = 10;
        this.capacityEnforced = false;
        this.addAll(iterable);
    }

    public PantherCollectionBase(Iterable<E> iterable, int capacity) {
        this(capacity);
        this.addAll(iterable);
    }

    @Override
    public boolean add(E e) {
        if (this.capacityEnforced) {
            if (this.size() >= this.capacity) {
                return false;
            }
        } else if (this.size() >= this.capacity) {
            ++this.capacity;
        }
        Node new_node = new Node(e);
        if (this.head == null) {
            this.head = new_node;
        } else {
            Node last = this.head;
            while (last.next != null) {
                last = last.next;
            }
            last.next = new_node;
            this.tail = new_node;
        }
        ++this.size;
        return true;
    }

    @Override
    public boolean addAll(Iterable<E> iterable) {
        boolean result = true;
        for (E e : iterable) {
            if (this.contains(e)) {
                result = false;
                continue;
            }
            this.add(e);
        }
        return result;
    }

    @Override
    public boolean remove(E e) {
        if (this.head == null) {
            return false;
        }
        Node current = this.head;
        while (current != null) {
            if (current.data == e || current.data.equals(e)) {
                --this.size;
                return this.remove(current);
            }
            current = current.next;
        }
        return false;
    }

    @Override
    public boolean removeAll(Iterable<E> iterable) {
        boolean result = true;
        for (E e : iterable) {
            if (!this.contains(e)) {
                result = false;
                continue;
            }
            this.remove(e);
        }
        return result;
    }

    @Override
    public E get(int index) {
        E result = null;
        Node current = this.head;
        int in = 0;
        while (current != null) {
            if (in == index) {
                result = current.data;
                break;
            }
            current = current.next;
            ++in;
        }
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index " + index + " out of bounds for capacity " + this.size());
        }
        return result;
    }

    @Override
    public int size() {
        return this.size;
    }

    public int capacity() {
        return this.capacity;
    }

    @Override
    public boolean contains(E e) {
        boolean found = false;
        Node current = this.head;
        while (current != null && !found) {
            if (current.data == e || current.data.equals(e)) {
                found = true;
            }
            current = current.next;
        }
        return found;
    }

    @Override
    public boolean containsAll(Iterable<E> iterable) {
        for (E e : iterable) {
            if (this.contains(e)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void clear() {
        this.head = null;
        this.tail = null;
        this.size = -1;
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            private Node initial;
            {
                this.initial = PantherCollectionBase.this.head;
            }

            @Override
            public boolean hasNext() {
                return this.initial != null;
            }

            @Override
            public E next() {
                Object data = this.initial.data;
                this.initial = this.initial.next;
                return data;
            }
        };
    }

    @Override
    public void forEach(Consumer<? super E> action) {
        for (E e : this) {
            action.accept(e);
        }
    }

    @Override
    public Spliterator<E> spliterator() {
        return Spliterators.spliteratorUnknownSize(this.iterator(), 16);
    }

    boolean removeFirst() {
        if (this.head == null) {
            return false;
        }
        if (this.head == this.tail) {
            this.head = null;
            this.tail = null;
        } else {
            this.head = this.head.next;
        }
        return true;
    }

    boolean removeLast() {
        if (this.tail == null) {
            return false;
        }
        if (this.head == this.tail) {
            this.head = null;
            this.tail = null;
        } else {
            Node previousToTail = this.head;
            while (previousToTail.next != this.tail) {
                previousToTail = previousToTail.next;
            }
            this.tail = previousToTail;
            this.tail.next = null;
        }
        return true;
    }

    @Override
    boolean remove(Node node) {
        Node currentNode = this.head;
        Node prevNode = null;
        while (currentNode != null && !currentNode.equals(node)) {
            prevNode = currentNode;
            currentNode = currentNode.next;
        }
        if (currentNode == null) {
            return false;
        }
        if (prevNode == null) {
            return this.removeFirst();
        }
        if (prevNode.next.next == null) {
            return this.removeLast();
        }
        prevNode.next = prevNode.next.next;
        return true;
    }

    public String toString() {
        StringBuilder list = new StringBuilder();
        int count = 0;
        for (E e : this) {
            if (count == this.size - 1) {
                list.append(e.toString());
            } else {
                list.append(e.toString()).append(", ");
            }
            ++count;
        }
        return "[" + list + "]";
    }

    protected class Node {
        protected E data;
        protected Node next;

        Node(Node node) {
            this.data = node.data;
            this.next = node.next.copy();
        }

        Node(E d) {
            this.data = d;
            this.next = null;
        }

        Node copy() {
            return new Node(this);
        }
    }
}

