/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.panther.container;

import java.lang.reflect.Array;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jetbrains.annotations.NotNull;

public interface PantherCollection<K>
extends Iterable<K> {
    public K get(int var1) throws IndexOutOfBoundsException;

    public boolean add(K var1);

    public boolean addAll(Iterable<K> var1);

    public boolean remove(K var1);

    public boolean removeAll(Iterable<K> var1);

    public boolean contains(K var1);

    public boolean containsAll(Iterable<K> var1);

    public int size();

    public void clear();

    default public boolean isEmpty() {
        return this.size() <= 0;
    }

    @NotNull
    default public <T> T[] toArray(T[] a) {
        Object[] copy = (Object[])Array.newInstance(a.getClass().getComponentType(), this.size());
        for (int i = 0; i < this.size(); ++i) {
            copy[i] = this.get(i);
        }
        return copy;
    }

    @NotNull
    default public K[] toArray(IntFunction<K[]> a) {
        return this.stream().toArray(a);
    }

    default public Stream<K> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    default public void removeIf(@NotNull Predicate<K> predicate) {
        this.forEach(k -> {
            if (predicate.test(k)) {
                this.remove(k);
            }
        });
    }
}

