/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.panther.container;

import com.github.sanctum.panther.container.ImmutableStorageException;
import com.github.sanctum.panther.container.PantherEntryMap;
import com.github.sanctum.panther.container.PantherMap;
import com.github.sanctum.panther.container.PantherMapBase;
import java.util.Map;
import java.util.function.Function;

public abstract class ImmutablePantherMap<K, V>
extends PantherMapBase<K, V> {
    ImmutablePantherMap(PantherMap<K, V> map) {
        map.forEach(entry -> this.addImmutable(entry.getKey(), entry.getValue()));
    }

    ImmutablePantherMap(Map<K, V> map) {
        map.forEach(this::addImmutable);
    }

    void addImmutable(K k, V v) {
        PantherMapBase.Node storage = new PantherMapBase.Node((PantherMapBase)this, new PantherMapBase.ImmutablePantherEntry<K, V>(k, v));
        storage.next = null;
        if (this.head == null) {
            this.head = storage;
        } else {
            PantherMapBase.Node last = this.head;
            while (last.next != null) {
                last = last.next;
            }
            last.next = storage;
        }
        this.tail = storage;
        ++this.size;
    }

    @Override
    @Deprecated
    public V put(K e, V value) {
        throw this.warning();
    }

    @Override
    @Deprecated
    public boolean putAll(Iterable<Map.Entry<K, V>> iterable) {
        throw this.warning();
    }

    @Override
    @Deprecated
    public boolean removeAll(Iterable<Map.Entry<K, V>> iterable) {
        throw this.warning();
    }

    @Override
    @Deprecated
    public boolean remove(K e) {
        throw this.warning();
    }

    @Override
    @Deprecated
    public void clear() {
        throw this.warning();
    }

    @Override
    @Deprecated
    public V computeIfAbsent(K key, V value) {
        throw this.warning();
    }

    @Override
    @Deprecated
    public V computeIfAbsent(K key, Function<K, V> function) {
        throw this.warning();
    }

    public static <K, V> ImmutablePantherMap<K, V> of(PantherMap<K, V> map) {
        return new ImmutablePantherMap<K, V>((PantherMap)map){};
    }

    public static <K, V> ImmutablePantherMap<K, V> of(Map<K, V> map) {
        return new ImmutablePantherMap<K, V>((Map)map){};
    }

    RuntimeException warning() {
        return new ImmutableStorageException("Element modifications cannot be made to immutable maps!");
    }

    public static <K, V> Builder<K, V> builder() {
        return new Builder();
    }

    public static final class Builder<K, V> {
        private final PantherMap<K, V> internal = new PantherEntryMap();

        Builder() {
        }

        public Builder<K, V> put(K key, V value) {
            this.internal.put(key, value);
            return this;
        }

        public ImmutablePantherMap<K, V> build() {
            return ImmutablePantherMap.of(this.internal);
        }
    }
}

