/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.panther.annotation;

import java.lang.annotation.Annotation;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public final class AnnotationDiscovery<T extends Annotation, R>
implements Iterable<Method> {
    private final int count;
    private final Class<T> annotation;
    private final R r;
    private final Class<R> rClass;
    private Set<Method> methods = new HashSet<Method>();

    AnnotationDiscovery(Class<T> annotation, R r) {
        this.annotation = annotation;
        this.r = r;
        this.rClass = r.getClass();
        int annotated = 0;
        for (Method method : this.rClass.getDeclaredMethods()) {
            try {
                method.setAccessible(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!method.isAnnotationPresent(annotation)) continue;
            ++annotated;
        }
        this.count = annotated;
    }

    AnnotationDiscovery(Class<T> annotation, Class<R> r) {
        this.annotation = annotation;
        this.r = null;
        this.rClass = r;
        int annotated = 0;
        for (Method method : this.rClass.getDeclaredMethods()) {
            try {
                method.setAccessible(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!method.isAnnotationPresent(annotation)) continue;
            ++annotated;
        }
        this.count = annotated;
    }

    @NotNull
    public static <T extends Annotation, R> AnnotationDiscovery<T, R> of(@NotNull Class<T> c, @NotNull R listener) {
        return new AnnotationDiscovery<T, R>(c, listener);
    }

    @NotNull
    public static <T extends Annotation, R> AnnotationDiscovery<T, R> of(@NotNull Class<T> c, @NotNull Class<R> listener) {
        return new AnnotationDiscovery<T, R>(c, listener);
    }

    public AnnotationDiscovery<T, R> sort(Comparator<? super Method> comparator) {
        this.methods = this.methods.stream().sorted(comparator).collect(Collectors.toCollection(LinkedHashSet::new));
        return this;
    }

    public AnnotationDiscovery<T, R> filter(boolean hard) {
        return this.filter(method -> true, hard);
    }

    public AnnotationDiscovery<T, R> filter(Predicate<? super Method> predicate) {
        return this.filter(predicate, false);
    }

    public AnnotationDiscovery<T, R> filter(Predicate<? super Method> predicate, boolean hard) {
        if (!hard) {
            if (this.methods.isEmpty()) {
                this.methods.addAll(Arrays.stream(this.rClass.getDeclaredMethods()).filter((? super T m) -> m.isAnnotationPresent(this.annotation) && predicate.test((Method)m)).collect(Collectors.toList()));
            }
        } else if (this.methods.isEmpty()) {
            this.methods.addAll(Arrays.stream(this.rClass.getDeclaredMethods()).filter((? super T m) -> {
                try {
                    m.setAccessible(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return m.isAnnotationPresent(this.annotation) && predicate.test((Method)m);
            }).collect(Collectors.toList()));
        }
        return this;
    }

    public boolean isPresent() {
        return this.methods.isEmpty() ? this.rClass.isAnnotationPresent(this.annotation) : this.count > 0;
    }

    public void ifPresent(BiConsumer<T, Method> function) {
        if (this.isPresent()) {
            this.methods.forEach((? super T m) -> {
                for (Annotation a : m.getAnnotations()) {
                    if (!this.annotation.isAssignableFrom(a.annotationType())) continue;
                    function.accept((T)a, (Method)m);
                }
            });
        }
    }

    public <U> U mapFromClass(AnnotativeConsumer<T, R, U> function) {
        if (this.isPresent()) {
            return function.accept(this.rClass.getAnnotation(this.annotation), this.r);
        }
        return null;
    }

    public <U> List<U> mapFromMethods(AnnotativeConsumer<T, R, U> function) {
        ArrayList list = new ArrayList();
        this.ifPresent((t, method) -> list.add(function.accept(t, this.r)));
        return list;
    }

    public Set<Method> methods() {
        return this.methods;
    }

    public Set<T> read(Method m) {
        return Arrays.stream(m.getAnnotations()).filter((? super T a) -> this.annotation.isAssignableFrom(a.getClass())).map(a -> a).collect(Collectors.toSet());
    }

    public int count() {
        return this.count;
    }

    @Override
    public void forEach(Consumer<? super Method> consumer) {
        if (this.methods.isEmpty()) {
            this.filter((Predicate<Method>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$forEach$7(java.lang.reflect.Method ), (Ljava/lang/reflect/Method;)Z)()).methods.forEach(consumer);
        } else {
            this.methods.forEach(consumer);
        }
    }

    @Override
    @NotNull
    public Iterator<Method> iterator() {
        return this.methods().iterator();
    }

    @Override
    public Spliterator<Method> spliterator() {
        return this.methods().spliterator();
    }

    private static /* synthetic */ boolean lambda$forEach$7(Method method) {
        return true;
    }

    @FunctionalInterface
    public static interface AnnotativeConsumer<U extends Annotation, R, V> {
        public V accept(U var1, R var2);
    }
}

