/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth.task;

import com.github.sanctum.labyrinth.LabyrinthProvider;
import com.github.sanctum.labyrinth.api.LabyrinthAPI;
import com.github.sanctum.labyrinth.task.BukkitTaskPredicate;
import com.github.sanctum.labyrinth.task.RenderedTask;
import com.github.sanctum.panther.util.OrdinalProcedure;
import com.github.sanctum.panther.util.Task;
import com.github.sanctum.panther.util.TaskChain;
import com.github.sanctum.panther.util.TypeAdapter;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TaskMonitor {
    private static TaskMonitor instance;
    protected final TypeAdapter<BukkitTaskPredicate<Task>[]> flagClass;
    protected final Map<Integer, TaskChain> map = new HashMap<Integer, TaskChain>();

    TaskMonitor() {
        this.flagClass = TypeAdapter.get();
        LabyrinthAPI api = LabyrinthProvider.getInstance();
        this.map.put(0, api.getScheduler(0));
        this.map.put(1, api.getScheduler(1));
    }

    public boolean shutdown() {
        return this.map.get(0).shutdown() && this.map.get(1).shutdown();
    }

    @Nullable
    public Task get(@NotNull String key) {
        if (key == null) {
            TaskMonitor.$$$reportNull$$$0(0);
        }
        return this.map.get(0).get(key) != null ? this.map.get(0).get(key) : this.map.get(1).get(key);
    }

    @NotNull
    public RenderedTask schedule(Runnable data) {
        RenderedTask execution = RenderedTask.of(data, 0);
        Task task = execution.getTask();
        this.map.get(0).run(task);
        RenderedTask renderedTask = execution;
        if (renderedTask == null) {
            TaskMonitor.$$$reportNull$$$0(1);
        }
        return renderedTask;
    }

    @NotNull
    public RenderedTask scheduleAsync(Runnable data) {
        RenderedTask execution = RenderedTask.of(data, 1);
        Task task = execution.getTask();
        this.map.get(1).run(task);
        RenderedTask renderedTask = execution;
        if (renderedTask == null) {
            TaskMonitor.$$$reportNull$$$0(2);
        }
        return renderedTask;
    }

    @NotNull
    public RenderedTask scheduleLater(Runnable data, long delay) {
        RenderedTask execution = RenderedTask.of(data, null, 0, delay * 50L, -1L);
        Task task = execution.getTask();
        this.map.get(0).wait(task, delay * 50L);
        RenderedTask renderedTask = execution;
        if (renderedTask == null) {
            TaskMonitor.$$$reportNull$$$0(3);
        }
        return renderedTask;
    }

    @NotNull
    public RenderedTask scheduleLater(Runnable data, String key, long delay) {
        RenderedTask execution = RenderedTask.of(data, key, 0, delay * 50L, -1L);
        Task task = execution.getTask();
        this.map.get(0).wait(task, delay * 50L);
        RenderedTask renderedTask = execution;
        if (renderedTask == null) {
            TaskMonitor.$$$reportNull$$$0(4);
        }
        return renderedTask;
    }

    @NotNull
    public RenderedTask scheduleLaterAsync(Runnable data, long delay) {
        RenderedTask execution = RenderedTask.of(data, null, 1, delay * 50L, -1L);
        Task task = execution.getTask();
        this.map.get(1).wait(task, delay * 50L);
        RenderedTask renderedTask = execution;
        if (renderedTask == null) {
            TaskMonitor.$$$reportNull$$$0(5);
        }
        return renderedTask;
    }

    @NotNull
    public RenderedTask scheduleLaterAsync(Runnable data, String key, long delay) {
        RenderedTask execution = RenderedTask.of(data, key, 1, delay * 50L, -1L);
        Task task = execution.getTask();
        this.map.get(1).wait(task, delay * 50L);
        RenderedTask renderedTask = execution;
        if (renderedTask == null) {
            TaskMonitor.$$$reportNull$$$0(6);
        }
        return renderedTask;
    }

    @NotNull
    public RenderedTask scheduleTimer(Runnable data, String key, long delay, long period) {
        RenderedTask execution = RenderedTask.of(data, key, 0, delay * 50L, period * 50L);
        Task task = execution.getTask();
        this.map.get(0).repeat(task, delay * 50L, period * 50L);
        RenderedTask renderedTask = execution;
        if (renderedTask == null) {
            TaskMonitor.$$$reportNull$$$0(7);
        }
        return renderedTask;
    }

    @NotNull
    public RenderedTask scheduleTimerAsync(Runnable data, String key, long delay, long period) {
        RenderedTask execution = RenderedTask.of(data, key, 1, delay * 50L, period * 50L);
        Task task = execution.getTask();
        this.map.get(1).repeat(task, delay * 50L, period * 50L);
        RenderedTask renderedTask = execution;
        if (renderedTask == null) {
            TaskMonitor.$$$reportNull$$$0(8);
        }
        return renderedTask;
    }

    @NotNull
    public RenderedTask scheduleLater(Runnable data, long delay, BukkitTaskPredicate<?> ... flags) {
        RenderedTask execution = RenderedTask.of(data, null, 0, delay * 50L, -1L);
        execution.dependOn(BukkitTaskPredicate.reduceEmpty());
        for (BukkitTaskPredicate<Task> flag : this.flagClass.cast(flags)) {
            execution.dependOn(flag);
        }
        Task task = execution.getTask();
        this.map.get(0).wait(task, delay * 50L);
        RenderedTask renderedTask = execution;
        if (renderedTask == null) {
            TaskMonitor.$$$reportNull$$$0(9);
        }
        return renderedTask;
    }

    @NotNull
    public RenderedTask scheduleLater(Runnable data, String key, long delay, BukkitTaskPredicate<?> ... flags) {
        RenderedTask execution = RenderedTask.of(data, key, 0, delay * 50L, -1L);
        execution.dependOn(BukkitTaskPredicate.reduceEmpty());
        for (BukkitTaskPredicate<Task> flag : this.flagClass.cast(flags)) {
            execution.dependOn(flag);
        }
        Task task = execution.getTask();
        this.map.get(0).wait(task, delay * 50L);
        RenderedTask renderedTask = execution;
        if (renderedTask == null) {
            TaskMonitor.$$$reportNull$$$0(10);
        }
        return renderedTask;
    }

    @NotNull
    public RenderedTask scheduleLaterAsync(Runnable data, long delay, BukkitTaskPredicate<?> ... flags) {
        RenderedTask execution = RenderedTask.of(data, null, 1, delay * 50L, -1L);
        execution.dependOn(BukkitTaskPredicate.reduceEmpty());
        for (BukkitTaskPredicate<Task> flag : this.flagClass.cast(flags)) {
            execution.dependOn(flag);
        }
        Task task = execution.getTask();
        this.map.get(1).wait(task, delay * 50L);
        RenderedTask renderedTask = execution;
        if (renderedTask == null) {
            TaskMonitor.$$$reportNull$$$0(11);
        }
        return renderedTask;
    }

    @NotNull
    public RenderedTask scheduleLaterAsync(Runnable data, String key, long delay, BukkitTaskPredicate<?> ... flags) {
        RenderedTask execution = RenderedTask.of(data, key, 1, delay * 50L, -1L);
        execution.dependOn(BukkitTaskPredicate.reduceEmpty());
        for (BukkitTaskPredicate<Task> flag : this.flagClass.cast(flags)) {
            execution.dependOn(flag);
        }
        Task task = execution.getTask();
        this.map.get(1).wait(task, delay * 50L);
        RenderedTask renderedTask = execution;
        if (renderedTask == null) {
            TaskMonitor.$$$reportNull$$$0(12);
        }
        return renderedTask;
    }

    @NotNull
    public RenderedTask scheduleTimer(Runnable data, String key, long delay, long period, BukkitTaskPredicate<?> ... flags) {
        RenderedTask execution = RenderedTask.of(data, key, 0, delay * 50L, period * 50L);
        execution.dependOn(BukkitTaskPredicate.reduceEmpty());
        execution.dependOn(BukkitTaskPredicate.reduceEmpty());
        for (BukkitTaskPredicate<Task> flag : this.flagClass.cast(flags)) {
            execution.dependOn(flag);
        }
        Task task = execution.getTask();
        this.map.get(0).repeat(task, delay * 50L, period * 50L);
        RenderedTask renderedTask = execution;
        if (renderedTask == null) {
            TaskMonitor.$$$reportNull$$$0(13);
        }
        return renderedTask;
    }

    @NotNull
    public RenderedTask scheduleTimerAsync(Runnable data, String key, long delay, long period, BukkitTaskPredicate<?> ... flags) {
        RenderedTask execution = RenderedTask.of(data, key, 1, delay * 50L, period * 50L);
        execution.dependOn(BukkitTaskPredicate.reduceEmpty());
        execution.dependOn(BukkitTaskPredicate.reduceEmpty());
        for (BukkitTaskPredicate<Task> flag : this.flagClass.cast(flags)) {
            execution.dependOn(flag);
        }
        Task task = execution.getTask();
        this.map.get(1).repeat(task, delay * 50L, period * 50L);
        RenderedTask renderedTask = execution;
        if (renderedTask == null) {
            TaskMonitor.$$$reportNull$$$0(14);
        }
        return renderedTask;
    }

    @NotNull
    public RenderedTask schedule(Task data) {
        RenderedTask execution = RenderedTask.of(data, 0);
        Task task = execution.getTask();
        this.map.get(0).run(task);
        RenderedTask renderedTask = execution;
        if (renderedTask == null) {
            TaskMonitor.$$$reportNull$$$0(15);
        }
        return renderedTask;
    }

    @NotNull
    public RenderedTask scheduleAsync(Task data) {
        RenderedTask execution = RenderedTask.of(data, 1);
        Task task = execution.getTask();
        this.map.get(1).run(task);
        RenderedTask renderedTask = execution;
        if (renderedTask == null) {
            TaskMonitor.$$$reportNull$$$0(16);
        }
        return renderedTask;
    }

    @NotNull
    public RenderedTask scheduleLater(Task data, long delay) {
        RenderedTask execution = RenderedTask.of(data, null, 0, delay * 50L, -1L);
        Task task = execution.getTask();
        this.map.get(0).wait(task, delay * 50L);
        RenderedTask renderedTask = execution;
        if (renderedTask == null) {
            TaskMonitor.$$$reportNull$$$0(17);
        }
        return renderedTask;
    }

    @NotNull
    public RenderedTask scheduleLater(Task data, String key, long delay) {
        RenderedTask execution = RenderedTask.of(data, key, 0, delay * 50L, -1L);
        Task task = execution.getTask();
        this.map.get(0).wait(task, delay * 50L);
        RenderedTask renderedTask = execution;
        if (renderedTask == null) {
            TaskMonitor.$$$reportNull$$$0(18);
        }
        return renderedTask;
    }

    @NotNull
    public RenderedTask scheduleLaterAsync(Task data, long delay) {
        RenderedTask execution = RenderedTask.of(data, null, 1, delay * 50L, -1L);
        Task task = execution.getTask();
        this.map.get(1).wait(task, delay * 50L);
        RenderedTask renderedTask = execution;
        if (renderedTask == null) {
            TaskMonitor.$$$reportNull$$$0(19);
        }
        return renderedTask;
    }

    @NotNull
    public RenderedTask scheduleLaterAsync(Task data, String key, long delay) {
        RenderedTask execution = RenderedTask.of(data, key, 1, delay * 50L, -1L);
        Task task = execution.getTask();
        this.map.get(1).wait(task, delay * 50L);
        RenderedTask renderedTask = execution;
        if (renderedTask == null) {
            TaskMonitor.$$$reportNull$$$0(20);
        }
        return renderedTask;
    }

    @NotNull
    public RenderedTask scheduleTimer(Task data, String key, long delay, long period) {
        RenderedTask execution = RenderedTask.of(data, key, 0, delay * 50L, period * 50L);
        Task task = execution.getTask();
        this.map.get(0).repeat(task, delay * 50L, period * 50L);
        RenderedTask renderedTask = execution;
        if (renderedTask == null) {
            TaskMonitor.$$$reportNull$$$0(21);
        }
        return renderedTask;
    }

    @NotNull
    public RenderedTask scheduleTimerAsync(Task data, String key, long delay, long period) {
        RenderedTask execution = RenderedTask.of(data, key, 1, delay * 50L, period * 50L);
        Task task = execution.getTask();
        this.map.get(1).repeat(task, delay * 50L, period * 50L);
        RenderedTask renderedTask = execution;
        if (renderedTask == null) {
            TaskMonitor.$$$reportNull$$$0(22);
        }
        return renderedTask;
    }

    @NotNull
    public RenderedTask scheduleLater(Task data, long delay, BukkitTaskPredicate<?> ... flags) {
        RenderedTask execution = RenderedTask.of(data, null, 0, delay * 50L, -1L);
        execution.dependOn(BukkitTaskPredicate.reduceEmpty());
        for (BukkitTaskPredicate<Task> flag : this.flagClass.cast(flags)) {
            execution.dependOn(flag);
        }
        Task task = execution.getTask();
        this.map.get(0).wait(task, delay * 50L);
        RenderedTask renderedTask = execution;
        if (renderedTask == null) {
            TaskMonitor.$$$reportNull$$$0(23);
        }
        return renderedTask;
    }

    @NotNull
    public RenderedTask scheduleLater(Task data, String key, long delay, BukkitTaskPredicate<?> ... flags) {
        RenderedTask execution = RenderedTask.of(data, key, 0, delay * 50L, -1L);
        execution.dependOn(BukkitTaskPredicate.reduceEmpty());
        for (BukkitTaskPredicate<Task> flag : this.flagClass.cast(flags)) {
            execution.dependOn(flag);
        }
        Task task = execution.getTask();
        this.map.get(0).wait(task, delay * 50L);
        RenderedTask renderedTask = execution;
        if (renderedTask == null) {
            TaskMonitor.$$$reportNull$$$0(24);
        }
        return renderedTask;
    }

    @NotNull
    public RenderedTask scheduleLaterAsync(Task data, long delay, BukkitTaskPredicate<?> ... flags) {
        RenderedTask execution = RenderedTask.of(data, null, 1, delay * 50L, -1L);
        execution.dependOn(BukkitTaskPredicate.reduceEmpty());
        for (BukkitTaskPredicate<Task> flag : this.flagClass.cast(flags)) {
            execution.dependOn(flag);
        }
        Task task = execution.getTask();
        this.map.get(1).wait(task, delay * 50L);
        RenderedTask renderedTask = execution;
        if (renderedTask == null) {
            TaskMonitor.$$$reportNull$$$0(25);
        }
        return renderedTask;
    }

    @NotNull
    public RenderedTask scheduleLaterAsync(Task data, String key, long delay, BukkitTaskPredicate<?> ... flags) {
        RenderedTask execution = RenderedTask.of(data, key, 1, delay * 50L, -1L);
        execution.dependOn(BukkitTaskPredicate.reduceEmpty());
        for (BukkitTaskPredicate<Task> flag : this.flagClass.cast(flags)) {
            execution.dependOn(flag);
        }
        Task task = execution.getTask();
        this.map.get(1).wait(task, delay * 50L);
        RenderedTask renderedTask = execution;
        if (renderedTask == null) {
            TaskMonitor.$$$reportNull$$$0(26);
        }
        return renderedTask;
    }

    @NotNull
    public RenderedTask scheduleTimer(Task data, String key, long delay, long period, BukkitTaskPredicate<?> ... flags) {
        RenderedTask execution = RenderedTask.of(data, key, 0, delay * 50L, period * 50L);
        execution.dependOn(BukkitTaskPredicate.reduceEmpty());
        execution.dependOn(BukkitTaskPredicate.reduceEmpty());
        for (BukkitTaskPredicate<Task> flag : this.flagClass.cast(flags)) {
            execution.dependOn(flag);
        }
        Task task = execution.getTask();
        this.map.get(0).repeat(task, delay * 50L, period * 50L);
        RenderedTask renderedTask = execution;
        if (renderedTask == null) {
            TaskMonitor.$$$reportNull$$$0(27);
        }
        return renderedTask;
    }

    @NotNull
    public RenderedTask scheduleTimerAsync(Task data, String key, long delay, long period, BukkitTaskPredicate<?> ... flags) {
        RenderedTask execution = RenderedTask.of(data, key, 1, delay * 50L, period * 50L);
        execution.dependOn(BukkitTaskPredicate.reduceEmpty());
        execution.dependOn(BukkitTaskPredicate.reduceEmpty());
        for (BukkitTaskPredicate<Task> flag : this.flagClass.cast(flags)) {
            execution.dependOn(flag);
        }
        Task task = execution.getTask();
        this.map.get(1).repeat(task, delay * 50L, period * 50L);
        RenderedTask renderedTask = execution;
        if (renderedTask == null) {
            TaskMonitor.$$$reportNull$$$0(28);
        }
        return renderedTask;
    }

    @NotNull
    public RenderedTask schedule(RenderedTask execution) {
        int runtime = execution.getRuntime();
        Task task = (Task)OrdinalProcedure.select(execution, 0).cast(() -> Task.class);
        switch (execution.getType()) {
            case SINGULAR: {
                LabyrinthProvider.getInstance().getScheduler(runtime).run(task);
                break;
            }
            case DELAYED: {
                LabyrinthProvider.getInstance().getScheduler(runtime).wait(task, execution.getDelay());
                break;
            }
            case REPEATABLE: {
                LabyrinthProvider.getInstance().getScheduler(runtime).repeat(task, execution.getDelay(), execution.getPeriod());
            }
        }
        RenderedTask renderedTask = execution;
        if (renderedTask == null) {
            TaskMonitor.$$$reportNull$$$0(29);
        }
        return renderedTask;
    }

    public static TaskMonitor getLocalInstance() {
        return instance != null ? instance : (instance = new TaskMonitor());
    }

    public static void setInstance(@NotNull TaskMonitor monitor) {
        if (monitor == null) {
            TaskMonitor.$$$reportNull$$$0(30);
        }
        instance = monitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/github/sanctum/labyrinth/task/TaskMonitor";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "monitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/github/sanctum/labyrinth/task/TaskMonitor";
                break;
            }
            case 1: 
            case 15: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "schedule";
                break;
            }
            case 2: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "scheduleAsync";
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 17: 
            case 18: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "scheduleLater";
                break;
            }
            case 5: 
            case 6: 
            case 11: 
            case 12: 
            case 19: 
            case 20: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "scheduleLaterAsync";
                break;
            }
            case 7: 
            case 13: 
            case 21: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "scheduleTimer";
                break;
            }
            case 8: 
            case 14: 
            case 22: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "scheduleTimerAsync";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "setInstance";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

