/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth.task;

import com.github.sanctum.panther.annotation.Ordinal;
import com.github.sanctum.panther.util.Task;
import com.github.sanctum.panther.util.TaskChain;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitScheduler;
import org.jetbrains.annotations.NotNull;

public final class SynchronousTaskChain
extends TaskChain {
    final BukkitScheduler timer;
    final Task.Synchronizer synchronizer;
    final Plugin host;

    public SynchronousTaskChain(Plugin host) {
        this.host = host;
        this.timer = Bukkit.getScheduler();
        this.synchronizer = runnable -> this.timer.runTask(host, runnable);
    }

    @Override
    public SynchronousTaskChain run(@NotNull Task task) {
        if (task == null) {
            SynchronousTaskChain.$$$reportNull$$$0(0);
        }
        task.setFuture(this.defaultTimer.submit(task.setChain(this).setSynchronizer(this.synchronizer)));
        return this;
    }

    @Override
    public SynchronousTaskChain run(final @NotNull Runnable data) {
        if (data == null) {
            SynchronousTaskChain.$$$reportNull$$$0(1);
        }
        Task task = new Task("dummy", 0, this){
            private static final long serialVersionUID = 8068952665686647490L;

            @Ordinal
            public void execute() {
                data.run();
            }
        };
        task.setFuture(this.defaultTimer.submit(task.setChain(this).setSynchronizer(this.synchronizer)));
        return this;
    }

    @Override
    @NotNull
    public SynchronousTaskChain wait(@NotNull Task task) {
        if (task == null) {
            SynchronousTaskChain.$$$reportNull$$$0(2);
        }
        if (!task.getClass().isAnnotationPresent(Task.Delay.class)) {
            throw new IllegalStateException("Task Delay annotation missing!");
        }
        long time = task.getClass().getAnnotation(Task.Delay.class).value();
        SynchronousTaskChain synchronousTaskChain = this.wait(task, time);
        if (synchronousTaskChain == null) {
            SynchronousTaskChain.$$$reportNull$$$0(3);
        }
        return synchronousTaskChain;
    }

    @Override
    public SynchronousTaskChain wait(@NotNull Task task, long delay) {
        if (task == null) {
            SynchronousTaskChain.$$$reportNull$$$0(4);
        }
        task.setFuture(this.defaultTimer.schedule(task.setChain(this).setSynchronizer(this.synchronizer), delay, TimeUnit.MILLISECONDS));
        this.map.put(task.getKey(), task);
        return this;
    }

    @Override
    @NotNull
    public SynchronousTaskChain wait(final @NotNull Runnable data, long delay) {
        if (data == null) {
            SynchronousTaskChain.$$$reportNull$$$0(5);
        }
        Task task = new Task(UUID.randomUUID().toString(), 0, this){
            private static final long serialVersionUID = 4057999550419202270L;

            @Ordinal
            public void execute() {
                data.run();
            }
        };
        SynchronousTaskChain synchronousTaskChain = this.wait(task, delay);
        if (synchronousTaskChain == null) {
            SynchronousTaskChain.$$$reportNull$$$0(6);
        }
        return synchronousTaskChain;
    }

    @Override
    public SynchronousTaskChain wait(final @NotNull Runnable data, String key, long delay) {
        if (data == null) {
            SynchronousTaskChain.$$$reportNull$$$0(7);
        }
        Task task = new Task(key, 0, this){
            private static final long serialVersionUID = 4057999550419202270L;

            @Ordinal
            public void execute() {
                data.run();
            }
        };
        this.map.put(key, task);
        task.setFuture(this.defaultTimer.schedule(task.setChain(this).setSynchronizer(this.synchronizer), delay, TimeUnit.MILLISECONDS));
        return this;
    }

    @Override
    @NotNull
    public SynchronousTaskChain repeat(@NotNull Task task) {
        if (task == null) {
            SynchronousTaskChain.$$$reportNull$$$0(8);
        }
        if (!task.getClass().isAnnotationPresent(Task.Delay.class)) {
            throw new IllegalStateException("Task Delay annotation missing!");
        }
        long delay = task.getClass().getAnnotation(Task.Delay.class).value();
        if (!task.getClass().isAnnotationPresent(Task.Period.class)) {
            throw new IllegalStateException("Task Period annotation missing!");
        }
        long period = task.getClass().getAnnotation(Task.Period.class).value();
        SynchronousTaskChain synchronousTaskChain = this.repeat(task, delay, period);
        if (synchronousTaskChain == null) {
            SynchronousTaskChain.$$$reportNull$$$0(9);
        }
        return synchronousTaskChain;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public SynchronousTaskChain repeat(@NotNull Task task, long delay, long l) {
        if (task == null) {
            SynchronousTaskChain.$$$reportNull$$$0(10);
        }
        if (!this.map.containsKey(task.getKey())) {
            void period;
            this.map.put(task.getKey(), task);
            task.setFuture(this.defaultTimer.scheduleAtFixedRate(task.setChain(this).setSynchronizer(this.synchronizer), delay, (long)period, TimeUnit.MILLISECONDS));
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public SynchronousTaskChain repeat(@NotNull Runnable data, long delay, long l) {
        void period;
        if (data == null) {
            SynchronousTaskChain.$$$reportNull$$$0(11);
        }
        SynchronousTaskChain synchronousTaskChain = this.repeat(data, UUID.randomUUID().toString(), delay, (long)period);
        if (synchronousTaskChain == null) {
            SynchronousTaskChain.$$$reportNull$$$0(12);
        }
        return synchronousTaskChain;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public SynchronousTaskChain repeat(final @NotNull Runnable data, @NotNull String key, long delay, long l) {
        void period;
        if (data == null) {
            SynchronousTaskChain.$$$reportNull$$$0(13);
        }
        if (key == null) {
            SynchronousTaskChain.$$$reportNull$$$0(14);
        }
        Task task = new Task(key, 0, this){
            private static final long serialVersionUID = 4057999550419202270L;

            @Ordinal
            public void execute() {
                data.run();
            }
        };
        SynchronousTaskChain synchronousTaskChain = this.repeat(task, delay, (long)period);
        if (synchronousTaskChain == null) {
            SynchronousTaskChain.$$$reportNull$$$0(15);
        }
        return synchronousTaskChain;
    }

    @Override
    @NotNull
    public <T> Future<T> submit(@NotNull Callable<T> data) {
        if (data == null) {
            SynchronousTaskChain.$$$reportNull$$$0(16);
        }
        Future<T> future = this.defaultTimer.submit(data);
        if (future == null) {
            SynchronousTaskChain.$$$reportNull$$$0(17);
        }
        return future;
    }

    @Override
    @NotNull
    public <T> Future<T> submit(@NotNull Callable<T> data, long delay) {
        if (data == null) {
            SynchronousTaskChain.$$$reportNull$$$0(18);
        }
        ScheduledFuture<T> scheduledFuture = this.defaultTimer.schedule(data, delay * 50L, TimeUnit.MILLISECONDS);
        if (scheduledFuture == null) {
            SynchronousTaskChain.$$$reportNull$$$0(19);
        }
        return scheduledFuture;
    }

    @Override
    @NotNull
    public <T> List<Future<T>> submit(@NotNull Collection<Callable<T>> data, long delay) throws InterruptedException {
        if (data == null) {
            SynchronousTaskChain.$$$reportNull$$$0(20);
        }
        List<Future<T>> list = this.defaultTimer.invokeAll(data, delay * 50L, TimeUnit.MILLISECONDS);
        if (list == null) {
            SynchronousTaskChain.$$$reportNull$$$0(21);
        }
        return list;
    }

    @Override
    public boolean shutdown() {
        if (!this.map.isEmpty()) {
            this.map.values().forEach(Task::cancel);
            this.map.clear();
            this.defaultTimer.shutdown();
            return true;
        }
        return false;
    }

    @Override
    public Task get(String key) {
        return (Task)this.map.get(key);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 12: 
            case 15: 
            case 17: 
            case 19: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 12: 
            case 15: 
            case 17: 
            case 19: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 11: 
            case 13: 
            case 16: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 12: 
            case 15: 
            case 17: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/github/sanctum/labyrinth/task/SynchronousTaskChain";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/github/sanctum/labyrinth/task/SynchronousTaskChain";
                break;
            }
            case 3: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "wait";
                break;
            }
            case 9: 
            case 12: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "repeat";
                break;
            }
            case 17: 
            case 19: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "submit";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "run";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "wait";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 12: 
            case 15: 
            case 17: 
            case 19: 
            case 21: {
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "repeat";
                break;
            }
            case 16: 
            case 18: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "submit";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 12: 
            case 15: 
            case 17: 
            case 19: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

