/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth.task;

import com.github.sanctum.labyrinth.LabyrinthProvider;
import com.github.sanctum.labyrinth.api.TaskService;
import com.github.sanctum.labyrinth.library.TimeWatch;
import com.github.sanctum.labyrinth.task.BukkitTaskPredicate;
import com.github.sanctum.labyrinth.task.TaskMonitor;
import com.github.sanctum.labyrinth.task.TaskScheduler;
import com.github.sanctum.panther.annotation.FieldsFrom;
import com.github.sanctum.panther.annotation.Note;
import com.github.sanctum.panther.annotation.Ordinal;
import com.github.sanctum.panther.util.RandomID;
import com.github.sanctum.panther.util.Task;
import com.github.sanctum.panther.util.TaskChain;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface RenderedTask {
    @FieldsFrom(value=TaskService.class)
    public int getRuntime();

    public long getDelay();

    public long getPeriod();

    public boolean isRunning();

    @Nullable
    public String getId();

    @NotNull
    public Type getType();

    @NotNull
    default public Task getTask() {
        Task task = Objects.requireNonNull(TaskMonitor.getLocalInstance().get(Objects.requireNonNull(this.getId())));
        if (task == null) {
            RenderedTask.$$$reportNull$$$0(0);
        }
        return task;
    }

    @NotNull
    public TimeWatch getLastRendered();

    @NotNull
    public RenderedTask dependOn(@NotNull BukkitTaskPredicate<? super Task> var1);

    @Note(value="Check if this task is either scheduled on delay or concurrence.")
    default public @Note(value="Check if this task is either scheduled on delay or concurrence.") boolean isConcurrent() {
        return this.getId() != null;
    }

    @NotNull
    default public TaskScheduler next(@NotNull Runnable data) {
        if (data == null) {
            RenderedTask.$$$reportNull$$$0(1);
        }
        TaskScheduler taskScheduler = TaskScheduler.of(data);
        if (taskScheduler == null) {
            RenderedTask.$$$reportNull$$$0(2);
        }
        return taskScheduler;
    }

    @NotNull
    default public RenderedTask runAgain() {
        if (this.isRunning()) {
            RenderedTask renderedTask = this;
            if (renderedTask == null) {
                RenderedTask.$$$reportNull$$$0(3);
            }
            return renderedTask;
        }
        RenderedTask renderedTask = TaskMonitor.getLocalInstance().schedule(this);
        if (renderedTask == null) {
            RenderedTask.$$$reportNull$$$0(4);
        }
        return renderedTask;
    }

    @Nullable
    default public RenderedTask runAgain(int count, boolean progressively) throws IllegalStateException {
        if (this.isConcurrent()) {
            throw new IllegalStateException("Concurrent operations cannot be stacked!");
        }
        if (this.isRunning()) {
            return this;
        }
        for (int i = 0; i < count; ++i) {
            if (progressively) {
                this.next(() -> TaskMonitor.getLocalInstance().schedule(this)).scheduleLater(i);
                continue;
            }
            TaskMonitor.getLocalInstance().schedule(this);
        }
        return this;
    }

    @NotNull
    public static <T extends Task> RenderedTask of(final T data, final int runtime) {
        return new RenderedTask(){

            @Override
            public int getRuntime() {
                return runtime;
            }

            @Override
            public long getDelay() {
                return 0L;
            }

            @Override
            public long getPeriod() {
                return 0L;
            }

            @Override
            public boolean isRunning() {
                return data != null && !data.isCancelled();
            }

            @Override
            @Ordinal
            @NotNull
            public Task getTask() {
                Task task = data;
                if (task == null) {
                    1.$$$reportNull$$$0(0);
                }
                return task;
            }

            @Override
            @Nullable
            public String getId() {
                return null;
            }

            @Override
            @NotNull
            public Type getType() {
                Type type = Type.SINGULAR;
                if (type == null) {
                    1.$$$reportNull$$$0(1);
                }
                return type;
            }

            @Override
            @NotNull
            public TimeWatch getLastRendered() {
                TimeWatch timeWatch = TimeWatch.start(420L);
                if (timeWatch == null) {
                    1.$$$reportNull$$$0(2);
                }
                return timeWatch;
            }

            @Override
            @NotNull
            public RenderedTask dependOn(@NotNull BukkitTaskPredicate<? super Task> intent) {
                if (intent == null) {
                    1.$$$reportNull$$$0(3);
                }
                data.listen(intent);
                1 v0 = this;
                if (v0 == null) {
                    1.$$$reportNull$$$0(4);
                }
                return v0;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 3: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 3: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/github/sanctum/labyrinth/task/RenderedTask$1";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "intent";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getTask";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getType";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getLastRendered";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/github/sanctum/labyrinth/task/RenderedTask$1";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "dependOn";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "dependOn";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 3: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    @NotNull
    public static <T extends Task> RenderedTask of(final T data, final @Nullable String key, final int runtime, final long delay, final long period) {
        return new RenderedTask(){

            @Override
            public int getRuntime() {
                return runtime;
            }

            @Override
            public boolean isRunning() {
                return data != null && !data.isCancelled();
            }

            @Override
            @Ordinal
            @NotNull
            public Task getTask() {
                Task task = data;
                if (task == null) {
                    2.$$$reportNull$$$0(0);
                }
                return task;
            }

            @Override
            @Nullable
            public String getId() {
                return key;
            }

            @Override
            @NotNull
            public Type getType() {
                Type type = this.isConcurrent() && this.getDelay() != 0L && this.getPeriod() != 0L ? Type.REPEATABLE : Type.DELAYED;
                if (type == null) {
                    2.$$$reportNull$$$0(1);
                }
                return type;
            }

            @Override
            @NotNull
            public TimeWatch getLastRendered() {
                TimeWatch timeWatch = TimeWatch.start(420L);
                if (timeWatch == null) {
                    2.$$$reportNull$$$0(2);
                }
                return timeWatch;
            }

            @Override
            @NotNull
            public RenderedTask dependOn(@NotNull BukkitTaskPredicate<? super Task> intent) {
                if (intent == null) {
                    2.$$$reportNull$$$0(3);
                }
                switch (this.getRuntime()) {
                    case 0: {
                        TaskScheduler.of(() -> data.listen(intent)).schedule();
                        break;
                    }
                    case 1: {
                        TaskScheduler.of(() -> data.listen(intent)).scheduleAsync();
                    }
                }
                2 v0 = this;
                if (v0 == null) {
                    2.$$$reportNull$$$0(4);
                }
                return v0;
            }

            @Override
            public long getDelay() {
                if (delay != -1L) {
                    return delay;
                }
                return 0L;
            }

            @Override
            public long getPeriod() {
                if (period != -1L) {
                    return period;
                }
                return 0L;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 3: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 3: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/github/sanctum/labyrinth/task/RenderedTask$2";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "intent";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getTask";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getType";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getLastRendered";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/github/sanctum/labyrinth/task/RenderedTask$2";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "dependOn";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "dependOn";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 3: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    @NotNull
    public static RenderedTask of(final Runnable data, final int runtime) {
        return new RenderedTask(){
            private final Task task;
            {
                this.task = new Task(new RandomID().generate(), TaskChain.getChain(runtime), data){
                    private static final long serialVersionUID = 87916092504686934L;
                };
            }

            @Override
            public int getRuntime() {
                return runtime;
            }

            @Override
            public long getDelay() {
                return 0L;
            }

            @Override
            public long getPeriod() {
                return 0L;
            }

            @Override
            public boolean isRunning() {
                return LabyrinthProvider.getInstance().getScheduler(this.getRuntime()).get(this.getTask().getKey()) != null;
            }

            @Override
            @Ordinal
            @NotNull
            public Task getTask() {
                Task task = this.task;
                if (task == null) {
                    3.$$$reportNull$$$0(0);
                }
                return task;
            }

            @Override
            @Nullable
            public String getId() {
                return null;
            }

            @Override
            @NotNull
            public Type getType() {
                Type type = Type.SINGULAR;
                if (type == null) {
                    3.$$$reportNull$$$0(1);
                }
                return type;
            }

            @Override
            @NotNull
            public TimeWatch getLastRendered() {
                TimeWatch timeWatch = TimeWatch.start(420L);
                if (timeWatch == null) {
                    3.$$$reportNull$$$0(2);
                }
                return timeWatch;
            }

            @Override
            @NotNull
            public RenderedTask dependOn(@NotNull BukkitTaskPredicate<? super Task> intent) {
                if (intent == null) {
                    3.$$$reportNull$$$0(3);
                }
                3 v0 = this;
                if (v0 == null) {
                    3.$$$reportNull$$$0(4);
                }
                return v0;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 3: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 3: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/github/sanctum/labyrinth/task/RenderedTask$3";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "intent";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getTask";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getType";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getLastRendered";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/github/sanctum/labyrinth/task/RenderedTask$3";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "dependOn";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "dependOn";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 3: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    @NotNull
    public static RenderedTask of(final Runnable data, final @Nullable String key, final int runtime, final long delay, final long period) {
        return new RenderedTask(){
            private final Task task;
            {
                this.task = new Task(key != null ? key : new RandomID().generate(), TaskChain.getChain(runtime), data){
                    private static final long serialVersionUID = 2948251326991055359L;
                };
            }

            @Override
            public int getRuntime() {
                return runtime;
            }

            @Override
            public boolean isRunning() {
                return LabyrinthProvider.getInstance().getScheduler(this.getRuntime()).get(this.getTask().getKey()) != null;
            }

            @Override
            @Ordinal
            @NotNull
            public Task getTask() {
                Task task = this.task;
                if (task == null) {
                    4.$$$reportNull$$$0(0);
                }
                return task;
            }

            @Override
            @Nullable
            public String getId() {
                return key;
            }

            @Override
            @NotNull
            public Type getType() {
                Type type = this.isConcurrent() && this.getDelay() != 0L && this.getPeriod() != 0L ? Type.REPEATABLE : Type.DELAYED;
                if (type == null) {
                    4.$$$reportNull$$$0(1);
                }
                return type;
            }

            @Override
            @NotNull
            public TimeWatch getLastRendered() {
                TimeWatch timeWatch = TimeWatch.start(420L);
                if (timeWatch == null) {
                    4.$$$reportNull$$$0(2);
                }
                return timeWatch;
            }

            @Override
            @NotNull
            public RenderedTask dependOn(@NotNull BukkitTaskPredicate<? super Task> intent) {
                if (intent == null) {
                    4.$$$reportNull$$$0(3);
                }
                switch (this.getRuntime()) {
                    case 0: {
                        TaskScheduler.of(() -> this.task.listen(intent)).schedule();
                        break;
                    }
                    case 1: {
                        TaskScheduler.of(() -> this.task.listen(intent)).scheduleAsync();
                    }
                }
                4 v0 = this;
                if (v0 == null) {
                    4.$$$reportNull$$$0(4);
                }
                return v0;
            }

            @Override
            public long getDelay() {
                if (delay != -1L) {
                    return delay;
                }
                return 0L;
            }

            @Override
            public long getPeriod() {
                if (period != -1L) {
                    return period;
                }
                return 0L;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 3: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 3: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/github/sanctum/labyrinth/task/RenderedTask$4";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "intent";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getTask";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getType";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getLastRendered";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/github/sanctum/labyrinth/task/RenderedTask$4";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "dependOn";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "dependOn";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 3: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/github/sanctum/labyrinth/task/RenderedTask";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTask";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/github/sanctum/labyrinth/task/RenderedTask";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "next";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "runAgain";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "next";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum Type {
        SINGULAR,
        DELAYED,
        REPEATABLE;

    }
}

