/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth.library;

import com.github.sanctum.labyrinth.LabyrinthProvider;
import com.github.sanctum.labyrinth.formatting.FancyMessage;
import com.github.sanctum.labyrinth.formatting.Message;
import com.github.sanctum.labyrinth.library.StringUtils;
import com.github.sanctum.panther.annotation.Experimental;
import net.md_5.bungee.api.chat.BaseComponent;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;

@Experimental(atRisk=true, dueTo="NMS dependence. No spigot component support.")
public class WrittenBook {
    ItemStack book = new ItemStack(Material.WRITTEN_BOOK);
    BookMeta bookMeta = (BookMeta)this.book.getItemMeta();
    int lines = 0;
    String title;
    FancyMessage current = new FancyMessage();

    public WrittenBook setTitle(String title) {
        this.bookMeta.setTitle(StringUtils.use(title).translate());
        this.title = title;
        return this;
    }

    public WrittenBook setAuthor(String author) {
        this.bookMeta.setAuthor(author);
        return this;
    }

    public WrittenBook add(BaseComponent[] ... components) {
        this.bookMeta.spigot().addPage(components);
        return this;
    }

    public WrittenBook add(Message message) {
        if (this.lines >= 13) {
            this.bookMeta.spigot().addPage((BaseComponent[][])new BaseComponent[][]{this.current.build()});
            this.lines = 0;
            this.current = new FancyMessage(this.title).then("\n").append(message).then("\n");
        } else if (this.lines == 0) {
            this.current.append(message);
        } else {
            this.current.append(message).then("\n");
        }
        this.lines += message.length();
        return this;
    }

    public void give(Player p) {
        if (this.bookMeta.spigot().getPages().size() == 0 && this.lines > 0) {
            this.bookMeta.spigot().addPage((BaseComponent[][])new BaseComponent[][]{this.current.build()});
            this.lines = 0;
            this.current = new FancyMessage(this.title).then("\n");
        }
        this.book.setItemMeta((ItemMeta)this.bookMeta);
        LabyrinthProvider.getInstance().getItemComposter().add(this.book, p);
    }
}

