/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth.library;

import com.github.sanctum.panther.util.ParsedTimeFormat;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public class TimeWatch {
    private final long time;

    public static TimeWatch start(long milli) {
        return new TimeWatch(milli);
    }

    public static TimeWatch start(Date date) {
        return new TimeWatch(date);
    }

    protected TimeWatch(long milli) {
        this.time = milli;
    }

    protected TimeWatch(Date date) {
        this.time = date.getTime();
    }

    public Date getStart() {
        return new Date(this.time);
    }

    public Duration interval(Instant stop) {
        return Duration.between(this.getStart().toInstant(), stop);
    }

    public boolean isBetween(TimeUnit threshold, long time) {
        switch (threshold) {
            case DAYS: {
                return TimeUnit.SECONDS.toDays(this.interval(Instant.now()).getSeconds()) <= time;
            }
            case HOURS: {
                return TimeUnit.SECONDS.toHours(this.interval(Instant.now()).getSeconds()) <= time;
            }
            case MINUTES: {
                return TimeUnit.SECONDS.toMinutes(this.interval(Instant.now()).getSeconds()) <= time;
            }
            case SECONDS: {
                return TimeUnit.SECONDS.toSeconds(this.interval(Instant.now()).getSeconds()) <= time;
            }
        }
        return false;
    }

    public boolean isGreaterThan(TimeUnit threshold, long time) {
        switch (threshold) {
            case DAYS: {
                return TimeUnit.SECONDS.toDays(this.interval(Instant.now()).getSeconds()) >= time;
            }
            case HOURS: {
                return TimeUnit.SECONDS.toHours(this.interval(Instant.now()).getSeconds()) >= time;
            }
            case MINUTES: {
                return TimeUnit.SECONDS.toMinutes(this.interval(Instant.now()).getSeconds()) >= time;
            }
            case SECONDS: {
                return TimeUnit.SECONDS.toSeconds(this.interval(Instant.now()).getSeconds()) >= time;
            }
        }
        return false;
    }

    public Recording toRecording() {
        return Recording.subtract(this.time);
    }

    public static class Recording
    implements ParsedTimeFormat {
        private final long time;

        protected Recording(long milli) {
            this.time = milli;
        }

        public static Recording from(long milli) {
            return new Recording(milli);
        }

        public static Recording subtract(long milli) {
            return new Recording(System.currentTimeMillis() - milli);
        }

        @Override
        public long getSeconds() {
            return this.time / 1000L % 60L;
        }

        @Override
        public long getMinutes() {
            return this.time / 60000L % 60L;
        }

        @Override
        public long getHours() {
            return this.time / 3600000L;
        }

        @Override
        public long getDays() {
            return this.time / 86400000L;
        }

        public String toString() {
            return this.getDays() + " days " + this.getHours() + " hours " + this.getMinutes() + " minutes " + this.getSeconds() + " seconds.";
        }
    }
}

