/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth.library;

import com.github.sanctum.labyrinth.interfacing.JsonIntermediate;
import com.github.sanctum.labyrinth.library.LabyrinthJsonObjectWrapper;
import com.github.sanctum.panther.file.Configurable;
import com.github.sanctum.panther.file.JsonAdapter;
import com.github.sanctum.panther.util.OrdinalProcedure;
import com.github.sanctum.panther.util.TypeAdapter;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Map;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.util.io.BukkitObjectOutputStream;

final class LabyrinthObjectOutputStream
extends BukkitObjectOutputStream {
    LabyrinthObjectOutputStream(OutputStream out) throws IOException {
        super(out);
    }

    protected Object replaceObject(Object obj) throws IOException {
        JsonAdapter<?> adapter;
        if (!(obj instanceof Serializable) && !(obj instanceof ConfigurationSerializable) && (adapter = Configurable.getAdapter(obj.getClass())) != null) {
            String pointer = OrdinalProcedure.select(adapter, 24).cast(TypeAdapter.STRING);
            JsonElement element = adapter.write(obj);
            if (element.isJsonObject()) {
                obj = new LabyrinthJsonObjectWrapper<Map<String, Object>>(JsonIntermediate.convertToMap(element.getAsJsonObject()), pointer);
            } else {
                throw new IOException("Unable to serialize json information @ " + obj.getClass().getName() + " using " + adapter.getClass().getSimpleName());
            }
        }
        return super.replaceObject((Object)obj);
    }
}

