/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth.library;

import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public enum DirectivePoint {
    North_East(225.0f, -0.0f),
    North(180.0f, -0.0f),
    North_West(135.0f, -0.0f),
    West(90.0f, 0.0f),
    South_West(45.0f, 0.0f),
    South(360.0f, 0.0f),
    South_East(315.0f, 0.0f),
    East(270.0f, 0.0f);

    private final float yaw;
    private final float pitch;

    private DirectivePoint(float yaw, float pitch) {
        this.yaw = yaw;
        this.pitch = pitch;
    }

    public float getCenteredYaw() {
        return this.yaw;
    }

    public float getCenteredPitch() {
        return this.pitch;
    }

    public BlockFace toFace() {
        switch (this) {
            case North_East: {
                return BlockFace.NORTH_EAST;
            }
            case North: {
                return BlockFace.NORTH;
            }
            case North_West: {
                return BlockFace.NORTH_WEST;
            }
            case West: {
                return BlockFace.WEST;
            }
            case South_West: {
                return BlockFace.SOUTH_WEST;
            }
            case South: {
                return BlockFace.SOUTH;
            }
            case South_East: {
                return BlockFace.SOUTH_EAST;
            }
            case East: {
                return BlockFace.EAST;
            }
        }
        return null;
    }

    public Chunk getChunk(Location start, int distanceInChunks) {
        double p = (double)(this.pitch + 90.0f) * Math.PI / 180.0;
        double ya = (double)(this.yaw + 90.0f) * Math.PI / 180.0;
        int dist = 16 * distanceInChunks;
        start.setYaw(this.getCenteredYaw());
        start.setPitch(this.getCenteredPitch());
        double x = Math.sin(p) * Math.cos(ya);
        double y = Math.sin(p) * Math.sin(ya);
        double z = Math.cos(p);
        start.setDirection(new Vector(x, y, z));
        start.setYaw(this.getCenteredYaw());
        start.setPitch(this.getCenteredPitch());
        Location finish = start.add(start.getDirection().normalize().multiply(dist));
        return finish.getChunk();
    }

    public Location getLocation(Location start, int distanceInBlocks) {
        double p = (double)(this.pitch + 90.0f) * Math.PI / 180.0;
        double ya = (double)(this.yaw + 90.0f) * Math.PI / 180.0;
        start.setYaw(this.getCenteredYaw());
        start.setPitch(this.getCenteredPitch());
        double x = Math.sin(p) * Math.cos(ya);
        double y = Math.sin(p) * Math.sin(ya);
        double z = Math.cos(p);
        start.setDirection(new Vector(x, y, z));
        start.setYaw(this.getCenteredYaw());
        start.setPitch(this.getCenteredPitch());
        for (int i = 0; i < distanceInBlocks; ++i) {
            start.add(start.getDirection().normalize());
        }
        return start;
    }

    public Chunk getChunk(Chunk start, int distanceInChunks) {
        double p = (double)(this.pitch + 90.0f) * Math.PI / 180.0;
        double ya = (double)(this.yaw + 90.0f) * Math.PI / 180.0;
        int x = start.getX();
        int y = 85;
        int z = start.getZ();
        String world = start.getWorld().getName();
        Location center = new Location(Bukkit.getWorld((String)world), (double)(x << 4), (double)y, (double)(z << 4)).add(7.0, 0.0, 7.0);
        int dist = 16 * distanceInChunks;
        center.setYaw(this.getCenteredYaw());
        center.setPitch(this.getCenteredPitch());
        double x1 = Math.sin(p) * Math.cos(ya);
        double y1 = Math.sin(p) * Math.sin(ya);
        double z1 = Math.cos(p);
        center.setDirection(new Vector(x1, y1, z1));
        center.setYaw(this.getCenteredYaw());
        center.setPitch(this.getCenteredPitch());
        Location finish = center.add(center.getDirection().normalize().multiply(dist));
        return finish.getChunk();
    }

    public static DirectivePoint getLeft(DirectivePoint point) {
        DirectivePoint result = null;
        switch (point) {
            case North_East: {
                result = North;
                break;
            }
            case North: {
                result = North_West;
                break;
            }
            case North_West: {
                result = West;
                break;
            }
            case West: {
                result = South_West;
                break;
            }
            case South_West: {
                result = South;
                break;
            }
            case South: {
                result = South_East;
                break;
            }
            case South_East: {
                result = East;
                break;
            }
            case East: {
                result = North_East;
            }
        }
        return result;
    }

    public static DirectivePoint getRight(DirectivePoint point) {
        DirectivePoint result = null;
        switch (point) {
            case North_East: {
                result = East;
                break;
            }
            case North: {
                result = North_East;
                break;
            }
            case North_West: {
                result = North;
                break;
            }
            case West: {
                result = North_West;
                break;
            }
            case South_West: {
                result = West;
                break;
            }
            case South: {
                result = South_West;
                break;
            }
            case South_East: {
                result = South;
                break;
            }
            case East: {
                result = South_East;
            }
        }
        return result;
    }

    public static DirectivePoint get(Player p) {
        return DirectivePoint.get(p.getLocation());
    }

    static DirectivePoint get(Location loc) {
        DirectivePoint result;
        float y = loc.getYaw();
        if (y < 0.0f) {
            y += 360.0f;
        }
        int i = (int)((double)((y %= 360.0f) + 8.0f) / 22.5);
        switch (i) {
            case 1: 
            case 2: 
            case 3: {
                result = South_West;
                break;
            }
            case 4: {
                result = West;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                result = North_West;
                break;
            }
            case 8: {
                result = North;
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                result = North_East;
                break;
            }
            case 12: {
                result = East;
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                result = South_East;
                break;
            }
            default: {
                result = South;
            }
        }
        return result;
    }
}

