/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth.library;

import com.github.sanctum.labyrinth.LabyrinthProvider;
import com.github.sanctum.labyrinth.api.CooldownService;
import com.github.sanctum.labyrinth.api.Service;
import com.github.sanctum.labyrinth.data.FileList;
import com.github.sanctum.labyrinth.task.TaskScheduler;
import com.github.sanctum.panther.file.Configurable;
import com.github.sanctum.panther.util.ParsedTimeFormat;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.TextStyle;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public abstract class Cooldown
implements ParsedTimeFormat {
    private static final CooldownService SERVICE = LabyrinthProvider.getService(Service.COOLDOWNS);
    private String format = "&e{DAYS} &rDays &e{HOURS} &rHours &e{MINUTES} &rMinutes &e{SECONDS} &rSeconds";

    public abstract String getId();

    public String getDescriptor() {
        return "";
    }

    public abstract long getCooldown();

    public final long getTimePassed() {
        return (System.currentTimeMillis() - this.getCooldown()) / 1000L;
    }

    @Override
    public long getDays() {
        return TimeUnit.SECONDS.toDays(this.getTimePassed());
    }

    @Override
    public long getHours() {
        return TimeUnit.SECONDS.toHours(this.getTimePassed()) - this.getDays() * 24L;
    }

    @Override
    public long getMinutes() {
        return TimeUnit.SECONDS.toMinutes(this.getTimePassed()) - TimeUnit.SECONDS.toHours(this.getTimePassed()) * 60L;
    }

    @Override
    public long getSeconds() {
        return TimeUnit.SECONDS.toSeconds(this.getTimePassed()) - TimeUnit.SECONDS.toMinutes(this.getTimePassed()) * 60L;
    }

    public final boolean isComplete() {
        Long a = this.getCooldown();
        Long b = System.currentTimeMillis();
        int compareNum = a.compareTo(b);
        return SERVICE.getCooldowns().contains(this) && compareNum <= 0;
    }

    public Cooldown format(String format) {
        this.format = format;
        return this;
    }

    public String toFormat() {
        return this.format.replace("{DAYS}", "" + this.getDays()).replace("{HOURS}", "" + this.getHours()).replace("{MINUTES}", "" + this.getMinutes()).replace("{SECONDS}", "" + this.getSeconds());
    }

    public final synchronized void remove() {
        SERVICE.remove(this);
    }

    public final synchronized void save() throws IllegalStateException {
        if (SERVICE.getCooldown(this.getId()) != null) {
            throw new IllegalStateException("Cooldown already cached!");
        }
        FileList.search(LabyrinthProvider.getInstance().getPluginInstance()).get("cooldowns", "Persistent", Configurable.Type.JSON).write(t -> {
            t.set("Library." + this.getId() + ".expiration", this.getCooldown());
            if (this.getDescriptor() != null && !this.getDescriptor().isEmpty()) {
                t.set("Library." + this.getId() + ".descriptor", this.getDescriptor());
            }
        });
        TaskScheduler.of(() -> SERVICE.getCooldowns().add(this)).schedule();
    }

    public final synchronized void update() {
        FileList.search(LabyrinthProvider.getInstance().getPluginInstance()).get("cooldowns", "Persistent", Configurable.Type.JSON).write(t -> t.set("Library." + this.getId() + ".expiration", this.abv(this.getTimePassed())));
    }

    protected final long abv(long seconds) {
        return System.currentTimeMillis() + seconds * 1000L;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Cooldown)) {
            return false;
        }
        Cooldown cool = (Cooldown)o;
        return Objects.equals(this.getId(), cool.getId());
    }

    public int hashCode() {
        return Objects.hash(this.getId());
    }

    public String toString() {
        ZonedDateTime time = new Date().toInstant().atZone(ZoneId.systemDefault());
        String month = time.getMonth().getDisplayName(TextStyle.FULL, Locale.ENGLISH);
        String year = String.valueOf(time.getYear());
        String day = String.valueOf((long)time.getDayOfMonth() + this.getDays());
        Date date = this.getDate();
        ZonedDateTime current = date.toInstant().atZone(ZoneId.systemDefault());
        String clock = current.getHour() + ":" + current.getMinute();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return month + " " + day + ", " + year + " @ " + clock + (calendar.get(9) == 1 ? "pm" : "am");
    }
}

