/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth.library;

import com.github.sanctum.labyrinth.LabyrinthProvider;
import com.github.sanctum.labyrinth.command.CommandVisibilityCalculation;
import com.github.sanctum.labyrinth.data.SimpleKeyedValue;
import com.github.sanctum.panther.container.ImmutablePantherCollection;
import com.github.sanctum.panther.container.PantherCollection;
import com.github.sanctum.panther.container.PantherSet;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CommandUtils {
    static Map<String, Command> commands;
    static CommandMap commandMap;
    private static final PantherCollection<CommandVisibilityCalculation> calculations;

    public static PantherCollection<CommandVisibilityCalculation> getVisibilityCalculations() {
        return ImmutablePantherCollection.of(calculations);
    }

    public static Set<String> getServerCommandListing() {
        return Collections.unmodifiableSet(commands.keySet());
    }

    @Nullable
    public static Command getCommandByLabel(@NotNull String label) {
        if (label == null) {
            CommandUtils.$$$reportNull$$$0(0);
        }
        return commands.get(label);
    }

    public static <R> R read(@NotNull Function<SimpleKeyedValue<CommandMap, Map<String, Command>>, R> function) {
        if (function == null) {
            CommandUtils.$$$reportNull$$$0(1);
        }
        return function.apply(SimpleKeyedValue.of(commandMap, commands));
    }

    public static void register(@NotNull CommandVisibilityCalculation calculation) {
        if (calculation == null) {
            CommandUtils.$$$reportNull$$$0(2);
        }
        calculations.add(calculation);
    }

    public static void register(@NotNull Command command) {
        if (command == null) {
            CommandUtils.$$$reportNull$$$0(3);
        }
        JavaPlugin plugin = JavaPlugin.getProvidingPlugin(command.getClass());
        CommandUtils.read(arg_0 -> CommandUtils.lambda$register$0(command, (Plugin)plugin, arg_0));
    }

    public static void unregister(@NotNull Command command) {
        if (command == null) {
            CommandUtils.$$$reportNull$$$0(4);
        }
        commands.remove(command.getName());
        for (String alias : command.getAliases()) {
            if (!commands.containsKey(alias) || !commands.get(alias).getAliases().contains(alias)) continue;
            commands.remove(alias);
        }
        command.unregister(commandMap);
    }

    private static /* synthetic */ Boolean lambda$register$0(Command command, Plugin plugin, SimpleKeyedValue entry) {
        return ((CommandMap)entry.getKey()).register(command.getLabel(), plugin.getName(), command);
    }

    static {
        Map commandMappings;
        CommandMap theMap;
        calculations = new PantherSet<CommandVisibilityCalculation>();
        Plugin main = LabyrinthProvider.getInstance().getPluginInstance();
        try {
            CommandMap commandMap;
            Field commandMapField = main.getServer().getClass().getDeclaredField("commandMap");
            commandMapField.setAccessible(true);
            theMap = commandMap = (CommandMap)commandMapField.get(main.getServer());
            Field knownCommandsField = SimpleCommandMap.class.getDeclaredField("knownCommands");
            knownCommandsField.setAccessible(true);
            commandMappings = (Map)knownCommandsField.get(commandMap);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new IllegalStateException("Unable to initialize CommandUtils!");
        }
        commandMap = theMap;
        commands = commandMappings;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "calculation";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
        }
        objectArray2[1] = "com/github/sanctum/labyrinth/library/CommandUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getCommandByLabel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "read";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "register";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "unregister";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

