/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth.gui.unity.simple;

import com.github.sanctum.labyrinth.LabyrinthProvider;
import com.github.sanctum.labyrinth.gui.unity.construct.Menu;
import com.github.sanctum.labyrinth.gui.unity.construct.PaginatedMenu;
import com.github.sanctum.labyrinth.gui.unity.construct.PrintableMenu;
import com.github.sanctum.labyrinth.gui.unity.construct.SingularMenu;
import com.github.sanctum.labyrinth.gui.unity.impl.InventoryElement;
import com.github.sanctum.labyrinth.gui.unity.impl.MenuType;
import com.github.sanctum.labyrinth.gui.unity.simple.Docket;
import java.util.function.Consumer;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class DocketBuilder<T, V extends InventoryElement>
implements Docket<T> {
    final Plugin plugin = LabyrinthProvider.getInstance().getPluginInstance();
    Consumer<V> inventoryModifier;
    Menu.Type type;
    String title;
    String key;
    Menu.Rows rows;
    Menu.Open open;
    Menu.Close close;

    public DocketBuilder<T, V> setRows(Menu.Rows rows) {
        this.rows = rows;
        return this;
    }

    public DocketBuilder<T, V> setTitle(String title) {
        this.title = title;
        return this;
    }

    public DocketBuilder<T, V> setType(Menu.Type type) {
        this.type = type;
        return this;
    }

    public DocketBuilder<T, V> setStock(Consumer<V> consumer) {
        this.inventoryModifier = consumer;
        return this;
    }

    public DocketBuilder<T, V> setOpenEvent(Menu.Open open) {
        this.open = open;
        return this;
    }

    public DocketBuilder<T, V> setCloseEvent(Menu.Close close) {
        this.close = close;
        return this;
    }

    @Override
    @NotNull
    public Menu toMenu() {
        switch (this.type) {
            case PAGINATED: {
                Menu.Builder<PaginatedMenu, InventoryElement.Paginated> paginated = MenuType.PAGINATED.build().setHost(this.plugin).setTitle(this.title).setSize(this.rows);
                if (this.key != null) {
                    paginated.setKey(this.key).setProperty(Menu.Property.CACHEABLE);
                }
                if (this.open != null) {
                    paginated.setOpenEvent(this.open);
                }
                if (this.close != null) {
                    paginated.setCloseEvent(this.close);
                }
                if (this.inventoryModifier != null) {
                    paginated.setStock(this.inventoryModifier);
                }
                PaginatedMenu paginatedMenu = paginated.join();
                if (paginatedMenu == null) {
                    DocketBuilder.$$$reportNull$$$0(0);
                }
                return paginatedMenu;
            }
            case PRINTABLE: {
                Menu.Builder<PrintableMenu, InventoryElement.Printable> printable = MenuType.PRINTABLE.build().setHost(this.plugin).setTitle(this.title).setSize(this.rows);
                if (this.key != null) {
                    printable.setKey(this.key).setProperty(Menu.Property.CACHEABLE);
                }
                if (this.open != null) {
                    printable.setOpenEvent(this.open);
                }
                if (this.close != null) {
                    printable.setCloseEvent(this.close);
                }
                if (this.inventoryModifier != null) {
                    printable.setStock(this.inventoryModifier);
                }
                PrintableMenu printableMenu = printable.join();
                if (printableMenu == null) {
                    DocketBuilder.$$$reportNull$$$0(1);
                }
                return printableMenu;
            }
            case SINGULAR: {
                Menu.Builder<SingularMenu, InventoryElement.Normal> singular = MenuType.SINGULAR.build().setHost(this.plugin).setTitle(this.title).setSize(this.rows);
                if (this.key != null) {
                    singular.setKey(this.key).setProperty(Menu.Property.CACHEABLE);
                }
                if (this.open != null) {
                    singular.setOpenEvent(this.open);
                }
                if (this.close != null) {
                    singular.setCloseEvent(this.close);
                }
                if (this.inventoryModifier != null) {
                    singular.setStock(this.inventoryModifier);
                }
                SingularMenu singularMenu = singular.join();
                if (singularMenu == null) {
                    DocketBuilder.$$$reportNull$$$0(2);
                }
                return singularMenu;
            }
        }
        throw new IllegalStateException("Unexpected value: " + (Object)((Object)this.type));
    }

    @Override
    @NotNull
    public Docket.Type getType() {
        Docket.Type type = Docket.Type.BUILDER;
        if (type == null) {
            DocketBuilder.$$$reportNull$$$0(3);
        }
        return type;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/github/sanctum/labyrinth/gui/unity/simple/DocketBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "toMenu";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

