/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth.gui.unity.simple;

import com.github.sanctum.labyrinth.data.AtlasMap;
import com.github.sanctum.labyrinth.gui.unity.construct.Menu;
import com.github.sanctum.labyrinth.gui.unity.simple.DocketBuilder;
import com.github.sanctum.labyrinth.gui.unity.simple.JsonDocket;
import com.github.sanctum.labyrinth.gui.unity.simple.MapDocket;
import com.github.sanctum.labyrinth.gui.unity.simple.MemoryDocket;
import com.github.sanctum.labyrinth.gui.unity.simple.UniqueHolder;
import com.github.sanctum.labyrinth.interfacing.JsonIntermediate;
import com.github.sanctum.panther.annotation.Json;
import com.github.sanctum.panther.annotation.Note;
import com.github.sanctum.panther.annotation.See;
import com.github.sanctum.panther.file.MemorySpace;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

@See(value={DocketBuilder.class, JsonDocket.class, MapDocket.class, MemoryDocket.class})
public interface Docket<T>
extends JsonIntermediate {
    @Note(value="A useful variable processing step")
    @NotNull
    default public @Note(value="A useful variable processing step") @NotNull Docket<T> load() {
        Docket docket = this;
        if (docket == null) {
            Docket.$$$reportNull$$$0(0);
        }
        return docket;
    }

    @NotNull
    public Menu toMenu();

    @NotNull
    public Type getType();

    default public boolean isUnique() {
        return this instanceof UniqueHolder;
    }

    @NotNull
    public static <V> MapDocket<V> newInstance(@NotNull Map<String, Object> map) {
        if (map == null) {
            Docket.$$$reportNull$$$0(1);
        }
        AtlasMap m = new AtlasMap();
        m.putAll((Map<? extends String, ?>)map);
        return new MapDocket(m);
    }

    @NotNull
    public static <V> MemoryDocket<V> newInstance(@NotNull MemorySpace memorySpace) {
        if (memorySpace == null) {
            Docket.$$$reportNull$$$0(2);
        }
        return new MemoryDocket(memorySpace);
    }

    @NotNull
    public static <V> JsonDocket<V> newInstance(@Json @NotNull String json) {
        if (json == null) {
            Docket.$$$reportNull$$$0(3);
        }
        return new JsonDocket(json, s -> {
            AtlasMap map = new AtlasMap();
            map.putAll((Map<? extends String, ?>)JsonIntermediate.convertToMap(JsonIntermediate.toJsonObject(json)));
            return map;
        });
    }

    public static Menu toMenu(@NotNull Docket<?> docket) {
        if (docket == null) {
            Docket.$$$reportNull$$$0(4);
        }
        return docket.getType() == Type.MEMORY ? docket.load().toMenu() : docket.toMenu();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/github/sanctum/labyrinth/gui/unity/simple/Docket";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memorySpace";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "json";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docket";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "load";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/github/sanctum/labyrinth/gui/unity/simple/Docket";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "newInstance";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "toMenu";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum Type {
        BUILDER,
        MEMORY,
        CUSTOM;

    }
}

