/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth.gui.unity.simple;

import com.github.sanctum.labyrinth.LabyrinthProvider;
import com.github.sanctum.labyrinth.gui.unity.construct.Menu;
import com.github.sanctum.labyrinth.gui.unity.construct.MenuRegistration;
import com.github.sanctum.labyrinth.gui.unity.impl.MenuType;
import com.github.sanctum.labyrinth.gui.unity.simple.Docket;
import com.github.sanctum.labyrinth.gui.unity.simple.MemoryItem;
import com.github.sanctum.labyrinth.gui.unity.simple.UniqueHolder;
import com.github.sanctum.labyrinth.interfacing.UnknownGeneric;
import com.github.sanctum.labyrinth.library.Mailer;
import com.github.sanctum.panther.file.MemorySpace;
import com.github.sanctum.panther.util.Check;
import java.util.function.BiFunction;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;

public class AnvilDocket
implements Docket<UnknownGeneric>,
UniqueHolder {
    final MemorySpace memory;
    String title;
    MemoryItem item;
    Object uniqueData;
    BiFunction<String, Object, String> uniqueDataConverter;
    Menu menu;

    public AnvilDocket(@NotNull MemorySpace memorySpace) {
        if (memorySpace == null) {
            AnvilDocket.$$$reportNull$$$0(0);
        }
        this.memory = memorySpace;
    }

    public <V> AnvilDocket setUniqueDataConverter(@NotNull V data, @NotNull BiFunction<String, V, String> function) {
        if (data == null) {
            AnvilDocket.$$$reportNull$$$0(1);
        }
        if (function == null) {
            AnvilDocket.$$$reportNull$$$0(2);
        }
        this.uniqueData = data;
        this.uniqueDataConverter = function;
        return this;
    }

    @Override
    @NotNull
    public Menu toMenu() {
        Menu menu = this.menu;
        if (menu == null) {
            AnvilDocket.$$$reportNull$$$0(3);
        }
        return menu;
    }

    @NotNull
    public AnvilDocket load() {
        this.title = Check.forNull(this.memory.getNode("title").toPrimitive().getString(), "Configured menus cannot have null titles please correct under path '" + this.memory.getPath() + "'");
        if (this.uniqueData != null) {
            this.title = this.uniqueDataConverter.apply(this.title, this.uniqueData);
        }
        this.item = new MemoryItem(this.memory.getNode("item"));
        this.menu = MenuType.PRINTABLE.build().setTitle(this.title).setSize(Menu.Rows.ONE).setHost(LabyrinthProvider.getInstance().getPluginInstance()).setStock(i -> i.addItem(b -> b.setElement(it -> it.setItem(this.item.toItem()).build()).setSlot(0).setClick(c -> {
            c.setCancelled(true);
            c.setHotbarAllowed(false);
        }))).join().addAction(click -> {
            if (click.getSlot() == 2 && this.item.isNotRemovable()) {
                this.handleClickEvent(this.item, click.getParent().getName()).apply(click);
            }
        });
        AnvilDocket anvilDocket = this;
        if (anvilDocket == null) {
            AnvilDocket.$$$reportNull$$$0(4);
        }
        return anvilDocket;
    }

    protected Menu.Click handleClickEvent(MemoryItem item, String text) {
        return click -> {
            click.setCancelled(true);
            if (item.isExitOnClick()) {
                click.getParent().getParent().getParent().close(click.getElement());
            }
            if (item.getMessage() != null) {
                String message = item.getMessage().replace(":message:", text);
                if (this.uniqueData != null) {
                    message = this.uniqueDataConverter.apply(message, this.uniqueData);
                }
                Mailer.empty((CommandSender)click.getElement()).chat(message).deploy();
            }
            if (item.getOpenOnClick() != null) {
                String open = item.getOpenOnClick();
                MenuRegistration registration = MenuRegistration.getInstance();
                Menu registered = registration.get(open).get();
                if (registered != null) {
                    registered.open(click.getElement());
                } else if (item.getOpenOnClick().startsWith("/")) {
                    String command = item.getOpenOnClick().replace("/", "").replace(":message:", text);
                    if (this.uniqueData != null) {
                        command = this.uniqueDataConverter.apply(command, this.uniqueData);
                    }
                    click.getElement().performCommand(command);
                }
            }
        };
    }

    @Override
    @NotNull
    public Docket.Type getType() {
        Docket.Type type = Docket.Type.MEMORY;
        if (type == null) {
            AnvilDocket.$$$reportNull$$$0(5);
        }
        return type;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memorySpace";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/github/sanctum/labyrinth/gui/unity/simple/AnvilDocket";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/github/sanctum/labyrinth/gui/unity/simple/AnvilDocket";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "toMenu";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "load";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setUniqueDataConverter";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

