/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth.gui.unity.impl;

import com.github.sanctum.labyrinth.gui.unity.construct.Menu;
import com.github.sanctum.labyrinth.gui.unity.construct.MenuRegistration;
import com.github.sanctum.labyrinth.gui.unity.construct.PaginatedMenu;
import com.github.sanctum.labyrinth.gui.unity.construct.PrintableMenu;
import com.github.sanctum.labyrinth.gui.unity.construct.SingularMenu;
import com.github.sanctum.labyrinth.gui.unity.impl.AnimatedBuilder;
import com.github.sanctum.labyrinth.gui.unity.impl.InventoryElement;
import com.github.sanctum.labyrinth.gui.unity.impl.PaginatedBuilder;
import com.github.sanctum.labyrinth.gui.unity.impl.PrintableBuilder;
import com.github.sanctum.labyrinth.gui.unity.impl.SingularBuilder;
import com.github.sanctum.panther.annotation.Experimental;
import java.util.function.Predicate;

public class MenuType<T extends Menu, K extends InventoryElement, V extends Menu.Builder<T, K>> {
    public static final MenuType<PaginatedMenu, InventoryElement.Paginated, PaginatedBuilder> PAGINATED = new MenuType<PaginatedMenu, InventoryElement.Paginated, PaginatedBuilder>(new PaginatedBuilder.Factory());
    public static final MenuType<SingularMenu, InventoryElement.Normal, SingularBuilder> SINGULAR = new MenuType<SingularMenu, InventoryElement.Normal, SingularBuilder>(new SingularBuilder.Factory());
    public static final MenuType<PrintableMenu, InventoryElement.Printable, PrintableBuilder> PRINTABLE = new MenuType<PrintableMenu, InventoryElement.Printable, PrintableBuilder>(new PrintableBuilder.Factory());
    @Experimental(dueTo="Being brand new")
    public static final MenuType<SingularMenu, InventoryElement.Animated, AnimatedBuilder> ANIMATED = new MenuType<SingularMenu, InventoryElement.Animated, AnimatedBuilder>(new AnimatedBuilder.Factory());
    private final Menu.BuilderFactory<V, T, K> factory;
    private final MenuRegistration registration = MenuRegistration.getInstance();

    MenuType(Menu.BuilderFactory<V, T, K> factory) {
        this.factory = factory;
    }

    public Menu.Builder<T, K> build() {
        return this.factory.createBuilder();
    }

    public boolean exists(String key) {
        return this.registration.get(key).deploy().get() != null;
    }

    public T get(String key) {
        return (T)this.registration.get(key).deploy().get();
    }

    public T get(Predicate<Menu> predicate) {
        for (Menu m : this.registration.getAll().deploy().get()) {
            if (!predicate.test(m)) continue;
            return (T)m;
        }
        return null;
    }
}

