/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth.formatting.string;

import com.github.sanctum.labyrinth.LabyrinthProvider;
import com.github.sanctum.labyrinth.formatting.FancyMessage;
import com.github.sanctum.labyrinth.formatting.Message;
import com.github.sanctum.labyrinth.formatting.string.DefaultColor;
import com.github.sanctum.labyrinth.formatting.string.ImageBreakdown;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Iterator;
import javax.imageio.ImageIO;
import org.jetbrains.annotations.NotNull;

public class MessageBreakdown
extends ImageBreakdown
implements Iterable<Message> {
    final Message[] messages;

    public MessageBreakdown(BufferedImage image, int height, int width, char imgChar, Color transparency) {
        super(image, height, width, imgChar, transparency);
        int y;
        boolean legacy = LabyrinthProvider.getInstance().isLegacy();
        BufferedImage resized = MessageBreakdown.resize(image, width, height);
        Color[][] colors = new Color[resized.getWidth()][resized.getHeight()];
        for (int x = 0; x < resized.getWidth(); ++x) {
            for (y = 0; y < resized.getHeight(); ++y) {
                int rgb = resized.getRGB(x, y);
                colors[x][y] = rgb >> 24 == 0 ? transparency : new Color(rgb, true);
            }
        }
        Message[] lines = new Message[colors[0].length];
        for (y = 0; y < colors[0].length; ++y) {
            FancyMessage message = new FancyMessage();
            for (Color[] chatColors : colors) {
                Color color = chatColors[y];
                if (color != null) {
                    if (legacy) {
                        message.then(imgChar).color(DefaultColor.fromAwt(color));
                        continue;
                    }
                    message.then(imgChar).color(org.bukkit.Color.fromRGB((int)color.getRed(), (int)color.getGreen(), (int)color.getBlue()));
                    continue;
                }
                message.then(32);
            }
            lines[y] = message;
        }
        this.messages = lines;
    }

    public MessageBreakdown(String url, int height, int width, char imgChar, Color transparency) {
        super(url, height, width, imgChar, transparency);
        boolean legacy = LabyrinthProvider.getInstance().isLegacy();
        Color[][] chatColors = new Color[][]{};
        try {
            BufferedImage image = ImageIO.read(new URL(url));
            BufferedImage resized = MessageBreakdown.resize(image, width, height);
            Color[][] colors = new Color[resized.getWidth()][resized.getHeight()];
            for (int x = 0; x < resized.getWidth(); ++x) {
                for (int y = 0; y < resized.getHeight(); ++y) {
                    int rgb = resized.getRGB(x, y);
                    colors[x][y] = rgb >> 24 == 0 ? transparency : new Color(rgb, true);
                }
            }
            chatColors = colors;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Message[] lines = new Message[chatColors[0].length];
        for (int y = 0; y < chatColors[0].length; ++y) {
            FancyMessage message = new FancyMessage();
            for (Color[] colors : chatColors) {
                Color color = colors[y];
                if (color != null) {
                    if (legacy) {
                        message.then(imgChar).color(DefaultColor.fromAwt(color));
                        continue;
                    }
                    message.then(imgChar).color(org.bukkit.Color.fromRGB((int)color.getRed(), (int)color.getGreen(), (int)color.getBlue()));
                    continue;
                }
                message.then(32);
            }
            lines[y] = message;
        }
        this.messages = lines;
    }

    public MessageBreakdown(@NotNull ImageBreakdown breakdown) {
        if (breakdown == null) {
            MessageBreakdown.$$$reportNull$$$0(0);
        }
        super(breakdown);
        this.messages = breakdown instanceof MessageBreakdown ? ((MessageBreakdown)breakdown).messages : null;
    }

    public MessageBreakdown(BufferedImage image, int height, char imgChar, Color transparency) {
        super(image, height, imgChar, transparency);
        int y;
        boolean legacy = LabyrinthProvider.getInstance().isLegacy();
        double ratio = (double)image.getHeight() / (double)image.getWidth();
        BufferedImage resized = MessageBreakdown.resize(image, (int)((double)height / ratio), height);
        Color[][] colors = new Color[resized.getWidth()][resized.getHeight()];
        for (int x = 0; x < resized.getWidth(); ++x) {
            for (y = 0; y < resized.getHeight(); ++y) {
                int rgb = resized.getRGB(x, y);
                colors[x][y] = rgb >> 24 == 0 ? transparency : new Color(rgb, true);
            }
        }
        Message[] lines = new Message[colors[0].length];
        for (y = 0; y < colors[0].length; ++y) {
            FancyMessage message = new FancyMessage();
            for (Color[] chatColors : colors) {
                Color color = chatColors[y];
                if (color != null) {
                    if (legacy) {
                        message.then(imgChar).color(DefaultColor.fromAwt(color));
                        continue;
                    }
                    message.then(imgChar).color(org.bukkit.Color.fromRGB((int)color.getRed(), (int)color.getGreen(), (int)color.getBlue()));
                    continue;
                }
                message.then(32);
            }
            lines[y] = message;
        }
        this.messages = lines;
    }

    public MessageBreakdown(String url, int height, char imgChar, Color transparency) {
        super(url, height, imgChar, transparency);
        boolean legacy = LabyrinthProvider.getInstance().isLegacy();
        Color[][] chatColors = new Color[][]{};
        try {
            BufferedImage image = ImageIO.read(new URL(url));
            double ratio = (double)image.getHeight() / (double)image.getWidth();
            BufferedImage resized = MessageBreakdown.resize(image, (int)((double)height / ratio), height);
            Color[][] colors = new Color[resized.getWidth()][resized.getHeight()];
            for (int x = 0; x < resized.getWidth(); ++x) {
                for (int y = 0; y < resized.getHeight(); ++y) {
                    int rgb = resized.getRGB(x, y);
                    colors[x][y] = rgb >> 24 == 0 ? transparency : new Color(rgb, true);
                }
            }
            chatColors = colors;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Message[] lines = new Message[chatColors[0].length];
        for (int y = 0; y < chatColors[0].length; ++y) {
            FancyMessage message = new FancyMessage();
            for (Color[] colors : chatColors) {
                Color color = colors[y];
                if (color != null) {
                    if (legacy) {
                        message.then(imgChar).color(DefaultColor.fromAwt(color));
                        continue;
                    }
                    message.then(imgChar).color(org.bukkit.Color.fromRGB((int)color.getRGB()));
                    continue;
                }
                message.then(32);
            }
            lines[y] = message;
        }
        this.messages = lines;
    }

    public MessageBreakdown(BufferedImage image, int height, char imgChar) {
        this(image, height, imgChar, Color.WHITE);
    }

    public MessageBreakdown(BufferedImage image, int height, int width, char imgChar) {
        this(image, height, width, imgChar, Color.WHITE);
    }

    public MessageBreakdown(String url, int height, char imgChar) {
        this(url, height, imgChar, Color.WHITE);
    }

    public MessageBreakdown(String url, int height, int width, char imgChar) {
        this(url, height, width, imgChar, Color.WHITE);
    }

    public Message[] get() {
        return this.messages;
    }

    @Override
    @NotNull
    public Iterator<Message> iterator() {
        Iterator<Message> iterator = Arrays.asList(this.messages).iterator();
        if (iterator == null) {
            MessageBreakdown.$$$reportNull$$$0(1);
        }
        return iterator;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakdown";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/github/sanctum/labyrinth/formatting/string/MessageBreakdown";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/github/sanctum/labyrinth/formatting/string/MessageBreakdown";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "iterator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

