/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth.formatting.string;

import com.github.sanctum.labyrinth.LabyrinthProvider;
import com.github.sanctum.labyrinth.formatting.string.ColoredString;
import com.github.sanctum.labyrinth.formatting.string.DefaultColor;
import com.github.sanctum.panther.annotation.Note;
import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import javax.imageio.ImageIO;
import org.bukkit.ChatColor;
import org.jetbrains.annotations.NotNull;

public abstract class ImageBreakdown {
    @Note(value="All default game colors using awt from java.")
    public static final @Note(value="All default game colors using awt from java.") Color[] VANILLA_COLORS = new Color[]{new Color(0, 0, 0), new Color(0, 0, 170), new Color(0, 170, 0), new Color(0, 170, 170), new Color(170, 0, 0), new Color(170, 0, 170), new Color(255, 170, 0), new Color(170, 170, 170), new Color(85, 85, 85), new Color(85, 85, 255), new Color(85, 255, 85), new Color(85, 255, 255), new Color(255, 85, 85), new Color(255, 85, 255), new Color(255, 255, 85), new Color(255, 255, 255)};
    @Note(value="The max vanilla chat width using box characters.")
    public static final @Note(value="The max vanilla chat width using box characters.") int VANILLA_MAX_WIDTH = 35;
    private final String[] lines;

    public ImageBreakdown(@NotNull ImageBreakdown breakdown) {
        if (breakdown == null) {
            ImageBreakdown.$$$reportNull$$$0(0);
        }
        this.lines = Arrays.copyOf(breakdown.lines, breakdown.lines.length);
    }

    public ImageBreakdown(BufferedImage image, int height, char imgChar, @Note(value="Null to keep translucency") @Note(value="Null to keep translucency") Color transparency) {
        int y;
        boolean legacy = LabyrinthProvider.getInstance().isLegacy();
        double ratio = (double)image.getHeight() / (double)image.getWidth();
        BufferedImage resized = ImageBreakdown.resize(image, (int)((double)height / ratio), height);
        Color[][] colors = new Color[resized.getWidth()][resized.getHeight()];
        for (int x = 0; x < resized.getWidth(); ++x) {
            for (y = 0; y < resized.getHeight(); ++y) {
                int rgb = resized.getRGB(x, y);
                colors[x][y] = rgb >> 24 == 0 ? transparency : new Color(rgb, true);
            }
        }
        String[] lines = new String[colors[0].length];
        for (y = 0; y < colors[0].length; ++y) {
            StringBuilder line = new StringBuilder();
            for (Color[] chatColors : colors) {
                Color color = chatColors[y];
                line.append(color != null ? (legacy ? DefaultColor.fromAwt(color).toString() : ColoredString.fromAwt(color)) + imgChar : Character.valueOf(' '));
            }
            lines[y] = line.toString() + ChatColor.RESET;
        }
        this.lines = lines;
    }

    public ImageBreakdown(BufferedImage image, int height, int width, char imgChar, @Note(value="Null to keep translucency") @Note(value="Null to keep translucency") Color transparency) {
        int y;
        boolean legacy = LabyrinthProvider.getInstance().isLegacy();
        BufferedImage resized = ImageBreakdown.resize(image, width, height);
        Color[][] colors = new Color[resized.getWidth()][resized.getHeight()];
        for (int x = 0; x < resized.getWidth(); ++x) {
            for (y = 0; y < resized.getHeight(); ++y) {
                int rgb = resized.getRGB(x, y);
                colors[x][y] = rgb >> 24 == 0 ? transparency : new Color(rgb, true);
            }
        }
        String[] lines = new String[colors[0].length];
        for (y = 0; y < colors[0].length; ++y) {
            StringBuilder line = new StringBuilder();
            for (Color[] chatColors : colors) {
                Color color = chatColors[y];
                line.append(color != null ? (legacy ? DefaultColor.fromAwt(color).toString() : ColoredString.fromAwt(color)) + imgChar : Character.valueOf(' '));
            }
            lines[y] = line.toString() + ChatColor.RESET;
        }
        this.lines = lines;
    }

    public ImageBreakdown(String url, int height, char imgChar, @Note(value="Null to keep translucency") @Note(value="Null to keep translucency") Color transparency) {
        boolean legacy = LabyrinthProvider.getInstance().isLegacy();
        Color[][] chatColors = new Color[][]{};
        try {
            BufferedImage image = ImageIO.read(new URL(url));
            double ratio = (double)image.getHeight() / (double)image.getWidth();
            BufferedImage resized = ImageBreakdown.resize(image, (int)((double)height / ratio), height);
            Color[][] colors = new Color[resized.getWidth()][resized.getHeight()];
            for (int x = 0; x < resized.getWidth(); ++x) {
                for (int y = 0; y < resized.getHeight(); ++y) {
                    int rgb = resized.getRGB(x, y);
                    colors[x][y] = rgb >> 24 == 0 ? transparency : new Color(rgb, true);
                }
            }
            chatColors = colors;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String[] lines = new String[chatColors[0].length];
        for (int y = 0; y < chatColors[0].length; ++y) {
            StringBuilder line = new StringBuilder();
            for (Color[] colors : chatColors) {
                Color color = colors[y];
                line.append(color != null ? (legacy ? DefaultColor.fromAwt(color).toString() : ColoredString.fromAwt(color)) + imgChar : Character.valueOf(' '));
            }
            lines[y] = line.toString() + ChatColor.RESET;
        }
        this.lines = lines;
    }

    public ImageBreakdown(String url, int height, int width, char imgChar, @Note(value="Null to keep translucency") @Note(value="Null to keep translucency") Color transparency) {
        boolean legacy = LabyrinthProvider.getInstance().isLegacy();
        Color[][] chatColors = new Color[][]{};
        try {
            BufferedImage image = ImageIO.read(new URL(url));
            BufferedImage resized = ImageBreakdown.resize(image, width, height);
            Color[][] colors = new Color[resized.getWidth()][resized.getHeight()];
            for (int x = 0; x < resized.getWidth(); ++x) {
                for (int y = 0; y < resized.getHeight(); ++y) {
                    int rgb = resized.getRGB(x, y);
                    colors[x][y] = rgb >> 24 == 0 ? transparency : new Color(rgb, true);
                }
            }
            chatColors = colors;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String[] lines = new String[chatColors[0].length];
        for (int y = 0; y < chatColors[0].length; ++y) {
            StringBuilder line = new StringBuilder();
            for (Color[] colors : chatColors) {
                Color color = colors[y];
                line.append(color != null ? (legacy ? DefaultColor.fromAwt(color).toString() : ColoredString.fromAwt(color)) + imgChar : Character.valueOf(' '));
            }
            lines[y] = line.toString() + ChatColor.RESET;
        }
        this.lines = lines;
    }

    public ImageBreakdown(BufferedImage image, int height, char imgChar) {
        this(image, height, imgChar, null);
    }

    public ImageBreakdown(BufferedImage image, int height, int width, char imgChar) {
        this(image, height, width, imgChar, null);
    }

    public ImageBreakdown(String url, int height, char imgChar) {
        this(url, height, imgChar, null);
    }

    public ImageBreakdown(String url, int height, int width, char imgChar) {
        this(url, height, width, imgChar, null);
    }

    public static BufferedImage resize(BufferedImage bufferedImage, int width, int height) {
        AffineTransform af = new AffineTransform();
        af.scale((double)width / (double)bufferedImage.getWidth(), (double)height / (double)bufferedImage.getHeight());
        AffineTransformOp operation = new AffineTransformOp(af, 1);
        return operation.filter(bufferedImage, null);
    }

    public ImageBreakdown append(String ... text) {
        for (int y = 0; y < this.lines.length; ++y) {
            if (text.length <= y) continue;
            int n = y;
            this.lines[n] = this.lines[n] + " " + text[y];
        }
        return this;
    }

    public String[] read() {
        return this.lines;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakdown", "com/github/sanctum/labyrinth/formatting/string/ImageBreakdown", "<init>"));
    }
}

