/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth.formatting.string;

import com.github.sanctum.labyrinth.formatting.string.ColoredString;
import com.github.sanctum.labyrinth.formatting.string.CustomColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.melion.rgbchat.chat.TextColor;

public class GradientColor
implements CustomColor {
    private final CharSequence start;
    private final CharSequence end;
    private String context;
    private String name;

    public GradientColor(CharSequence start, CharSequence end) {
        this.start = start;
        this.end = end;
    }

    public GradientColor(String context, CharSequence start, CharSequence end) {
        this.context = context;
        this.start = start;
        this.end = end;
    }

    public GradientColor(String context, String name, CharSequence start, CharSequence end) {
        this.name = name;
        this.context = context;
        this.start = start;
        this.end = end;
    }

    @Override
    public TextColor[] colors() {
        return new TextColor[]{new TextColor(this.start.toString()), new TextColor(this.end.toString())};
    }

    public GradientColor name(String name) {
        this.name = name;
        return this;
    }

    @Override
    public GradientColor context(String context) {
        this.context = context;
        return this;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String join() {
        return "<" + this.start + ">" + this.context + "</" + this.end + ">";
    }

    @Override
    public BaseComponent[] build() {
        return TextComponent.fromLegacyText((String)this.translate());
    }

    @Override
    public String translate() {
        return new ColoredString(this.join(), ColoredString.ColorType.HEX).toString();
    }
}

