/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth.formatting.string;

import com.github.sanctum.labyrinth.LabyrinthProvider;
import com.github.sanctum.labyrinth.formatting.ComponentChunk;
import com.github.sanctum.panther.annotation.Note;
import java.awt.Color;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.melion.rgbchat.api.RGBApi;
import org.bukkit.ChatColor;

public class ColoredString {
    private final ColorType type;
    private final String text;

    public ColoredString(String text) {
        this.text = text;
        this.type = LabyrinthProvider.getInstance().isNew() ? ColorType.HEX : ColorType.MC;
    }

    public ColoredString(String text, ColorType type) {
        this.text = text;
        this.type = type;
    }

    @Note(value="Convert color object to html #Hex format")
    public static @Note(value="Convert color object to html #Hex format") String fromAwt(Color c) {
        StringBuilder sb = new StringBuilder("#");
        if (c.getRed() < 16) {
            sb.append('0');
        }
        sb.append(Integer.toHexString(c.getRed()));
        if (c.getGreen() < 16) {
            sb.append('0');
        }
        sb.append(Integer.toHexString(c.getGreen()));
        if (c.getBlue() < 16) {
            sb.append('0');
        }
        sb.append(Integer.toHexString(c.getBlue()));
        return sb.toString();
    }

    public String toString() {
        String r = "No context to return";
        switch (this.type) {
            case MC: {
                r = ChatColor.translateAlternateColorCodes((char)'&', (String)this.text);
                break;
            }
            case MC_COMPONENT: {
                r = new ComponentChunk(new BaseComponent[]{this.toComponent()}).toJson();
                break;
            }
            case HEX: {
                r = LabyrinthProvider.getInstance().isLegacy() ? ChatColor.translateAlternateColorCodes((char)'&', (String)this.text) : ChatColor.translateAlternateColorCodes((char)'&', (String)RGBApi.toColoredMessage(this.text));
            }
        }
        return r;
    }

    public TextComponent toComponent() {
        return LabyrinthProvider.getInstance().isNew() ? new TextComponent(TextComponent.fromLegacyText((String)ChatColor.translateAlternateColorCodes((char)'&', (String)RGBApi.toColoredMessage(this.text)))) : new TextComponent(ChatColor.translateAlternateColorCodes((char)'&', (String)this.text));
    }

    public static enum ColorType {
        MC,
        MC_COMPONENT,
        HEX;

    }
}

