/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth.formatting;

import com.github.sanctum.labyrinth.library.ListUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public abstract class UniformedComponents<T>
implements Iterable<T>,
Serializable {
    private static final long serialVersionUID = 380726810757536184L;

    public abstract List<T> list();

    public abstract List<T> sort();

    public abstract List<T> sort(Comparator<? super T> var1);

    public abstract Collection<T> collect();

    public abstract T[] array();

    public abstract <R> Stream<R> map(Function<? super T, ? extends R> var1);

    public abstract Stream<T> filter(Predicate<? super T> var1);

    public List<T> append(Consumer<T> action) {
        return ListUtils.use(this.list()).append(action);
    }

    public List<T> append(ListUtils.ListOperation<T> operation) {
        return ListUtils.use(this.list()).append(operation);
    }

    public boolean exists(Predicate<? super T> predicate) {
        return this.filter(predicate).count() > 0L;
    }

    public abstract T getFirst();

    public abstract T getLast();

    public abstract T get(int var1);

    @Override
    public void forEach(Consumer<? super T> action) {
        this.list().forEach(action);
    }

    @Override
    public Spliterator<T> spliterator() {
        return this.list().spliterator();
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        Iterator<T> iterator = this.list().iterator();
        if (iterator == null) {
            UniformedComponents.$$$reportNull$$$0(0);
        }
        return iterator;
    }

    public static <T> UniformedComponents<T> accept(T[] array) {
        return UniformedComponents.accept(Arrays.asList(array));
    }

    public static <T> UniformedComponents<T> accept(final List<T> list) {
        return new UniformedComponents<T>(){
            private static final long serialVersionUID = -5158318648096932311L;

            @Override
            public List<T> list() {
                return new ArrayList(list);
            }

            @Override
            public List<T> sort() {
                return this.list();
            }

            @Override
            public List<T> sort(Comparator<? super T> comparable) {
                List list2 = this.list();
                list2.sort(comparable);
                return list2;
            }

            @Override
            public Collection<T> collect() {
                return this.list();
            }

            @Override
            public T[] array() {
                return this.list().toArray();
            }

            @Override
            public <R> Stream<R> map(Function<? super T, ? extends R> mapper) {
                return this.list().stream().map(mapper);
            }

            @Override
            public Stream<T> filter(Predicate<? super T> predicate) {
                return this.list().stream().filter(predicate);
            }

            @Override
            public T getFirst() {
                return this.list().get(0);
            }

            @Override
            public T getLast() {
                return this.list().get(Math.max(this.list().size() - 1, 0));
            }

            @Override
            public T get(int index) {
                return this.list().get(index);
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/github/sanctum/labyrinth/formatting/UniformedComponents", "iterator"));
    }
}

