/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth.formatting;

import com.github.sanctum.labyrinth.LabyrinthProvider;
import com.github.sanctum.labyrinth.formatting.ComponentUtil;
import com.github.sanctum.labyrinth.formatting.Message;
import com.github.sanctum.labyrinth.formatting.ToolTip;
import com.github.sanctum.labyrinth.formatting.string.CustomColor;
import com.github.sanctum.labyrinth.formatting.string.FormattedString;
import com.github.sanctum.labyrinth.library.ListUtils;
import com.github.sanctum.labyrinth.library.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.jetbrains.annotations.NotNull;

public class TextChunk
extends Message.Chunk {
    private final List<ToolTip<?>> CONTEXT = new ArrayList();
    private String text;
    private String style;
    private String color;

    public TextChunk(String text) {
        this.text = text;
    }

    public TextChunk(String text, Color color) {
        String hex = String.format("#%02X%02X%02X", color.getRed(), color.getGreen(), color.getBlue());
        this.text = hex + text;
    }

    public TextChunk(String text, ChatColor color) {
        this.text = color + text;
    }

    public TextChunk(String text, CustomColor color) {
        this.text = color.context(text).join();
    }

    @Override
    public TextChunk append(String text) {
        this.text = this.text + text;
        return this;
    }

    @Override
    public Message.Chunk append(int i) {
        return this.append(String.valueOf(i));
    }

    @Override
    public Message.Chunk append(double d) {
        return this.append(String.valueOf(d));
    }

    @Override
    public Message.Chunk append(long l) {
        return this.append(String.valueOf(l));
    }

    @Override
    public TextChunk style(ChatColor style) {
        List<ChatColor> targets = Arrays.asList(ChatColor.BOLD, ChatColor.ITALIC, ChatColor.UNDERLINE, ChatColor.STRIKETHROUGH, ChatColor.RESET, ChatColor.MAGIC);
        if (!targets.contains(style)) {
            throw new IllegalArgumentException("Message: Invalid text style provided.");
        }
        this.style = style.toString();
        return this;
    }

    @Override
    public Message.Chunk style(ChatColor ... style) {
        List<ChatColor> targets = Arrays.asList(ChatColor.BOLD, ChatColor.ITALIC, ChatColor.UNDERLINE, ChatColor.STRIKETHROUGH, ChatColor.RESET, ChatColor.MAGIC);
        for (ChatColor s : style) {
            if (targets.contains(s)) continue;
            throw new IllegalArgumentException("Message: Invalid text style provided.");
        }
        this.style = ListUtils.use(style).join(colors -> colors.stream().map(ChatColor::toString).collect(Collectors.joining()));
        return this;
    }

    @Override
    public TextChunk style(CustomColor color) {
        String stripped = net.md_5.bungee.api.ChatColor.stripColor((String)StringUtils.use(this.text).translate());
        this.color = null;
        this.style = null;
        this.text = color.context(stripped).join();
        return this;
    }

    @Override
    public Message.Chunk color(ChatColor color) {
        this.color = color.toString();
        return this;
    }

    @Override
    public Message.Chunk color(Color color) {
        this.color = String.format("#%02X%02X%02X", color.getRed(), color.getGreen(), color.getBlue());
        return this;
    }

    @Override
    public TextChunk bind(ToolTip<?> context) {
        this.CONTEXT.add(context);
        return this;
    }

    @Override
    public TextChunk setText(String text) {
        this.text = text;
        return this;
    }

    @Override
    public Message.Chunk replace(String text, String replacement) {
        this.text = new FormattedString(this.text).replace(text, replacement).get();
        return this;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public BaseComponent toComponent() {
        TextComponent component = new TextComponent(TextComponent.fromLegacyText((String)StringUtils.use(this.text).translate()));
        if (this.style != null) {
            component = this.color != null ? new TextComponent(TextComponent.fromLegacyText((String)StringUtils.use(this.color + this.style + this.text).translate())) : new TextComponent(TextComponent.fromLegacyText((String)StringUtils.use(this.style + this.text).translate()));
        } else if (this.color != null) {
            component = new TextComponent(TextComponent.fromLegacyText((String)StringUtils.use(this.color + this.text).translate()));
        }
        ArrayList adjusted = new ArrayList();
        this.CONTEXT.stream().filter(t -> t instanceof ToolTip.Text).forEach((? super T toolTip) -> adjusted.add(((ToolTip.Text)toolTip).get()));
        TextComponent finalComponent = component;
        ListUtils.use(adjusted).append((T object) -> object + "\n").forEach((? super T context) -> {
            if (LabyrinthProvider.getInstance().isLegacy()) {
                finalComponent.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(StringUtils.use(context).translate()).create()));
            } else {
                ComponentUtil.addContent((BaseComponent)finalComponent, context);
            }
        });
        block8: for (ToolTip<?> context2 : this.CONTEXT) {
            switch (context2.getType()) {
                case COMMAND: {
                    component.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, (String)context2.get()));
                    break;
                }
                case HOVER: {
                    if (!(context2 instanceof ToolTip.Item)) break;
                    ToolTip.Item item = (ToolTip.Item)context2;
                    BaseComponent[] components = new BaseComponent[]{new TextComponent(item.toJson())};
                    if (component.getHoverEvent() != null) continue block8;
                    component.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_ITEM, components));
                    break;
                }
                case ACTION: {
                    ToolTip.Action action = (ToolTip.Action)context2;
                    LabyrinthProvider.getInstance().registerComponent(action).deploy();
                    component.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/" + action.getId()));
                    break;
                }
                case SUGGEST: {
                    component.setClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, (String)context2.get()));
                    break;
                }
                case URL: {
                    component.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, (String)context2.get()));
                    break;
                }
                case COPY: {
                    component.setClickEvent(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, (String)context2.get()));
                }
            }
        }
        return component;
    }

    @Override
    @NotNull
    public Iterator<ToolTip<?>> iterator() {
        Iterator<ToolTip<?>> iterator = this.CONTEXT.iterator();
        if (iterator == null) {
            TextChunk.$$$reportNull$$$0(0);
        }
        return iterator;
    }

    @Override
    public void forEach(Consumer<? super ToolTip<?>> action) {
        this.CONTEXT.forEach(action);
    }

    @Override
    public Spliterator<ToolTip<?>> spliterator() {
        return this.CONTEXT.spliterator();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/github/sanctum/labyrinth/formatting/TextChunk", "iterator"));
    }
}

