/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth.formatting;

import com.github.sanctum.labyrinth.formatting.ScoreboardBuilder;
import com.github.sanctum.panther.container.PantherCollection;
import com.github.sanctum.panther.container.PantherList;
import java.util.Arrays;

public interface ScoreboardGroup {
    public String getKey();

    public boolean isActive();

    public boolean isWindable();

    public void setActive(boolean var1);

    public ScoreboardBuilder getBuilder(int var1);

    public int getIndex();

    public void setWindable(boolean var1);

    public void next();

    public static ScoreboardGroup fromInfo(final String key, final ScoreboardBuilder ... builders) {
        return new ScoreboardGroup(){
            private final PantherCollection<ScoreboardBuilder> headerlist = new PantherList<ScoreboardBuilder>();
            private int headerPos;
            private boolean isWindable = true;
            private boolean isActive = true;
            private boolean headerGoingBackwards;
            {
                this.headerlist.addAll(Arrays.asList(builders));
            }

            @Override
            public String getKey() {
                return key;
            }

            @Override
            public boolean isActive() {
                return this.isActive;
            }

            @Override
            public boolean isWindable() {
                return this.isWindable;
            }

            @Override
            public void setActive(boolean active) {
                this.isActive = active;
            }

            @Override
            public ScoreboardBuilder getBuilder(int index) {
                return this.headerlist.get(index);
            }

            @Override
            public int getIndex() {
                return Math.max(0, this.headerPos);
            }

            @Override
            public void setWindable(boolean windable) {
                this.isWindable = windable;
            }

            @Override
            public void next() {
                if (this.headerPos + 1 >= this.headerlist.size()) {
                    if (this.isWindable) {
                        this.headerGoingBackwards = true;
                        --this.headerPos;
                    } else {
                        this.headerPos = 0;
                    }
                } else if (this.headerGoingBackwards) {
                    if (this.headerPos == 0) {
                        this.headerGoingBackwards = false;
                        ++this.headerPos;
                    } else {
                        --this.headerPos;
                    }
                } else {
                    ++this.headerPos;
                }
            }
        };
    }
}

