/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth.event;

import com.github.sanctum.labyrinth.LabyrinthProvider;
import com.github.sanctum.labyrinth.event.LabyrinthVentCall;
import com.github.sanctum.labyrinth.formatting.string.ColoredString;
import com.github.sanctum.labyrinth.library.CommandUtils;
import com.github.sanctum.labyrinth.library.ListUtils;
import com.github.sanctum.panther.event.Vent;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.block.Block;
import org.bukkit.entity.Projectile;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerCommandSendEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.server.TabCompleteEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class DefaultEvent
extends Vent {
    public DefaultEvent() {
        this(false);
    }

    public DefaultEvent(boolean isAsync) {
        super((Vent.Host)LabyrinthProvider.getInstance().getPluginInstance(), isAsync);
    }

    public DefaultEvent(@NotNull Vent.State state, boolean isAsync) {
        if (state == null) {
            DefaultEvent.$$$reportNull$$$0(0);
        }
        super((Vent.Host)LabyrinthProvider.getInstance().getPluginInstance(), state, isAsync);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/github/sanctum/labyrinth/event/DefaultEvent", "<init>"));
    }

    public static class Controller
    implements Listener {
        @EventHandler(priority=EventPriority.HIGHEST)
        public void onChat(AsyncPlayerChatEvent e) {
            Communication.ChatMessage impl;
            Communication c = new LabyrinthVentCall<Communication>(new Communication(e.getPlayer(), Communication.Type.CHAT, new Communication.ChatMessage(Bukkit.getOnlinePlayers(), e.getMessage(), e.getFormat().replace("<%1$s>", "").replace("%2$s", "")))).schedule().join();
            if (c.isCancelled()) {
                e.setCancelled(true);
            }
            if ((impl = (Communication.ChatMessage)c.getMessage().orElse(null)) != null && impl.isChanged()) {
                String s = impl.getFormat();
                e.getRecipients().clear();
                e.setMessage(ListUtils.use(impl.args).join(b -> b.stream().map(bc -> bc.toLegacyText()).collect(Collectors.toList()).toString()));
                for (org.bukkit.entity.Player p : impl.getRecipients()) {
                    p.spigot().sendMessage(impl.get());
                }
                if (s == null || s.isEmpty()) {
                    return;
                }
                if (!s.equals(e.getFormat())) {
                    e.setFormat(s);
                }
            }
        }

        @EventHandler(priority=EventPriority.HIGHEST)
        public void onChat(PlayerCommandPreprocessEvent e) {
            Communication c = new LabyrinthVentCall<Communication>(new Communication(e.getPlayer(), Communication.Type.COMMAND, new Communication.ChatCommand(e.getMessage().split(" "), Bukkit.getOnlinePlayers()))).schedule().join();
            if (c.isCancelled()) {
                e.setCancelled(true);
            }
            if (c.getCommand().get().isChanged()) {
                e.setMessage(StringUtils.join((Object[])c.getCommand().get().args, (String)" "));
            }
        }

        @EventHandler
        public void onCommandHide(PlayerCommandSendEvent e) {
            CommandUtils.getVisibilityCalculations().forEach(calculation -> {
                String test = calculation.accept(e.getPlayer());
                if (test != null) {
                    e.getCommands().remove(test);
                }
            });
        }

        @EventHandler
        public void onTabInsert(TabCompleteEvent e) {
        }

        @EventHandler(priority=EventPriority.HIGHEST)
        public void onBuild(BlockPlaceEvent e) {
            BlockPlace b = (BlockPlace)new LabyrinthVentCall<BlockPlace>(new BlockPlace(e.getPlayer(), e.getBlock())).run();
            if (b.isCancelled()) {
                e.setCancelled(true);
            }
        }

        @EventHandler(priority=EventPriority.HIGHEST)
        public void onBuild(BlockBreakEvent e) {
            BlockBreak b = (BlockBreak)new LabyrinthVentCall<BlockBreak>(new BlockBreak(e.getPlayer(), e.getBlock())).run();
            if (b.isCancelled()) {
                e.setCancelled(true);
            }
        }

        @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
        public void onJoin(PlayerJoinEvent event) {
            Join e = (Join)new LabyrinthVentCall<Join>(new Join(event.getPlayer())).run();
            if (e.isCancelled()) {
                event.getPlayer().kickPlayer(e.getKickMessage());
            }
        }

        @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
        public void onLeave(PlayerQuitEvent event) {
            new LabyrinthVentCall<Leave>(new Leave(event.getPlayer())).run();
        }

        @EventHandler
        public void onInteract(PlayerInteractEvent e) {
            Interact i = (Interact)new LabyrinthVentCall<Interact>(new Interact(e.getAction(), e.useInteractedBlock(), e.getClickedBlock(), e.getItem(), e.getPlayer())).run();
            if (e.useInteractedBlock() != i.getResult()) {
                e.setUseInteractedBlock(i.getResult());
            }
        }

        @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
        public void onPlayerHit(EntityDamageByEntityEvent event) {
            org.bukkit.entity.Player target;
            Projectile pr;
            PlayerDamagePlayer e;
            org.bukkit.entity.Player p;
            if (event.getEntity() instanceof org.bukkit.entity.Player && event.getDamager() instanceof org.bukkit.entity.Player) {
                org.bukkit.entity.Player target2 = (org.bukkit.entity.Player)event.getEntity();
                p = (org.bukkit.entity.Player)event.getDamager();
                PlayerDamagePlayer e2 = (PlayerDamagePlayer)new LabyrinthVentCall<PlayerDamagePlayer>(new PlayerDamagePlayer(p, target2, true)).run();
                if (e2.isCancelled()) {
                    event.setCancelled(true);
                }
            }
            if (event.getEntity() instanceof org.bukkit.entity.Player && event.getDamager() instanceof Projectile && ((Projectile)event.getDamager()).getShooter() instanceof org.bukkit.entity.Player && (e = (PlayerDamagePlayer)new LabyrinthVentCall<PlayerDamagePlayer>(new PlayerDamagePlayer(p = (org.bukkit.entity.Player)(pr = (Projectile)event.getDamager()).getShooter(), target = (org.bukkit.entity.Player)event.getEntity(), false)).run()).isCancelled()) {
                event.setCancelled(true);
            }
        }
    }

    public static class PlayerDamagePlayer
    extends Player {
        private final org.bukkit.entity.Player victim;
        private final boolean physical;

        public PlayerDamagePlayer(org.bukkit.entity.Player attacker, org.bukkit.entity.Player victim, boolean isPhysical) {
            super(attacker, false);
            this.victim = victim;
            this.physical = isPhysical;
        }

        public boolean isPhysical() {
            return this.physical;
        }

        public org.bukkit.entity.Player getVictim() {
            return this.victim;
        }
    }

    public static class Interact
    extends Player {
        private Event.Result result;
        private final ItemStack item;
        private final Block block;
        private final Action action;

        public Interact(Action action, Event.Result result, Block clicked, ItemStack hand, org.bukkit.entity.Player p) {
            super(p, false);
            this.action = action;
            this.block = clicked;
            this.item = hand;
            this.result = result;
        }

        public Action getAction() {
            return this.action;
        }

        public Optional<Block> getBlock() {
            return Optional.ofNullable(this.block);
        }

        public ItemStack getItem() {
            return this.item;
        }

        public void setResult(Event.Result result) {
            this.result = result;
        }

        public Event.Result getResult() {
            return this.result;
        }
    }

    public static class BlockPlace
    extends Player {
        private final Block block;

        public BlockPlace(org.bukkit.entity.Player player, Block block) {
            super(player, false);
            this.block = block;
        }

        public Block getBlock() {
            return this.block;
        }
    }

    public static class Communication
    extends Player {
        private final Type type;
        private final CommunicationResult<?> result;

        public Communication(org.bukkit.entity.Player p, Type type, CommunicationResult<?> communication) {
            super(p, true);
            this.type = type;
            this.result = communication;
        }

        public Optional<ChatCommand> getCommand() {
            return this.result != null && this.result.get().getClass().isAssignableFrom(String[].class) ? Optional.ofNullable((ChatCommand)this.result) : Optional.empty();
        }

        public Optional<ChatMessage> getMessage() {
            return this.result != null && this.result.get().getClass().isAssignableFrom(BaseComponent[].class) ? Optional.ofNullable((ChatMessage)this.result) : Optional.empty();
        }

        public void setCommand(String command) {
            ChatCommand impl = this.getCommand().get();
            impl.setArgs(command);
        }

        public void setMessage(BaseComponent[] message) {
            ChatMessage impl = this.getMessage().get();
            impl.set(message);
        }

        public Type getCommunicationType() {
            return this.type != null ? this.type : Type.UNKNOWN;
        }

        public static enum Type {
            COMMAND,
            CHAT,
            UNKNOWN;

        }

        public static abstract class CommunicationResult<T> {
            private final Set<? extends org.bukkit.entity.Player> recipients;

            public CommunicationResult(Set<? extends org.bukkit.entity.Player> recipients) {
                this.recipients = recipients;
            }

            public abstract T get();

            public String getText() {
                return "null";
            }

            public Set<? extends org.bukkit.entity.Player> getRecipients() {
                if (this.recipients != null) {
                    return this.recipients;
                }
                return new HashSet();
            }
        }

        public static final class ChatCommand
        extends CommunicationResult<String[]> {
            private String[] args;
            private boolean changed;
            private String label;

            public ChatCommand(String[] args, Collection<? extends org.bukkit.entity.Player> recipients) {
                super((Set<? extends org.bukkit.entity.Player>)(recipients != null ? new HashSet<org.bukkit.entity.Player>(recipients) : null));
                this.args = args;
                this.label = args[0];
            }

            @Override
            public String[] get() {
                return this.args;
            }

            @Override
            public String getText() {
                return this.label.replace("/", "");
            }

            public boolean isChanged() {
                return this.changed;
            }

            public void setArgs(String text) {
                this.args = text.split(" ");
                this.changed = true;
                this.label = this.args[0];
            }
        }

        public static final class ChatMessage
        extends CommunicationResult<BaseComponent[]> {
            private BaseComponent[] args;
            private boolean changed;
            private final String text;
            private String format;

            public ChatMessage(Collection<? extends org.bukkit.entity.Player> recipients, String text, String format) {
                super(new HashSet<org.bukkit.entity.Player>(recipients));
                LinkedList<TextComponent> components = new LinkedList<TextComponent>();
                for (String s : format.split(" ")) {
                    components.add(new TextComponent(s));
                }
                this.args = ListUtils.use(components).append(b -> b.addExtra(" ")).toArray(new BaseComponent[0]);
                this.text = text;
                this.format = format;
            }

            @Override
            public BaseComponent[] get() {
                return this.args;
            }

            @Override
            public String getText() {
                return this.text;
            }

            public BaseComponent getMessage() {
                return new ColoredString(this.text, ColoredString.ColorType.MC_COMPONENT).toComponent();
            }

            public void set(BaseComponent[] components) {
                this.changed = true;
                this.args = components;
            }

            public boolean isChanged() {
                return this.changed;
            }

            protected String getFormat() {
                return this.format;
            }

            protected void setFormat(String format) {
                this.format = format;
            }
        }
    }

    public static class BlockBreak
    extends Player {
        private final Block block;

        public BlockBreak(org.bukkit.entity.Player player, Block block) {
            super(player, false);
            this.block = block;
        }

        public Block getBlock() {
            return this.block;
        }
    }

    public static class Leave
    extends Player {
        public Leave(org.bukkit.entity.Player p) {
            super(p, false, 0);
        }
    }

    public static class Join
    extends Player {
        private String kickMessage = ChatColor.RED + "You were blocked from connecting.";

        public Join(org.bukkit.entity.Player p) {
            super(p, false);
        }

        public String getKickMessage() {
            return this.kickMessage;
        }

        public void setKickMessage(String kickMessage) {
            this.kickMessage = kickMessage;
        }
    }

    public static class Player
    extends DefaultEvent {
        private final org.bukkit.entity.Player player;

        public Player(org.bukkit.entity.Player p, boolean isAsync) {
            super(isAsync);
            this.player = p;
        }

        public Player(org.bukkit.entity.Player p, boolean isAsync, Object ... args) {
            super(Vent.State.IMMUTABLE, isAsync);
            this.player = p;
        }

        public org.bukkit.entity.Player getPlayer() {
            return this.player;
        }
    }
}

