/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth.data.service;

import com.github.sanctum.labyrinth.api.Service;
import com.github.sanctum.panther.util.TypeAdapter;

public interface Counter<N extends Number>
extends Service {
    public void add();

    public void subtract();

    public N get();

    public static <N extends Number> Counter<N> newInstance() {
        return new Counter<N>(){
            Number i;
            boolean integer = false;
            {
                TypeAdapter flag = TypeAdapter.get();
                Class type = flag.getType();
                if (type == Integer.class) {
                    this.i = 0L;
                    this.integer = true;
                } else {
                    this.i = 0.0;
                }
            }

            @Override
            public void add() {
                this.i = this.integer ? (Number)(this.i.longValue() + 1L) : (Number)(this.i.doubleValue() + 1.0);
            }

            @Override
            public void subtract() {
                this.i = this.integer ? (Number)(this.i.longValue() - 1L) : (Number)(this.i.doubleValue() - 1.0);
            }

            @Override
            public N get() {
                return this.i;
            }
        };
    }

    public static <N extends Number> Counter<N> newInstance(final N influence) {
        return new Counter<N>(){
            Number i;
            final Number inf;
            boolean integer;
            {
                this.inf = influence;
                this.integer = false;
                TypeAdapter flag = TypeAdapter.get();
                Class type = flag.getType();
                if (type == Integer.class) {
                    this.i = 0L;
                    this.integer = true;
                } else {
                    this.i = 0.0;
                }
            }

            @Override
            public void add() {
                this.i = this.integer ? (Number)(this.i.longValue() + this.inf.longValue()) : (Number)(this.i.doubleValue() + this.inf.doubleValue());
            }

            @Override
            public void subtract() {
                this.i = this.integer ? (Number)(this.i.longValue() - this.inf.longValue()) : (Number)(this.i.doubleValue() - this.inf.doubleValue());
            }

            @Override
            public N get() {
                return this.i;
            }
        };
    }
}

