/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth.data.service;

import com.github.sanctum.labyrinth.data.service.AccessibleConstants;
import com.github.sanctum.labyrinth.data.service.ProtectedConstants;
import com.github.sanctum.panther.util.Deployable;
import com.github.sanctum.panther.util.TypeAdapter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public interface Constant<T> {
    public String getName();

    public Class<T> getType();

    public Class<?> getParent();

    public T getValue();

    default public List<T> getCousins() {
        return Constant.values(this.getParent(), this.getType());
    }

    public static <T> List<Constant<T>> values(Class<T> c) {
        ArrayList<Constant<T>> constants = new ArrayList<Constant<T>>();
        for (Constant constant : AccessibleConstants.of(c)) {
            constants.add(constant);
        }
        return constants;
    }

    public static <T> List<T> values(Type source, Class<T> c) {
        Deployable<List<T>> deployable = AccessibleConstants.collect(source).resolve(c);
        deployable.queue();
        return deployable.submit().join();
    }

    public static <T> List<Constant<T>> values(Type source, TypeAdapter<T> c) {
        Deployable<List<Constant<T>>> deployable = AccessibleConstants.collect(source).get(c.getType());
        deployable.queue();
        return deployable.submit().join();
    }

    public static List<Object> values(Object source) {
        Deployable<Map<Class<?>, List<Object>>> deployable = AccessibleConstants.collect(source).resolve();
        deployable.queue();
        Deployable<Map<Class<?>, List<Object>>> deployable2 = ProtectedConstants.collect(source).resolve();
        deployable2.queue();
        ArrayList<Object> list = new ArrayList<Object>();
        for (Collection collection : deployable.submit().join().values()) {
            list.addAll(collection);
        }
        for (Collection collection : deployable2.submit().join().values()) {
            list.addAll(collection);
        }
        return list;
    }

    public static <T> Constant<T> valueOf(TypeAdapter<T> flag, String name) {
        return AccessibleConstants.of(flag.getType()).get(name);
    }
}

