/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth.data.container;

import com.github.sanctum.labyrinth.LabyrinthProvider;
import com.github.sanctum.labyrinth.data.DataTable;
import com.github.sanctum.labyrinth.data.FileList;
import com.github.sanctum.labyrinth.data.FileManager;
import com.github.sanctum.labyrinth.data.container.PersistentData;
import com.github.sanctum.labyrinth.library.LabyrinthEncoded;
import com.github.sanctum.labyrinth.library.NamespacedKey;
import com.github.sanctum.panther.file.Configurable;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.Nullable;

public class PersistentContainer
extends PersistentData {
    private final NamespacedKey key;
    private final FileList list;
    private final Map<String, Object> dataMap = new HashMap<String, Object>();
    private final Map<String, Boolean> persistenceMap = new HashMap<String, Boolean>();

    public PersistentContainer(NamespacedKey key) {
        this.key = key;
        this.list = FileList.search(LabyrinthProvider.getInstance().getPluginInstance());
    }

    @Override
    public synchronized boolean exists(String key) {
        if (!this.dataMap.containsKey(key)) {
            return this.found(key);
        }
        return true;
    }

    protected synchronized boolean found(String key) {
        FileManager manager = this.list.get("components", "Persistent", Configurable.Type.JSON);
        boolean f = manager.read(c -> c.isString(this.key.getNamespace() + "." + this.key.getKey() + "." + key));
        if (f && !this.dataMap.containsKey(key)) {
            try {
                Object o = LabyrinthEncoded.of(manager.read(fi -> fi.getString(this.key.getNamespace() + "." + this.key.getKey() + "." + key))).deserialized();
                this.dataMap.put(key, o);
            }
            catch (IOException | ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return f;
    }

    public synchronized boolean delete(String key) {
        this.dataMap.remove(key);
        FileManager manager = this.list.get("components", "Persistent", Configurable.Type.JSON);
        if (manager.read(c -> c.isString(this.key.getNamespace() + "." + this.key.getKey() + "." + key)).booleanValue()) {
            DataTable inquiry = DataTable.newTable();
            inquiry.set(this.key.getNamespace() + "." + this.key.getKey() + "." + key, null);
            manager.write(inquiry);
            ConfigurationSection section = manager.read(c -> c.getNode(this.key.getNamespace() + "." + this.key.getKey()).get(ConfigurationSection.class));
            if (section != null && section.getKeys(false).isEmpty()) {
                inquiry.set(this.key.getNamespace() + "." + this.key.getKey(), null);
                manager.write(inquiry);
            }
            return true;
        }
        return false;
    }

    public synchronized void save(String key) throws IOException {
        if (this.persistenceMap.get(key).booleanValue()) {
            FileManager manager = this.list.get("components", "Persistent", Configurable.Type.JSON);
            DataTable inquiry = DataTable.newTable();
            inquiry.set(this.key.getNamespace() + "." + this.key.getKey() + "." + key, this.serialize(key));
            manager.write(inquiry);
        }
    }

    protected synchronized <R> R load(Class<R> type, String key) {
        FileManager manager = this.list.get("components", "Persistent", Configurable.Type.JSON);
        if (manager.read(c -> c.isString(this.key.getNamespace() + "." + this.key.getKey() + "." + key)).booleanValue()) {
            R value = this.deserialize(type, manager.read(f -> f.getString(this.key.getNamespace() + "." + this.key.getKey() + "." + key)));
            if (value == null) {
                this.delete(key);
                return null;
            }
            return this.attach(key, value);
        }
        return null;
    }

    public <R> R attach(String key, R value) {
        this.dataMap.put(key, value);
        this.persistenceMap.put(key, true);
        return value;
    }

    public <R> R lend(String key, R value) {
        this.dataMap.put(key, value);
        this.persistenceMap.put(key, false);
        return value;
    }

    @Override
    @Nullable
    public <R> R get(Class<R> type, String key) {
        if (!this.dataMap.containsKey(key)) {
            if (this.found(key)) {
                return this.load(type, key);
            }
            return null;
        }
        if (!type.isAssignableFrom(this.dataMap.get(key).getClass())) {
            return null;
        }
        return (R)this.dataMap.get(key);
    }

    @Override
    public Set<String> keySet() {
        return this.dataMap.keySet();
    }

    public synchronized List<String> persistentKeySet() {
        LinkedList<String> list = new LinkedList<String>();
        FileManager manager = this.list.get("components", "Persistent", Configurable.Type.JSON);
        if (manager.read(c -> c.isNode(this.key.getNamespace() + "." + this.key.getKey())).booleanValue()) {
            list.addAll(manager.read(f -> f.getNode(this.key.getNamespace() + "." + this.key.getKey()).getKeys(false)));
        }
        for (String cached : this.keySet()) {
            if (list.contains(cached)) continue;
            list.add(cached);
        }
        return list;
    }

    public Collection<Object> values() {
        return this.dataMap.values();
    }

    @Override
    public <R> Collection<? extends R> values(Class<R> type) {
        return this.dataMap.values().stream().filter(o -> type.isAssignableFrom(o.getClass())).map(o -> o).collect(Collectors.toList());
    }

    public NamespacedKey getKey() {
        return this.key;
    }

    @Nullable
    public <R> R deserialize(Class<R> type, String value) {
        return LabyrinthEncoded.of(value).deserialize(type);
    }

    @Nullable
    public String serialize(String key) throws IOException {
        return LabyrinthEncoded.of(this.dataMap.get(key)).serialize();
    }
}

