/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth.data.container;

import com.github.sanctum.labyrinth.library.NamespacedKey;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.persistence.PersistentDataAdapterContext;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface LegacyContainer {
    public <T, Z> void set(@NotNull NamespacedKey var1, @NotNull PersistentDataType<T, Z> var2, @NotNull Z var3);

    public <T, Z> boolean has(@NotNull NamespacedKey var1, @NotNull PersistentDataType<T, Z> var2);

    @Nullable
    public <T, Z> Z get(@NotNull NamespacedKey var1, @NotNull PersistentDataType<T, Z> var2);

    @NotNull
    public <T, Z> Z getOrDefault(@NotNull NamespacedKey var1, @NotNull PersistentDataType<T, Z> var2, @NotNull Z var3);

    @NotNull
    public Set<NamespacedKey> getKeys();

    public void remove(@NotNull NamespacedKey var1);

    public boolean isEmpty();

    @NotNull
    public PersistentDataAdapterContext getAdapterContext();

    public static class Impl
    implements LegacyContainer {
        private final PersistentDataContainer container;

        public Impl(PersistentDataContainer container) {
            this.container = container;
        }

        @Override
        public <T, Z> void set(@NotNull NamespacedKey key, @NotNull PersistentDataType<T, Z> type, @NotNull Z value) {
            if (key == null) {
                Impl.$$$reportNull$$$0(0);
            }
            if (type == null) {
                Impl.$$$reportNull$$$0(1);
            }
            if (value == null) {
                Impl.$$$reportNull$$$0(2);
            }
            org.bukkit.NamespacedKey k = new org.bukkit.NamespacedKey(key.getNamespace(), key.getKey());
            this.container.set(k, type, value);
        }

        @Override
        public <T, Z> boolean has(@NotNull NamespacedKey key, @NotNull PersistentDataType<T, Z> type) {
            if (key == null) {
                Impl.$$$reportNull$$$0(3);
            }
            if (type == null) {
                Impl.$$$reportNull$$$0(4);
            }
            org.bukkit.NamespacedKey k = new org.bukkit.NamespacedKey(key.getNamespace(), key.getKey());
            return this.container.has(k, type);
        }

        @Override
        @Nullable
        public <T, Z> Z get(@NotNull NamespacedKey key, @NotNull PersistentDataType<T, Z> type) {
            if (key == null) {
                Impl.$$$reportNull$$$0(5);
            }
            if (type == null) {
                Impl.$$$reportNull$$$0(6);
            }
            org.bukkit.NamespacedKey k = new org.bukkit.NamespacedKey(key.getNamespace(), key.getKey());
            return (Z)this.container.get(k, type);
        }

        @Override
        @NotNull
        public <T, Z> Z getOrDefault(@NotNull NamespacedKey key, @NotNull PersistentDataType<T, Z> type, @NotNull Z defaultValue) {
            if (key == null) {
                Impl.$$$reportNull$$$0(7);
            }
            if (type == null) {
                Impl.$$$reportNull$$$0(8);
            }
            if (defaultValue == null) {
                Impl.$$$reportNull$$$0(9);
            }
            org.bukkit.NamespacedKey k = new org.bukkit.NamespacedKey(key.getNamespace(), key.getKey());
            Object object = this.container.getOrDefault(k, type, defaultValue);
            if (object == null) {
                Impl.$$$reportNull$$$0(10);
            }
            return (Z)object;
        }

        @Override
        @NotNull
        public Set<NamespacedKey> getKeys() {
            HashSet<NamespacedKey> k = new HashSet<NamespacedKey>();
            for (org.bukkit.NamespacedKey key : this.container.getKeys()) {
                k.add(new NamespacedKey(key.getNamespace(), key.getKey()));
            }
            HashSet<NamespacedKey> hashSet = k;
            if (hashSet == null) {
                Impl.$$$reportNull$$$0(11);
            }
            return hashSet;
        }

        @Override
        public void remove(@NotNull NamespacedKey key) {
            if (key == null) {
                Impl.$$$reportNull$$$0(12);
            }
            org.bukkit.NamespacedKey k = new org.bukkit.NamespacedKey(key.getNamespace(), key.getKey());
            this.container.remove(k);
        }

        @Override
        public boolean isEmpty() {
            return this.container.isEmpty();
        }

        @Override
        @NotNull
        public PersistentDataAdapterContext getAdapterContext() {
            PersistentDataAdapterContext persistentDataAdapterContext = this.container.getAdapterContext();
            if (persistentDataAdapterContext == null) {
                Impl.$$$reportNull$$$0(13);
            }
            return persistentDataAdapterContext;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 10: 
                case 11: 
                case 13: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 10: 
                case 11: 
                case 13: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 1: 
                case 4: 
                case 6: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "defaultValue";
                    break;
                }
                case 10: 
                case 11: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/github/sanctum/labyrinth/data/container/LegacyContainer$Impl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/github/sanctum/labyrinth/data/container/LegacyContainer$Impl";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOrDefault";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKeys";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAdapterContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "set";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "has";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "get";
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "getOrDefault";
                    break;
                }
                case 10: 
                case 11: 
                case 13: {
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "remove";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 10: 
                case 11: 
                case 13: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

