/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth.data.container;

import com.github.sanctum.labyrinth.data.container.RegisteredKeyedService;
import com.github.sanctum.labyrinth.task.TaskScheduler;
import com.github.sanctum.panther.container.PantherCollection;
import com.github.sanctum.panther.container.PantherCollectors;
import com.github.sanctum.panther.container.PantherSet;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.bukkit.plugin.ServicePriority;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KeyedServiceManager<K> {
    private final PantherCollection<RegisteredKeyedService<?, K>> registry = new PantherSet();

    public <T> void register(@NotNull T service, @NotNull K key, @NotNull ServicePriority priority) {
        if (service == null) {
            KeyedServiceManager.$$$reportNull$$$0(0);
        }
        if (key == null) {
            KeyedServiceManager.$$$reportNull$$$0(1);
        }
        if (priority == null) {
            KeyedServiceManager.$$$reportNull$$$0(2);
        }
        this.registry.add(new RegisteredKeyedService<T, K>(service, key, priority));
    }

    public void unregisterAll(@NotNull K key) {
        if (key == null) {
            KeyedServiceManager.$$$reportNull$$$0(3);
        }
        for (RegisteredKeyedService registeredKeyedService : this.registry) {
            if (!key.getClass().isAssignableFrom(registeredKeyedService.getKey().getClass()) || !key.equals(registeredKeyedService.getKey())) continue;
            TaskScheduler.of(() -> this.registry.remove(service)).schedule();
        }
    }

    public <T> void unregisterAll(@NotNull Class<T> service) {
        if (service == null) {
            KeyedServiceManager.$$$reportNull$$$0(4);
        }
        for (RegisteredKeyedService registeredKeyedService : this.registry) {
            if (!service.isAssignableFrom(registeredKeyedService.getSuperClass())) continue;
            TaskScheduler.of(() -> this.registry.remove(s)).schedule();
        }
    }

    public <T> void unregister(@NotNull Class<T> service) {
        if (service == null) {
            KeyedServiceManager.$$$reportNull$$$0(5);
        }
        for (RegisteredKeyedService registeredKeyedService : this.registry) {
            if (!service.isAssignableFrom(registeredKeyedService.getSuperClass())) continue;
            TaskScheduler.of(() -> this.registry.remove(s)).schedule();
            break;
        }
    }

    public <T> void unregister(@NotNull T service) {
        if (service == null) {
            KeyedServiceManager.$$$reportNull$$$0(6);
        }
        for (RegisteredKeyedService registeredKeyedService : this.registry) {
            if (!registeredKeyedService.getService().equals(service)) continue;
            TaskScheduler.of(() -> this.registry.remove(s)).schedule();
            break;
        }
    }

    @Nullable
    public <T> T load(@NotNull Class<T> service, K key) {
        if (service == null) {
            KeyedServiceManager.$$$reportNull$$$0(7);
        }
        T serv = null;
        for (RegisteredKeyedService s : this.registry.stream().sorted(Comparator.comparingInt(value -> value.getPriority().ordinal())).collect(Collectors.toList())) {
            if (!service.isAssignableFrom(s.getSuperClass()) || !Objects.equals(s.getKey(), key)) continue;
            serv = s.getService();
        }
        return serv;
    }

    @Nullable
    public <T> T load(@NotNull Class<T> service, ServicePriority priority) {
        if (service == null) {
            KeyedServiceManager.$$$reportNull$$$0(8);
        }
        T serv = null;
        for (RegisteredKeyedService s : this.registry.stream().sorted(Comparator.comparingInt(value -> value.getPriority().ordinal())).collect(Collectors.toList())) {
            if (!service.isAssignableFrom(s.getSuperClass()) || s.getPriority() != priority) continue;
            serv = s.getService();
        }
        return serv;
    }

    @Nullable
    public <T> T load(@NotNull Class<T> service) {
        if (service == null) {
            KeyedServiceManager.$$$reportNull$$$0(9);
        }
        T serv = null;
        for (RegisteredKeyedService s : this.registry.stream().sorted(Comparator.comparingInt(value -> value.getPriority().ordinal())).collect(Collectors.toList())) {
            if (!service.isAssignableFrom(s.getSuperClass())) continue;
            serv = s.getService();
        }
        return serv;
    }

    @Nullable
    public <T> RegisteredKeyedService<T, K> getRegistration(@NotNull Class<T> service) {
        if (service == null) {
            KeyedServiceManager.$$$reportNull$$$0(10);
        }
        for (RegisteredKeyedService s : this.registry.stream().sorted(Comparator.comparingInt(value -> value.getPriority().ordinal())).collect(Collectors.toList())) {
            if (!service.isAssignableFrom(s.getSuperClass())) continue;
            return s;
        }
        return null;
    }

    @Nullable
    public <T> RegisteredKeyedService<T, K> getRegistration(@NotNull Class<T> service, K key) {
        if (service == null) {
            KeyedServiceManager.$$$reportNull$$$0(11);
        }
        for (RegisteredKeyedService registeredKeyedService : this.registry) {
            if (!service.isAssignableFrom(registeredKeyedService.getSuperClass()) || !Objects.equals(key, registeredKeyedService.getKey())) continue;
            return registeredKeyedService;
        }
        return null;
    }

    @NotNull
    public List<RegisteredKeyedService<?, K>> getRegistrations(@NotNull K key) {
        if (key == null) {
            KeyedServiceManager.$$$reportNull$$$0(12);
        }
        ArrayList services = new ArrayList();
        for (RegisteredKeyedService registeredKeyedService : this.registry) {
            if (!key.getClass().isAssignableFrom(registeredKeyedService.getKey().getClass()) || !Objects.equals(key, registeredKeyedService.getKey())) continue;
            services.add(registeredKeyedService);
        }
        ArrayList arrayList = services;
        if (arrayList == null) {
            KeyedServiceManager.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    @NotNull
    public <T> List<RegisteredKeyedService<T, K>> getRegistrations(@NotNull Class<T> service) {
        if (service == null) {
            KeyedServiceManager.$$$reportNull$$$0(14);
        }
        ArrayList<RegisteredKeyedService<T, K>> services = new ArrayList<RegisteredKeyedService<T, K>>();
        for (RegisteredKeyedService registeredKeyedService : this.registry) {
            if (!service.isAssignableFrom(registeredKeyedService.getSuperClass())) continue;
            services.add(registeredKeyedService);
        }
        ArrayList<RegisteredKeyedService<T, K>> arrayList = services;
        if (arrayList == null) {
            KeyedServiceManager.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    @NotNull
    public PantherCollection<Class<?>> getKnownServices() {
        PantherCollection<Class<?>> pantherCollection = this.registry.stream().map(RegisteredKeyedService::getSuperClass).collect(PantherCollectors.toImmutableSet());
        if (pantherCollection == null) {
            KeyedServiceManager.$$$reportNull$$$0(16);
        }
        return pantherCollection;
    }

    public <T> boolean isProvided(@NotNull Class<T> service) {
        if (service == null) {
            KeyedServiceManager.$$$reportNull$$$0(17);
        }
        return this.registry.stream().anyMatch(r -> service.isAssignableFrom(r.getSuperClass()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 1: 
            case 3: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "priority";
                break;
            }
            case 13: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/github/sanctum/labyrinth/data/container/KeyedServiceManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/github/sanctum/labyrinth/data/container/KeyedServiceManager";
                break;
            }
            case 13: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getRegistrations";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getKnownServices";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "register";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "unregisterAll";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "unregister";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getRegistration";
                break;
            }
            case 12: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getRegistrations";
                break;
            }
            case 13: 
            case 15: 
            case 16: {
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isProvided";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

