/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth.data.container;

import com.github.sanctum.labyrinth.data.CuboidAxis;
import com.github.sanctum.labyrinth.data.CuboidLocation;
import com.github.sanctum.labyrinth.data.DefaultCuboid;
import com.github.sanctum.labyrinth.data.DefaultFlag;
import com.github.sanctum.labyrinth.data.RegionServicesManager;
import com.github.sanctum.labyrinth.data.SimpleKeyedValue;
import com.github.sanctum.labyrinth.data.container.Region;
import com.github.sanctum.labyrinth.library.StringUtils;
import com.github.sanctum.labyrinth.task.TaskScheduler;
import com.github.sanctum.panther.util.HUID;
import java.util.Random;
import java.util.function.Function;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.util.Vector;

public interface Cuboid {
    public static Cuboid fromPoints(Location start, Location end) {
        return new DefaultCuboid(start, end);
    }

    public VisualBoundary getBoundary(Player var1);

    public int getTotalBlocks();

    public CuboidAxis getAxis();

    public CuboidLocation getLocation();

    default public Region toRegion() {
        return new Region(this.getLocation().getWorld(), this.getAxis().getxMin(), this.getAxis().getxMax(), this.getAxis().getyMin(), this.getAxis().getyMax(), this.getAxis().getzMin(), this.getAxis().getzMax(), HUID.randomID()){};
    }

    default public <R extends Region> R toRegion(Function<SimpleKeyedValue<Cuboid, SimpleKeyedValue<Location, Location>>, R> function) {
        return (R)((Region)function.apply(SimpleKeyedValue.of(this, SimpleKeyedValue.of(new Location(this.getLocation().getWorld(), (double)this.getAxis().getxMin(), (double)this.getAxis().getyMin(), (double)this.getAxis().getzMin()), new Location(this.getLocation().getWorld(), (double)this.getAxis().getxMax(), (double)this.getAxis().getyMax(), (double)this.getAxis().getzMax())))));
    }

    public static class VisualBoundary {
        private final double xMax;
        private final double xMin;
        private final double yMax;
        private final double yMin;
        private final double zMax;
        private final double zMin;
        private Player p;

        public VisualBoundary(double xMax, double xMin, double yMax, double yMin, double zMax, double zMin) {
            this.xMax = xMax;
            this.zMax = zMax;
            this.yMax = yMax;
            this.xMin = xMin;
            this.zMin = zMin;
            this.yMin = yMin;
        }

        public VisualBoundary setViewer(Player target) {
            this.p = target;
            return this;
        }

        public static Color randomColor() {
            Random r = new Random();
            switch (r.nextInt(25)) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    return Particle.YELLOW.toColor();
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    return Particle.WHITE.toColor();
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    return Particle.RED.toColor();
                }
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: {
                    return Particle.GREEN.toColor();
                }
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: {
                    return Particle.BLUE.toColor();
                }
            }
            return Particle.WHITE.toColor();
        }

        public void deploy() {
            double j;
            double i;
            Particle.DustOptions dustOptions = new Particle.DustOptions(VisualBoundary.randomColor(), 2.0f);
            for (i = this.xMin; i < this.xMax + 1.0; i += 1.0) {
                for (j = this.zMin; j < this.zMax + 1.0; j += 1.0) {
                    this.p.spawnParticle(org.bukkit.Particle.REDSTONE, i, this.yMax, j, 1, (Object)dustOptions);
                    this.p.spawnParticle(org.bukkit.Particle.WATER_DROP, i, this.yMax, j, 1);
                }
            }
            for (i = this.xMin; i < this.xMax + 1.0; i += 1.0) {
                for (j = this.yMin; j < this.yMax + 1.0; j += 1.0) {
                    this.p.spawnParticle(org.bukkit.Particle.REDSTONE, i, j, this.zMin, 1, (Object)dustOptions);
                    this.p.spawnParticle(org.bukkit.Particle.WATER_DROP, i, j, this.zMin, 1);
                }
            }
            for (i = this.xMin; i < this.xMax + 1.0; i += 1.0) {
                for (j = this.yMin; j < this.yMax + 1.0; j += 1.0) {
                    this.p.spawnParticle(org.bukkit.Particle.REDSTONE, i, j, this.zMax, 1, (Object)dustOptions);
                    this.p.spawnParticle(org.bukkit.Particle.WATER_DROP, i, j, this.zMax, 1);
                }
            }
            for (i = this.zMin; i < this.zMax + 1.0; i += 1.0) {
                for (j = this.yMin; j < this.yMax + 1.0; j += 1.0) {
                    this.p.spawnParticle(org.bukkit.Particle.REDSTONE, this.xMin, j, i, 1, (Object)dustOptions);
                    this.p.spawnParticle(org.bukkit.Particle.WATER_DROP, this.xMin, j, i, 1);
                }
            }
            for (i = this.zMin; i < this.zMax + 1.0; i += 1.0) {
                for (j = this.yMin; j < this.yMax + 1.0; j += 1.0) {
                    this.p.spawnParticle(org.bukkit.Particle.REDSTONE, this.xMax, j, i, 1, (Object)dustOptions);
                    this.p.spawnParticle(org.bukkit.Particle.WATER_DROP, this.xMax, j, i, 1);
                }
            }
        }

        public void deploy(Assembly assembly) {
            if (assembly != null) {
                double j;
                double i;
                for (i = this.xMin; i < this.xMax + 1.0; i += 1.0) {
                    for (j = this.zMin; j < this.zMax + 1.0; j += 1.0) {
                        assembly.accept(new Action(this.p, i, this.yMax, j));
                    }
                }
                for (i = this.xMin; i < this.xMax + 1.0; i += 1.0) {
                    for (j = this.yMin; j < this.yMax + 1.0; j += 1.0) {
                        assembly.accept(new Action(this.p, i, j, this.zMin));
                    }
                }
                for (i = this.xMin; i < this.xMax + 1.0; i += 1.0) {
                    for (j = this.yMin; j < this.yMax + 1.0; j += 1.0) {
                        assembly.accept(new Action(this.p, i, j, this.zMax));
                    }
                }
                for (i = this.zMin; i < this.zMax + 1.0; i += 1.0) {
                    for (j = this.yMin; j < this.yMax + 1.0; j += 1.0) {
                        assembly.accept(new Action(this.p, this.xMin, j, i));
                    }
                }
                for (i = this.zMin; i < this.zMax + 1.0; i += 1.0) {
                    for (j = this.yMin; j < this.yMax + 1.0; j += 1.0) {
                        assembly.accept(new Action(this.p, this.xMax, j, i));
                    }
                }
            }
        }

        public void deploy(Particle color) {
            double j;
            double i;
            Particle.DustOptions dustOptions = new Particle.DustOptions(color.toColor(), 2.0f);
            for (i = this.xMin; i < this.xMax + 1.0; i += 1.0) {
                for (j = this.zMin; j < this.zMax + 1.0; j += 1.0) {
                    this.p.spawnParticle(org.bukkit.Particle.REDSTONE, i, this.yMax, j, 1, (Object)dustOptions);
                }
            }
            for (i = this.xMin; i < this.xMax + 1.0; i += 1.0) {
                for (j = this.yMin; j < this.yMax + 1.0; j += 1.0) {
                    this.p.spawnParticle(org.bukkit.Particle.REDSTONE, i, j, this.zMin, 1, (Object)dustOptions);
                }
            }
            for (i = this.xMin; i < this.xMax + 1.0; i += 1.0) {
                for (j = this.yMin; j < this.yMax + 1.0; j += 1.0) {
                    this.p.spawnParticle(org.bukkit.Particle.REDSTONE, i, j, this.zMax, 1, (Object)dustOptions);
                }
            }
            for (i = this.zMin; i < this.zMax + 1.0; i += 1.0) {
                for (j = this.yMin; j < this.yMax + 1.0; j += 1.0) {
                    this.p.spawnParticle(org.bukkit.Particle.REDSTONE, this.xMin, j, i, 1, (Object)dustOptions);
                }
            }
            for (i = this.zMin; i < this.zMax + 1.0; i += 1.0) {
                for (j = this.yMin; j < this.yMax + 1.0; j += 1.0) {
                    this.p.spawnParticle(org.bukkit.Particle.REDSTONE, this.xMax, j, i, 1, (Object)dustOptions);
                }
            }
        }

        public void laser(Assembly assembly, Location direction) {
            if (assembly != null) {
                Location origin = this.p.getEyeLocation();
                Vector target = direction.toVector();
                origin.setDirection(target.subtract(origin.toVector()));
                Vector increase = origin.getDirection().multiply(1.3);
                if (!direction.getChunk().equals(this.p.getLocation().getChunk())) {
                    for (int counter = 0; counter < 10; ++counter) {
                        Location location = origin.add(increase);
                        double x = location.getX();
                        double y = location.getY() + 0.5;
                        double z = location.getZ();
                        assembly.accept(new Action(this.p, x, y, z));
                    }
                }
            }
        }

        public static enum Particle {
            WHITE(Color.fromRGB((int)255, (int)255, (int)255)),
            GREEN(Color.fromRGB((int)66, (int)245, (int)102)),
            RED(Color.fromRGB((int)255, (int)10, (int)10)),
            YELLOW(Color.fromRGB((int)207, (int)183, (int)4)),
            CUSTOM(Color.AQUA),
            BLUE(Color.fromRGB((int)3, (int)148, (int)252));

            private final Color color;

            private Particle(Color color) {
                this.color = color;
            }

            public Color toColor() {
                return this.color;
            }

            public Color toColor(int hex) {
                if (this != CUSTOM) {
                    throw new IllegalStateException("Invalid particle color usage. Expected 'CUSTOM'");
                }
                return Color.fromRGB((int)hex);
            }
        }

        public static class Action {
            private final Player p;
            private final double x;
            private final double y;
            private final double z;

            public Action(Player p, double x, double y, double z) {
                this.p = p;
                this.x = x;
                this.y = y;
                this.z = z;
            }

            public double getX() {
                return this.x;
            }

            public double getY() {
                return this.y;
            }

            public double getZ() {
                return this.z;
            }

            public Player getPlayer() {
                return this.p;
            }

            public void box() {
                this.p.spawnParticle(org.bukkit.Particle.REDSTONE, this.getX(), this.getY(), this.getZ(), 1, (Object)new Particle.DustOptions(VisualBoundary.randomColor(), 2.0f));
                this.p.spawnParticle(org.bukkit.Particle.WATER_DROP, this.getX(), this.getY(), this.getZ(), 1);
            }

            public void walls() {
                this.p.spawnParticle(org.bukkit.Particle.REDSTONE, this.getX(), this.getY(), this.getZ(), 1, (Object)new Particle.DustOptions(VisualBoundary.randomColor(), 2.0f));
            }

            public void box(Material material, long decay) {
                Location location = new Location(this.p.getWorld(), this.getX(), this.getY(), this.getZ());
                BlockData og = location.getBlock().getState().getBlockData().getMaterial().createBlockData();
                this.p.sendBlockChange(location, material.createBlockData());
                TaskScheduler.of(() -> this.p.sendBlockChange(location, og)).scheduleLater(decay);
            }
        }

        @FunctionalInterface
        public static interface Assembly {
            public void accept(Action var1);
        }
    }

    public static abstract class Flag
    implements Listener {
        private boolean allowed;
        private final String id;

        public Flag(Flag flag) {
            this.id = flag.getId();
            this.allowed = flag.allowed;
        }

        public Flag(String id) {
            this.id = id;
            this.allowed = true;
        }

        public Flag clone() {
            return new DefaultFlag(this);
        }

        public final void setEnabled(boolean allowed) {
            this.allowed = allowed;
        }

        public final boolean isEnabled() {
            return this.allowed;
        }

        public final boolean isDefault() {
            return StringUtils.use(this.id).containsIgnoreCase("break", "build", "pvp");
        }

        public final boolean isValid() {
            return RegionServicesManager.getInstance().getFlagManager().getFlag(this.id).isPresent();
        }

        public String getId() {
            return this.id;
        }
    }
}

