/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth.data.container;

import com.github.sanctum.labyrinth.LabyrinthProvider;
import com.github.sanctum.labyrinth.data.container.ListMergeProcess;
import com.github.sanctum.labyrinth.data.container.PantherCollectionMergeProcess;
import com.github.sanctum.labyrinth.library.StringUtils;
import com.github.sanctum.labyrinth.library.TimeWatch;
import com.github.sanctum.panther.annotation.Ordinal;
import com.github.sanctum.panther.container.PantherCollection;
import com.github.sanctum.panther.util.ProgressBar;
import com.github.sanctum.panther.util.Task;
import com.github.sanctum.panther.util.TaskChain;
import java.text.NumberFormat;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;

public abstract class CollectionTask<T>
extends Task
implements Iterator<T> {
    private static final long serialVersionUID = -3836578226377446193L;
    boolean paused;

    public CollectionTask(String key) {
        super(key, 1, TaskChain.getSynchronous());
    }

    public CollectionTask(String key, int runtime) {
        super(key, 1, TaskChain.getChain(runtime));
    }

    protected final String correctDecimal(String s) {
        String[] split = s.split("\\.");
        if (split.length == 1) {
            return split[0] + ".00";
        }
        if (split[1].length() == 1) {
            return split[0] + ".0" + split[1];
        }
        return s;
    }

    public abstract double getCompletion();

    public abstract long getTimeStarted();

    public abstract long getRecentExecution();

    public abstract T current();

    @Override
    public abstract boolean hasNext();

    public abstract boolean hasNext(int var1);

    @Override
    @Ordinal
    public abstract T next();

    @Ordinal(value=1)
    public abstract T next(int var1);

    public abstract void reset();

    public void setPaused(boolean paused) {
        this.paused = paused;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public static <T> CollectionTask<T> process(final PantherCollection<T> collection, final String table, final int interval, final Consumer<T> action) {
        return new CollectionTask<T>(table, 1){
            private static final long serialVersionUID = 8714205665644616539L;
            final PantherCollection<T> collector;
            int index;
            long started;
            long lastRan;
            T current;
            {
                super(key, runtime);
                this.index = 0;
                this.started = 0L;
                this.lastRan = 0L;
                this.collector = collection;
            }

            @Override
            public double getCompletion() {
                return Math.min(100.0, new ProgressBar().setProgress(this.index + 1).setGoal(this.collector.size()).getPercentage());
            }

            @Override
            public long getTimeStarted() {
                return this.started;
            }

            @Override
            public long getRecentExecution() {
                return this.lastRan;
            }

            @Override
            public T current() {
                return this.current;
            }

            @Override
            public boolean hasNext() {
                return this.index < this.collector.size();
            }

            @Override
            public boolean hasNext(int bounds) {
                return this.index + bounds < this.collector.size();
            }

            @Override
            @Ordinal
            public T next() {
                return this.next(interval);
            }

            @Override
            @Ordinal(value=1)
            public T next(int bounds) {
                int processed = 0;
                if (this.isPaused()) {
                    return this.current;
                }
                if (this.index < this.collector.size()) {
                    if (this.started == 0L) {
                        this.started = System.currentTimeMillis();
                    }
                    this.lastRan = System.currentTimeMillis();
                    for (int i = this.index; i < this.collector.size(); ++i) {
                        if (processed > bounds) continue;
                        Object o = this.collector.get(i);
                        this.current = o;
                        action.accept(o);
                        ++this.index;
                        ++processed;
                    }
                    LabyrinthProvider.getInstance().getLogger().info(StringUtils.use("- Collection task " + table + ";RUN @ &e" + this.correctDecimal(NumberFormat.getNumberInstance().format(this.getCompletion())) + "&f%").translate());
                    return this.current;
                }
                TimeWatch.Recording recording = TimeWatch.Recording.subtract(this.started);
                LabyrinthProvider.getInstance().getLogger().info(StringUtils.use("- &aTask " + table + " completed after " + recording.getHours() + " hours " + recording.getMinutes() + " minutes & " + recording.getSeconds() + " seconds.").translate());
                this.cancel();
                return this.current;
            }

            @Override
            public void reset() {
                this.index = 0;
                this.started = 0L;
                this.lastRan = 0L;
                this.current = null;
            }
        };
    }

    public static <T> CollectionTask<T> processSilent(final PantherCollection<T> collection, String table, final int interval, final Consumer<T> action) {
        return new CollectionTask<T>(table, 1){
            private static final long serialVersionUID = -3595452685342615045L;
            final PantherCollection<T> collector;
            int index;
            long started;
            long lastRan;
            T current;
            {
                super(key, runtime);
                this.collector = collection;
                this.index = 0;
                this.started = 0L;
                this.lastRan = 0L;
            }

            @Override
            public double getCompletion() {
                return Math.min(100.0, new ProgressBar().setProgress(this.index + 1).setGoal(this.collector.size()).getPercentage());
            }

            @Override
            public T current() {
                return this.current;
            }

            @Override
            public long getTimeStarted() {
                return this.started;
            }

            @Override
            public long getRecentExecution() {
                return this.lastRan;
            }

            @Override
            public boolean hasNext() {
                return this.index < this.collector.size();
            }

            @Override
            public boolean hasNext(int bounds) {
                return this.index + bounds < this.collector.size();
            }

            @Override
            @Ordinal
            public T next() {
                return this.next(interval);
            }

            @Override
            @Ordinal(value=1)
            public T next(int bounds) {
                int processed = 0;
                if (this.isPaused()) {
                    return this.current;
                }
                if (this.index < this.collector.size()) {
                    if (this.started == 0L) {
                        this.started = System.currentTimeMillis();
                    }
                    this.lastRan = System.currentTimeMillis();
                    for (int i = this.index; i < this.collector.size(); ++i) {
                        if (processed > bounds) continue;
                        Object o = this.collector.get(i);
                        this.current = o;
                        action.accept(o);
                        ++this.index;
                        ++processed;
                    }
                    return this.current;
                }
                this.cancel();
                return this.current;
            }

            @Override
            public void reset() {
                this.index = 0;
                this.started = 0L;
                this.lastRan = 0L;
                this.current = null;
            }
        };
    }

    public static <T> CollectionTask<T> process(final List<T> collection, final String table, final int interval, final Consumer<T> action) {
        return new CollectionTask<T>(table, 1){
            private static final long serialVersionUID = 5908258963151067910L;
            final List<T> collector;
            int index;
            long started;
            long lastRan;
            T current;
            {
                super(key, runtime);
                this.index = 0;
                this.started = 0L;
                this.lastRan = 0L;
                this.collector = collection;
            }

            @Override
            public double getCompletion() {
                return Math.min(100.0, new ProgressBar().setProgress(this.index + 1).setGoal(this.collector.size()).getPercentage());
            }

            @Override
            public T current() {
                return this.current;
            }

            @Override
            public long getTimeStarted() {
                return this.started;
            }

            @Override
            public long getRecentExecution() {
                return this.lastRan;
            }

            @Override
            public boolean hasNext() {
                return this.index < this.collector.size();
            }

            @Override
            public boolean hasNext(int bounds) {
                return this.index + bounds < this.collector.size();
            }

            @Override
            @Ordinal
            public T next() {
                return this.next(interval);
            }

            @Override
            @Ordinal(value=1)
            public T next(int bounds) {
                int processed = 0;
                if (this.isPaused()) {
                    return this.current;
                }
                if (this.index < this.collector.size()) {
                    if (this.started == 0L) {
                        this.started = System.currentTimeMillis();
                    }
                    this.lastRan = System.currentTimeMillis();
                    for (int i = this.index; i < this.collector.size(); ++i) {
                        if (processed > bounds) continue;
                        Object o = this.collector.get(i);
                        this.current = o;
                        action.accept(o);
                        ++this.index;
                        ++processed;
                    }
                    LabyrinthProvider.getInstance().getLogger().info(StringUtils.use("- Collection task " + table + ";RUN @ &e" + this.correctDecimal(NumberFormat.getNumberInstance().format(this.getCompletion())) + "&f%").translate());
                    return this.current;
                }
                TimeWatch.Recording recording = TimeWatch.Recording.subtract(this.started);
                LabyrinthProvider.getInstance().getLogger().info(StringUtils.use("- &aTask " + table + " completed after " + recording.getHours() + " hours " + recording.getMinutes() + " minutes & " + recording.getSeconds() + " seconds.").translate());
                this.cancel();
                return this.current;
            }

            @Override
            public void reset() {
                this.index = 0;
                this.started = 0L;
                this.lastRan = 0L;
                this.current = null;
            }
        };
    }

    public static <T> CollectionTask<T> processSilent(final List<T> collection, String table, final int interval, final Consumer<T> action) {
        return new CollectionTask<T>(table, 1){
            private static final long serialVersionUID = -3595452685342615045L;
            final List<T> collector;
            int index;
            long started;
            long lastRan;
            T current;
            {
                super(key, runtime);
                this.collector = collection;
                this.index = 0;
                this.started = 0L;
                this.lastRan = 0L;
            }

            @Override
            public double getCompletion() {
                return Math.min(100.0, new ProgressBar().setProgress(this.index + 1).setGoal(this.collector.size()).getPercentage());
            }

            @Override
            public T current() {
                return this.current;
            }

            @Override
            public long getTimeStarted() {
                return this.started;
            }

            @Override
            public long getRecentExecution() {
                return this.lastRan;
            }

            @Override
            public boolean hasNext() {
                return this.index < this.collector.size();
            }

            @Override
            public boolean hasNext(int bounds) {
                return this.index + bounds < this.collector.size();
            }

            @Override
            @Ordinal
            public T next() {
                return this.next(interval);
            }

            @Override
            @Ordinal(value=1)
            public T next(int bounds) {
                int processed = 0;
                if (this.isPaused()) {
                    return this.current;
                }
                if (this.index < this.collector.size()) {
                    if (this.started == 0L) {
                        this.started = System.currentTimeMillis();
                    }
                    this.lastRan = System.currentTimeMillis();
                    for (int i = this.index; i < this.collector.size(); ++i) {
                        if (processed > bounds) continue;
                        Object o = this.collector.get(i);
                        this.current = o;
                        action.accept(o);
                        ++this.index;
                        ++processed;
                    }
                    return this.current;
                }
                this.cancel();
                return this.current;
            }

            @Override
            public void reset() {
                this.index = 0;
                this.started = 0L;
                this.lastRan = 0L;
                this.current = null;
            }
        };
    }

    public static <T> CollectionTask<T> process(final T[] elements, final String table, final int interval, final Consumer<T> action) {
        return new CollectionTask<T>(table, 1){
            private static final long serialVersionUID = -3595452685342615045L;
            final T[] collector;
            int index;
            long started;
            long lastRan;
            T current;
            {
                super(key, runtime);
                this.collector = elements;
                this.index = 0;
                this.started = 0L;
                this.lastRan = 0L;
            }

            @Override
            public double getCompletion() {
                return Math.min(100.0, new ProgressBar().setProgress(this.index + 1).setGoal(this.collector.length).getPercentage());
            }

            @Override
            public T current() {
                return this.current;
            }

            @Override
            public long getTimeStarted() {
                return this.started;
            }

            @Override
            public long getRecentExecution() {
                return this.lastRan;
            }

            @Override
            public boolean hasNext() {
                return this.index < this.collector.length;
            }

            @Override
            public boolean hasNext(int bounds) {
                return this.index + bounds < this.collector.length;
            }

            @Override
            @Ordinal
            public T next() {
                return this.next(interval);
            }

            @Override
            @Ordinal(value=1)
            public T next(int bounds) {
                int processed = 0;
                if (this.isPaused()) {
                    return this.current;
                }
                if (this.index < this.collector.length) {
                    if (this.started == 0L) {
                        this.started = System.currentTimeMillis();
                    }
                    this.lastRan = System.currentTimeMillis();
                    for (int i = this.index; i < this.collector.length; ++i) {
                        if (processed > bounds) continue;
                        Object o = this.collector[i];
                        this.current = o;
                        action.accept(o);
                        ++this.index;
                        ++processed;
                    }
                    LabyrinthProvider.getInstance().getLogger().info(StringUtils.use("- Collection task " + table + ";RUN @ &e" + this.correctDecimal(NumberFormat.getNumberInstance().format(this.getCompletion())) + "&f%").translate());
                    return this.current;
                }
                TimeWatch.Recording recording = TimeWatch.Recording.subtract(this.started);
                LabyrinthProvider.getInstance().getLogger().info(StringUtils.use("- &aTask " + table + " completed after " + recording.getHours() + " hours " + recording.getMinutes() + " minutes & " + recording.getSeconds() + " seconds.").translate());
                this.cancel();
                return this.current;
            }

            @Override
            public void reset() {
                this.index = 0;
                this.started = 0L;
                this.lastRan = 0L;
                this.current = null;
            }
        };
    }

    public static <T> CollectionTask<T> process(final T[] elements, final String table, final int interval, int runtime, final Consumer<T> action) {
        return new CollectionTask<T>(table, runtime){
            private static final long serialVersionUID = -3595452685342615045L;
            final T[] collector;
            int index;
            long started;
            long lastRan;
            T current;
            {
                super(key, runtime);
                this.collector = elements;
                this.index = 0;
                this.started = 0L;
                this.lastRan = 0L;
            }

            @Override
            public double getCompletion() {
                return Math.min(100.0, new ProgressBar().setProgress(this.index + 1).setGoal(this.collector.length).getPercentage());
            }

            @Override
            public T current() {
                return this.current;
            }

            @Override
            public long getTimeStarted() {
                return this.started;
            }

            @Override
            public long getRecentExecution() {
                return this.lastRan;
            }

            @Override
            public boolean hasNext() {
                return this.index < this.collector.length;
            }

            @Override
            public boolean hasNext(int bounds) {
                return this.index + bounds < this.collector.length;
            }

            @Override
            @Ordinal
            public T next() {
                return this.next(interval);
            }

            @Override
            @Ordinal(value=1)
            public T next(int bounds) {
                int processed = 0;
                if (this.isPaused()) {
                    return this.current;
                }
                if (this.index < this.collector.length) {
                    if (this.started == 0L) {
                        this.started = System.currentTimeMillis();
                    }
                    this.lastRan = System.currentTimeMillis();
                    for (int i = this.index; i < this.collector.length; ++i) {
                        if (processed > bounds) continue;
                        Object o = this.collector[i];
                        this.current = o;
                        action.accept(o);
                        ++this.index;
                        ++processed;
                    }
                    LabyrinthProvider.getInstance().getLogger().info(StringUtils.use("- Collection task " + table + ";RUN @ &e" + this.correctDecimal(NumberFormat.getNumberInstance().format(this.getCompletion())) + "&f%").translate());
                    return this.current;
                }
                TimeWatch.Recording recording = TimeWatch.Recording.subtract(this.started);
                LabyrinthProvider.getInstance().getLogger().info(StringUtils.use("- &aTask " + table + " completed after " + recording.getHours() + " hours " + recording.getMinutes() + " minutes & " + recording.getSeconds() + " seconds.").translate());
                this.cancel();
                return this.current;
            }

            @Override
            public void reset() {
                this.index = 0;
                this.started = 0L;
                this.lastRan = 0L;
                this.current = null;
            }
        };
    }

    public static <T> CollectionTask<T> processSilent(final T[] elements, String table, final int interval, final Consumer<T> action) {
        return new CollectionTask<T>(table, 1){
            private static final long serialVersionUID = -3595452685342615045L;
            final T[] collector;
            int index;
            long started;
            long lastRan;
            T current;
            {
                super(key, runtime);
                this.collector = elements;
                this.index = 0;
                this.started = 0L;
                this.lastRan = 0L;
            }

            @Override
            public double getCompletion() {
                return Math.min(100.0, new ProgressBar().setProgress(this.index + 1).setGoal(this.collector.length).getPercentage());
            }

            @Override
            public T current() {
                return this.current;
            }

            @Override
            public long getTimeStarted() {
                return this.started;
            }

            @Override
            public long getRecentExecution() {
                return this.lastRan;
            }

            @Override
            public boolean hasNext() {
                return this.index < this.collector.length;
            }

            @Override
            public boolean hasNext(int bounds) {
                return this.index + bounds < this.collector.length;
            }

            @Override
            @Ordinal
            public T next() {
                return this.next(interval);
            }

            @Override
            @Ordinal(value=1)
            public T next(int bounds) {
                int processed = 0;
                if (this.isPaused()) {
                    return this.current;
                }
                if (this.index < this.collector.length) {
                    if (this.started == 0L) {
                        this.started = System.currentTimeMillis();
                    }
                    this.lastRan = System.currentTimeMillis();
                    for (int i = this.index; i < this.collector.length; ++i) {
                        if (processed > bounds) continue;
                        Object o = this.collector[i];
                        this.current = o;
                        action.accept(o);
                        ++this.index;
                        ++processed;
                    }
                    return this.current;
                }
                this.cancel();
                return this.current;
            }

            @Override
            public void reset() {
                this.index = 0;
                this.started = 0L;
                this.lastRan = 0L;
                this.current = null;
            }
        };
    }

    public static <T> CollectionTask<T> merge(PantherCollection<T> target, PantherCollection<T> additive, String table, int interval) {
        return new PantherCollectionMergeProcess<T>(target, additive, interval, table);
    }

    public static <T> CollectionTask<T> merge(List<T> target, List<T> additive, String table, int interval) {
        return new ListMergeProcess<T>(target, additive, interval, table);
    }
}

