/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth.data;

import com.github.sanctum.labyrinth.data.YamlExtension;
import com.github.sanctum.panther.file.Configurable;
import com.github.sanctum.panther.file.MemorySpace;
import com.github.sanctum.panther.util.PantherLogger;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;

public class YamlConfiguration
extends Configurable {
    protected final String n;
    protected final String d;
    protected final File file;
    protected FileConfiguration fc;
    protected final File parent;
    protected final Plugin plugin;

    protected YamlConfiguration(Plugin plugin, String n, String d) {
        File parent;
        this.n = n;
        this.d = d;
        this.plugin = plugin;
        File pluginDataDir = plugin.getDataFolder();
        if (!pluginDataDir.exists()) {
            pluginDataDir.mkdir();
        }
        File file = parent = d == null || d.isEmpty() ? pluginDataDir : new File(pluginDataDir, d);
        if (!parent.exists()) {
            parent.mkdir();
        }
        this.parent = parent;
        this.file = new File(parent, n.concat(".yml"));
    }

    protected synchronized FileConfiguration getConfig() {
        if (this.fc == null) {
            if (!this.file.exists()) {
                org.bukkit.configuration.file.YamlConfiguration result = new org.bukkit.configuration.file.YamlConfiguration();
                this.fc = result;
                return result;
            }
            this.fc = org.bukkit.configuration.file.YamlConfiguration.loadConfiguration((File)this.file);
        }
        return this.fc;
    }

    @Override
    public void reload() {
        if (!this.file.exists()) {
            this.fc = new org.bukkit.configuration.file.YamlConfiguration();
        }
        this.fc = org.bukkit.configuration.file.YamlConfiguration.loadConfiguration((File)this.file);
        File defConfigStream = new File(this.plugin.getDataFolder(), this.getName() + ".yml");
        org.bukkit.configuration.file.YamlConfiguration defConfig = org.bukkit.configuration.file.YamlConfiguration.loadConfiguration((File)defConfigStream);
        this.fc.setDefaults((Configuration)defConfig);
    }

    @Override
    public boolean save() {
        try {
            this.getConfig().save(this.file);
            return true;
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to save configuration file!", e);
        }
    }

    @Override
    public boolean delete() {
        return this.file.delete();
    }

    @Override
    public boolean create() throws IOException {
        return this.parent.exists() ? this.file.createNewFile() : this.parent.mkdir() && this.file.createNewFile();
    }

    @Override
    public boolean exists() {
        return this.parent.exists() && this.file.exists();
    }

    @Override
    public String getName() {
        return this.n;
    }

    @Override
    public String getDirectory() {
        return this.d;
    }

    @Override
    public File getParent() {
        return this.file;
    }

    @Override
    public void set(String key, Object o) {
        this.getConfig().set(key, o);
    }

    @Override
    public Object get(String key) {
        return this.getConfig().get(key);
    }

    @Override
    public <T> T get(String key, Class<T> type) {
        Object o = this.get(key);
        if (o == null) {
            return null;
        }
        if (!o.getClass().isAssignableFrom(type)) {
            return null;
        }
        return (T)o;
    }

    @Override
    public Node getNode(String key) {
        return (Node)this.memory.entrySet().stream().filter(n -> ((String)n.getKey()).equals(key)).map(Map.Entry::getValue).findFirst().orElseGet(() -> {
            Node n = new Node(key, this);
            this.memory.put(n.getPath(), n);
            return n;
        });
    }

    @Override
    public Set<String> getKeys(boolean deep) {
        return this.getConfig().getKeys(deep);
    }

    @Override
    public Map<String, Object> getValues(boolean deep) {
        return this.getConfig().getValues(deep);
    }

    @Override
    public String getString(String key) {
        return this.getConfig().getString(key);
    }

    @Override
    public boolean getBoolean(String key) {
        return this.getConfig().getBoolean(key);
    }

    @Override
    public boolean isList(String key) {
        return this.getConfig().isList(key);
    }

    @Override
    public boolean isStringList(String key) {
        return !this.getConfig().getStringList(key).isEmpty();
    }

    @Override
    public boolean isFloatList(String key) {
        return !this.getConfig().getFloatList(key).isEmpty();
    }

    @Override
    public boolean isDoubleList(String key) {
        return !this.getConfig().getDoubleList(key).isEmpty();
    }

    @Override
    public boolean isLongList(String key) {
        return !this.getConfig().getLongList(key).isEmpty();
    }

    @Override
    public boolean isIntegerList(String key) {
        return !this.getConfig().getIntegerList(key).isEmpty();
    }

    @Override
    public boolean isBoolean(String key) {
        return this.getConfig().isBoolean(key);
    }

    @Override
    public boolean isDouble(String key) {
        return this.getConfig().isDouble(key);
    }

    @Override
    public boolean isInt(String key) {
        return this.getConfig().isInt(key);
    }

    @Override
    public boolean isLong(String key) {
        return this.getConfig().isLong(key);
    }

    @Override
    public boolean isFloat(String key) {
        return this.get(key) instanceof Float;
    }

    @Override
    public boolean isString(String key) {
        return this.getConfig().isString(key);
    }

    @Override
    public String getPath() {
        String s = "/" + this.getName() + "/";
        if (this.getDirectory() != null) {
            s = s + this.getDirectory();
        }
        return s;
    }

    @Override
    public boolean isNode(String key) {
        return this.getConfig().isConfigurationSection(key);
    }

    @Override
    public double getDouble(String key) {
        return this.getConfig().getDouble(key);
    }

    @Override
    public long getLong(String key) {
        return this.getConfig().getLong(key);
    }

    @Override
    public float getFloat(String key) {
        return this.isFloat(key) ? Float.parseFloat((String)this.getConfig().get(key)) : 0.0f;
    }

    @Override
    public int getInt(String key) {
        return this.getConfig().getInt(key);
    }

    @Override
    public Map<?, ?> getMap(String key) {
        return (Map)this.getConfig().get(key);
    }

    @Override
    public List<?> getList(String key) {
        return this.getConfig().getList(key);
    }

    @Override
    public List<String> getStringList(String key) {
        return this.getConfig().getStringList(key);
    }

    @Override
    public List<Integer> getIntegerList(String key) {
        return this.getConfig().getIntegerList(key);
    }

    @Override
    public List<Double> getDoubleList(String key) {
        return this.getConfig().getDoubleList(key);
    }

    @Override
    public List<Float> getFloatList(String key) {
        return this.getConfig().getFloatList(key);
    }

    @Override
    public List<Long> getLongList(String key) {
        return this.getConfig().getLongList(key);
    }

    @Override
    public Configurable.Extension getType() {
        return YamlExtension.INSTANCE;
    }

    public static class Node
    extends Configurable.Node {
        public Node(String key, Configurable configuration) {
            super(key, configuration);
        }

        @Override
        public <T> T get(Class<T> type) {
            if (type.isAssignableFrom(ConfigurationSection.class)) {
                YamlConfiguration conf = (YamlConfiguration)this.config;
                return (T)conf.getConfig().getConfigurationSection(this.key);
            }
            return (T)super.get((Class)type);
        }

        @Override
        public com.github.sanctum.panther.file.Node getNode(String node) {
            return (com.github.sanctum.panther.file.Node)Optional.ofNullable((MemorySpace)((YamlConfiguration)this.config).memory.get(this.key + "." + node)).orElseGet(() -> {
                Node n = new Node(this.key + "." + node, this.config);
                ((YamlConfiguration)this.config).memory.put(n.getPath(), n);
                return n;
            });
        }

        @Override
        public boolean create() {
            YamlConfiguration conf = (YamlConfiguration)this.config;
            if (!this.config.exists()) {
                try {
                    this.config.create();
                }
                catch (IOException ex) {
                    PantherLogger.getInstance().getLogger().severe("- An issue occurred while attempting to create the backing file for the '" + this.config.getName() + "' configuration.");
                    ex.printStackTrace();
                }
            }
            conf.getConfig().createSection(this.key);
            this.save();
            return false;
        }

        @Override
        public Set<String> getKeys(boolean deep) {
            return this.get(ConfigurationSection.class).getKeys(deep);
        }

        @Override
        public Map<String, Object> getValues(boolean deep) {
            return this.get(ConfigurationSection.class).getValues(deep);
        }
    }
}

