/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth.data;

import com.github.sanctum.labyrinth.data.EconomyProvision;
import java.math.BigDecimal;
import java.util.Optional;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.OfflinePlayer;

final class VaultEconomyProvision
extends EconomyProvision {
    private final Economy economy;

    VaultEconomyProvision(Economy provider) {
        this.economy = provider;
        vault = this;
    }

    @Override
    public String getImplementation() {
        return "(Internal) | Interface: Vault";
    }

    @Override
    public Optional<Double> balance(OfflinePlayer p) {
        return Optional.of(this.economy.getBalance(p));
    }

    @Override
    public Optional<Double> balance(OfflinePlayer p, String world) {
        return Optional.of(this.economy.getBalance(p, world));
    }

    @Override
    public Optional<Boolean> has(BigDecimal amount, OfflinePlayer p) {
        return Optional.of(this.economy.has(p, amount.doubleValue()));
    }

    @Override
    public Optional<Boolean> has(BigDecimal amount, OfflinePlayer p, String world) {
        return Optional.of(this.economy.has(p, world, amount.doubleValue()));
    }

    @Override
    public Optional<Boolean> deposit(BigDecimal amount, OfflinePlayer p) {
        return Optional.of(this.economy.depositPlayer(p, amount.doubleValue()).transactionSuccess());
    }

    @Override
    public Optional<Boolean> deposit(BigDecimal amount, OfflinePlayer p, String world) {
        return Optional.of(this.economy.depositPlayer(p, world, amount.doubleValue()).transactionSuccess());
    }

    @Override
    public Optional<Boolean> withdraw(BigDecimal amount, OfflinePlayer p) {
        return Optional.of(this.economy.withdrawPlayer(p, amount.doubleValue()).transactionSuccess());
    }

    @Override
    public Optional<Boolean> withdraw(BigDecimal amount, OfflinePlayer p, String world) {
        return Optional.of(this.economy.withdrawPlayer(p, world, amount.doubleValue()).transactionSuccess());
    }

    @Override
    public Optional<Double> accountBalance(OfflinePlayer p) {
        return Optional.of(this.economy.bankBalance((String)p.getUniqueId().toString()).amount);
    }

    @Override
    public Optional<Double> accountBalance(OfflinePlayer p, String world) {
        return this.accountBalance(p);
    }

    @Override
    public Optional<Boolean> accountHas(BigDecimal amount, OfflinePlayer p) {
        return super.accountHas(amount, p);
    }

    @Override
    public Optional<Boolean> accountHas(BigDecimal amount, OfflinePlayer p, String world) {
        return this.accountHas(amount, p);
    }

    @Override
    public Optional<Boolean> depositAccount(BigDecimal amount, OfflinePlayer p) {
        return Optional.of(this.economy.bankDeposit(p.getUniqueId().toString(), amount.doubleValue()).transactionSuccess());
    }

    @Override
    public Optional<Boolean> depositAccount(BigDecimal amount, OfflinePlayer p, String world) {
        return this.depositAccount(amount, p);
    }

    @Override
    public Optional<Boolean> withdrawAccount(BigDecimal amount, OfflinePlayer p) {
        return Optional.of(this.economy.bankWithdraw(p.getUniqueId().toString(), amount.doubleValue()).transactionSuccess());
    }

    @Override
    public Optional<Boolean> withdrawAccount(BigDecimal amount, OfflinePlayer p, String world) {
        return this.withdrawAccount(amount, p);
    }
}

