/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth.data;

import com.github.sanctum.labyrinth.api.Service;
import com.github.sanctum.labyrinth.data.ServiceType;
import com.github.sanctum.panther.annotation.Removal;
import com.github.sanctum.panther.container.PantherEntryMap;
import com.github.sanctum.panther.container.PantherMap;
import com.github.sanctum.panther.util.Check;

@Removal
public final class ServiceManager {
    final PantherMap<ServiceType<?>, Service> services = new PantherEntryMap();

    public void load(ServiceType<? extends Service> type) {
        this.services.put(type, type.getLoader().get());
    }

    public <T extends Service> T get(Class<T> service) {
        return (T)((Service)service.cast(this.services.values().stream().filter(v -> service.isAssignableFrom(v.getClass())).findFirst().orElse(null)));
    }

    public <T extends Service> T get(ServiceType<T> serviceType) {
        Service service = this.services.entries().stream().filter(t -> serviceType.equals(t.getKey())).findFirst().map(e -> (Service)serviceType.getType().cast(e.getValue())).orElse(null);
        return (T)Check.forNull(service, "No loaded instance of service type " + serviceType.getType().getSimpleName() + " was found.");
    }
}

