/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth.data;

import com.github.sanctum.labyrinth.LabyrinthProvider;
import com.github.sanctum.labyrinth.data.service.PlayerSearch;
import com.github.sanctum.panther.placeholder.Placeholder;
import com.github.sanctum.panther.util.ProgressBar;
import java.text.NumberFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerPlaceholders
implements Placeholder.Translation {
    private final Placeholder.Identifier identifier = () -> "player";
    private final Placeholder.Signature information = new Placeholder.Signature(){

        @Override
        @NotNull
        public String getName() {
            return "Labyrinth-Player";
        }

        @Override
        @NotNull
        public String[] getAuthors() {
            String[] stringArray = new String[]{"Hempfest"};
            if (stringArray == null) {
                1.$$$reportNull$$$0(0);
            }
            return stringArray;
        }

        @Override
        @NotNull
        public String getVersion() {
            return "1.0";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/github/sanctum/labyrinth/data/PlayerPlaceholders$1", "getAuthors"));
        }
    };

    @Override
    public Placeholder.Signature getInformation() {
        return this.information;
    }

    int getPing(Player p) {
        String v = Bukkit.getServer().getClass().getPackage().getName().replace(".", ",").split(",")[3];
        if (!p.getClass().getName().equals("org.bukkit.craftbukkit." + v + ".entity.CraftPlayer")) {
            p = Bukkit.getPlayer((UUID)p.getUniqueId());
        }
        try {
            if (LabyrinthProvider.getInstance().isNew() && !v.contains("16")) {
                return (Integer)p.getClass().getDeclaredMethod("getPing", new Class[0]).invoke((Object)p, new Object[0]);
            }
            Object entityPlayer = p.getClass().getMethod("getHandle", new Class[0]).invoke((Object)p, new Object[0]);
            return (Integer)entityPlayer.getClass().getField("ping").get(entityPlayer);
        }
        catch (Exception e) {
            LabyrinthProvider.getInstance().getLogger().severe("A severe issue occurred while pinging a players response time.");
            return 0;
        }
    }

    String getPingColor(int num) {
        if (num <= 100) {
            return "&a";
        }
        if (num <= 350) {
            return "&e";
        }
        if (num <= 600) {
            return "&c";
        }
        return "&4";
    }

    String getPingColorPronounced(int num) {
        String color = this.getPingColor(num);
        if (num >= 600) {
            return color + "LAG!";
        }
        return color + num;
    }

    @Override
    @Nullable
    public String onTranslation(String parameter, Placeholder.Variable variable) {
        if (variable.exists() && variable.get() instanceof OfflinePlayer) {
            OfflinePlayer p = (OfflinePlayer)variable.get();
            if (p.isOnline()) {
                switch (parameter.toLowerCase(Locale.ROOT)) {
                    case "ping": {
                        int ping = this.getPing(p.getPlayer());
                        return this.getPingColor(ping) + ping;
                    }
                    case "ping_pronounced": {
                        return this.getPingColorPronounced(this.getPing(p.getPlayer()));
                    }
                    case "name": {
                        return p.getName();
                    }
                    case "world_player_count": {
                        return Optional.ofNullable(p.getPlayer().getWorld()).map(World::getPlayers).map(List::size).map(Object::toString).orElse(null);
                    }
                    case "world_name": {
                        return Optional.ofNullable(p.getPlayer().getWorld()).map(World::getName).orElse(null);
                    }
                    case "display_name": {
                        return p.getPlayer().getDisplayName();
                    }
                    case "health_bar": {
                        return new ProgressBar().setProgress(((Number)p.getPlayer().getHealth()).intValue()).setGoal(20).toString();
                    }
                    case "time_played": {
                        return PlayerSearch.of(p.getName()).getPlaytime().toString();
                    }
                    case "hours_played": {
                        return PlayerSearch.of(p.getName()).getPlaytime().getHours() + "";
                    }
                    case "health": {
                        return NumberFormat.getNumberInstance().format(p.getPlayer().getHealth());
                    }
                    case "last_played": {
                        return new Date(p.getLastPlayed()).toLocaleString();
                    }
                }
            } else {
                switch (parameter.toLowerCase(Locale.ROOT)) {
                    case "name": 
                    case "display_name": {
                        return p.getName();
                    }
                    case "hours_played": {
                        return PlayerSearch.of(p.getName()).getPlaytime().getHours() + "";
                    }
                    case "last_played": {
                        return new Date(p.getLastPlayed()).toLocaleString();
                    }
                }
            }
        }
        return null;
    }

    @Override
    @Nullable
    public Placeholder.Identifier getIdentifier() {
        return this.identifier;
    }
}

