/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth.data;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.configuration.serialization.SerializableAs;
import org.jetbrains.annotations.NotNull;

@SerializableAs(value="org.bukkit.Location")
public final class LegacyConfigLocation
implements ConfigurationSerializable {
    private final Location location;

    public LegacyConfigLocation(@NotNull Location location) {
        if (location == null) {
            LegacyConfigLocation.$$$reportNull$$$0(0);
        }
        this.location = location;
    }

    @NotNull
    public Map<String, Object> serialize() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        World world = this.location.getWorld();
        if (world != null) {
            builder.put((Object)"world", (Object)world.getName());
        }
        builder.put((Object)"x", (Object)this.location.getX());
        builder.put((Object)"y", (Object)this.location.getY());
        builder.put((Object)"z", (Object)this.location.getZ());
        builder.put((Object)"pitch", (Object)Float.valueOf(this.location.getPitch()));
        builder.put((Object)"yaw", (Object)Float.valueOf(this.location.getYaw()));
        ImmutableMap immutableMap = builder.build();
        if (immutableMap == null) {
            LegacyConfigLocation.$$$reportNull$$$0(1);
        }
        return immutableMap;
    }

    public final Location getLocation() {
        return this.location.clone();
    }

    public static LegacyConfigLocation deserialize(Map<String, Object> map) throws IllegalArgumentException {
        World world = Optional.ofNullable(map.get("world")).filter(String.class::isInstance).map(String.class::cast).map(Bukkit::getWorld).orElse((World)Bukkit.getWorlds().get(0));
        double x = Optional.ofNullable(map.get("x")).map(LegacyConfigLocation::tryDouble).orElseThrow(() -> new IllegalArgumentException("X cannot be omitted!"));
        double y = Optional.ofNullable(map.get("y")).map(LegacyConfigLocation::tryDouble).orElseThrow(() -> new IllegalArgumentException("Y cannot be omitted!"));
        double z = Optional.ofNullable(map.get("z")).map(LegacyConfigLocation::tryDouble).orElseThrow(() -> new IllegalArgumentException("Z cannot be omitted!"));
        float pitch = Optional.ofNullable(map.get("pitch")).map(LegacyConfigLocation::tryFloat).orElse(Float.valueOf(0.0f)).floatValue();
        float yaw = Optional.ofNullable(map.get("yaw")).map(LegacyConfigLocation::tryFloat).orElse(Float.valueOf(0.0f)).floatValue();
        return new LegacyConfigLocation(new Location(world, x, y, z, yaw, pitch));
    }

    private static Double tryDouble(Object object) {
        try {
            return (double)((Double)object);
        }
        catch (ClassCastException ignored) {
            return null;
        }
    }

    private static Float tryFloat(Object object) {
        try {
            return Float.valueOf(((Float)object).floatValue());
        }
        catch (ClassCastException ignored) {
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/github/sanctum/labyrinth/data/LegacyConfigLocation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/github/sanctum/labyrinth/data/LegacyConfigLocation";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "serialize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

