/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth.data;

import com.github.sanctum.labyrinth.LabyrinthProvider;
import com.github.sanctum.labyrinth.formatting.ActionbarInstance;
import com.github.sanctum.labyrinth.formatting.ScoreboardInstance;
import com.github.sanctum.labyrinth.formatting.TablistInstance;
import com.github.sanctum.labyrinth.interfacing.Nameable;
import com.github.sanctum.labyrinth.library.Cooldown;
import com.github.sanctum.panther.util.ParsedTimeFormat;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface LabyrinthUser
extends Nameable {
    @Override
    @NotNull
    public String getName();

    public String[] getPreviousNames();

    @NotNull
    public UUID getId();

    @NotNull
    public OfflinePlayer getPlayer();

    @Nullable(value="User must be online!")
    default public @Nullable(value="User must be online!") TablistInstance getTablist() {
        return this.isOnline() ? TablistInstance.get(this.getPlayer().getPlayer()) : null;
    }

    @Nullable(value="User must be online!")
    default public @Nullable(value="User must be online!") ScoreboardInstance getScoreboard() {
        return this.isOnline() ? ScoreboardInstance.get(this.getPlayer().getPlayer()) : null;
    }

    @Nullable(value="User must be online!")
    default public @Nullable(value="User must be online!") ActionbarInstance getActionbar() {
        return this.isOnline() ? ActionbarInstance.of(this.getPlayer().getPlayer()) : null;
    }

    @Nullable
    default public Cooldown getCooldown(@NotNull String key) {
        if (key == null) {
            LabyrinthUser.$$$reportNull$$$0(0);
        }
        return LabyrinthProvider.getInstance().getCooldown(this.getId().toString() + "-" + key);
    }

    @NotNull
    default public Cooldown getOrCreate(@NotNull String key, @NotNull ParsedTimeFormat format) {
        if (key == null) {
            LabyrinthUser.$$$reportNull$$$0(1);
        }
        if (format == null) {
            LabyrinthUser.$$$reportNull$$$0(2);
        }
        Cooldown cooldown = Optional.ofNullable(this.getCooldown(key)).orElseGet(() -> {
            Cooldown c = this.newCooldown(key, format);
            c.save();
            return c;
        });
        if (cooldown == null) {
            LabyrinthUser.$$$reportNull$$$0(3);
        }
        return cooldown;
    }

    @NotNull
    default public Cooldown newCooldown(final @NotNull String key, final @NotNull ParsedTimeFormat format) {
        if (key == null) {
            LabyrinthUser.$$$reportNull$$$0(4);
        }
        if (format == null) {
            LabyrinthUser.$$$reportNull$$$0(5);
        }
        return new Cooldown(){
            long cooldown;
            {
                this.abv(format.toSeconds());
            }

            @Override
            public String getId() {
                return key;
            }

            @Override
            public long getCooldown() {
                return this.cooldown;
            }
        };
    }

    default public boolean isOnline() {
        return this.getPlayer().getPlayer() != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/github/sanctum/labyrinth/data/LabyrinthUser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/github/sanctum/labyrinth/data/LabyrinthUser";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCooldown";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreate";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "newCooldown";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

