/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth.data;

import com.github.sanctum.labyrinth.library.Item;
import com.github.sanctum.labyrinth.library.Items;
import com.github.sanctum.panther.annotation.Experimental;
import com.github.sanctum.panther.file.JsonAdapter;
import com.github.sanctum.panther.file.Node;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

@Node.Pointer(value="org.bukkit.inventory.ItemStack")
public final class ItemStackSerializable
implements JsonAdapter<ItemStack> {
    private final Gson gson = new GsonBuilder().create();

    @Override
    @Experimental(dueTo="Needing a way to make pdc data persistent too, otherwise item serialization/deserialization works flawlessly")
    public JsonElement write(ItemStack l) {
        JsonObject o = new JsonObject();
        o.addProperty("type", l.getType().name());
        o.addProperty("amount", (Number)l.getAmount());
        ItemMeta meta = l.getItemMeta();
        JsonObject metaObj = new JsonObject();
        if (!Bukkit.getItemFactory().equals(meta, null)) {
            JsonObject enchants = new JsonObject();
            for (Map.Entry entry : meta.getEnchants().entrySet()) {
                enchants.addProperty(((Enchantment)entry.getKey()).getKey().toString(), (Number)entry.getValue());
            }
            JsonArray flags = new JsonArray();
            for (ItemFlag flag : meta.getItemFlags()) {
                flags.add(flag.name());
            }
            if (meta.hasDisplayName()) {
                metaObj.addProperty("displayname", meta.getDisplayName());
            }
            if (meta.hasLore()) {
                metaObj.add("lore", this.gson.toJsonTree((Object)meta.getLore()));
            }
            if (meta.getItemFlags().size() > 0) {
                metaObj.add("flags", (JsonElement)flags);
            }
            metaObj.add("enchantments", (JsonElement)enchants);
            metaObj.addProperty("data", (Number)l.getData().getData());
            o.add("meta", (JsonElement)metaObj);
        }
        return o;
    }

    @Override
    public ItemStack read(Map<String, Object> o) {
        int amount = Integer.parseInt(String.valueOf(o.get("amount")));
        Material type = Material.valueOf((String)((String)o.get("type")));
        ItemStack stack = new ItemStack(type);
        Item.Edit edit = Items.edit();
        Map ob = (Map)o.get("meta");
        if (ob != null) {
            Object name;
            byte data = Byte.parseByte(ob.get("data").toString());
            Map enchants = (Map)ob.get("enchantments");
            enchants.forEach((label, l) -> {
                int integer = Integer.parseInt(l.toString());
                String key = label.split(":")[0];
                String space = label.split(":")[1];
                edit.addEnchantment(Enchantment.getByKey((NamespacedKey)new NamespacedKey(key, space)), integer);
            });
            if (ob.get("displayname") != null) {
                name = (String)ob.get("displayname");
                edit.setTitle((String)name);
            }
            if (ob.get("lore") != null) {
                name = (List)ob.get("lore");
                edit.setLore((Collection<String>)name);
            }
            if (ob.get("flags") != null) {
                List flags = (List)ob.get("flags");
                for (String f : flags) {
                    edit.setFlags(ItemFlag.valueOf((String)f));
                }
            }
            stack.getData().setData(data);
        }
        edit.setItem(stack);
        edit.setAmount(amount);
        return edit.build();
    }

    @Override
    public Class<ItemStack> getSerializationSignature() {
        return ItemStack.class;
    }
}

