/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth.data;

import com.github.sanctum.labyrinth.formatting.Message;
import com.github.sanctum.labyrinth.formatting.TextChunk;
import com.github.sanctum.labyrinth.formatting.ToolTip;
import com.github.sanctum.panther.file.JsonAdapter;
import com.github.sanctum.panther.file.Node;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Map;

@Node.Pointer(value="com.github.sanctum.Message.Chunk")
public final class ChunkSerializable
implements JsonAdapter<Message.Chunk> {
    @Override
    public JsonElement write(Message.Chunk toolTips) {
        JsonObject o = new JsonObject();
        o.addProperty("text", toolTips.toComponent().toLegacyText());
        JsonArray array = new JsonArray();
        for (ToolTip t : toolTips) {
            ToolTip tip;
            if (t instanceof ToolTip.Text) {
                tip = t;
                array.add("text:" + (String)tip.get());
            }
            if (t instanceof ToolTip.Command) {
                tip = t;
                array.add("command:" + (String)tip.get());
            }
            if (t instanceof ToolTip.Suggestion) {
                tip = t;
                array.add("suggestion:" + (String)tip.get());
            }
            if (t instanceof ToolTip.Copy) {
                tip = t;
                array.add("copy:" + (String)tip.get());
            }
            if (!(t instanceof ToolTip.Url)) continue;
            tip = t;
            array.add("open:" + (String)tip.get());
        }
        if (array.size() > 0) {
            o.add("extras", (JsonElement)array);
        }
        return o;
    }

    @Override
    public Message.Chunk read(Map<String, Object> object) {
        String text = (String)object.get("text");
        List hover = (List)object.get("extras");
        TextChunk chunk = new TextChunk(text);
        if (hover != null) {
            String tt = "text:";
            String ct = "command:";
            String st = "suggestion:";
            String cct = "copy:";
            String ut = "open:";
            for (String h : hover) {
                if (h.startsWith(tt)) {
                    chunk.bind((ToolTip)new ToolTip.Text(h.replace(tt, "")));
                }
                if (h.startsWith(ct)) {
                    chunk.bind((ToolTip)new ToolTip.Command(h.replace(ct, "")));
                }
                if (h.startsWith(st)) {
                    chunk.bind((ToolTip)new ToolTip.Suggestion(h.replace(st, "")));
                }
                if (h.startsWith(cct)) {
                    chunk.bind((ToolTip)new ToolTip.Copy(h.replace(cct, "")));
                }
                if (!h.startsWith(ut)) continue;
                chunk.bind((ToolTip)new ToolTip.Url(h.replace(ut, "")));
            }
        }
        return chunk;
    }

    @Override
    public Class<Message.Chunk> getSerializationSignature() {
        return Message.Chunk.class;
    }
}

