/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth.data;

import com.github.sanctum.labyrinth.data.Atlas;
import com.github.sanctum.labyrinth.data.AtlasNode;
import com.github.sanctum.panther.file.MemorySpace;
import com.github.sanctum.panther.file.Node;
import com.github.sanctum.panther.util.MapDecompression;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AtlasMap
implements Atlas {
    protected final Map<String, Object> SOURCE = new HashMap<String, Object>();
    protected final Map<String, MemorySpace> QUERY = new HashMap<String, MemorySpace>();
    protected final char divider;

    public AtlasMap(char divider) {
        this.divider = divider;
    }

    public AtlasMap() {
        this.divider = (char)46;
    }

    String dividerAdapt() {
        return this.divider == '.' ? "[" + this.divider + "]" : this.divider + "";
    }

    @Override
    public boolean isNode(String key) {
        String[] a = key.split(this.dividerAdapt());
        String k = a[Math.max(0, a.length - 1)];
        Map o = this.SOURCE;
        for (int i = 0; i < a.length - 1; ++i) {
            String pathKey = a[i];
            Object obj = o.get(pathKey);
            if (!(obj instanceof Map)) continue;
            Map js = (Map)obj;
            if (js.containsKey(k)) {
                return js.get(k) instanceof Map;
            }
            o = js;
        }
        return o.get(k) instanceof Map;
    }

    @Override
    public Node getNode(String key) {
        return (Node)this.QUERY.entrySet().stream().filter(e -> ((String)e.getKey()).equals(key)).map(Map.Entry::getValue).findFirst().orElseGet(() -> {
            AtlasNode n = new AtlasNode(key, this);
            this.QUERY.put(key, n);
            return n;
        });
    }

    @Override
    public Set<String> getKeys(boolean deep) {
        HashSet<String> keys = new HashSet<String>();
        this.SOURCE.forEach((? super K key, ? super V value) -> {
            if (deep) {
                if (value instanceof Map) {
                    keys.addAll(MapDecompression.getInstance().decompress(((Map)value).entrySet(), this.divider, null).toSet());
                } else {
                    keys.add((String)key);
                }
            } else {
                keys.add((String)key);
            }
        });
        return keys;
    }

    @Override
    public Map<String, Object> getValues(boolean deep) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        this.SOURCE.forEach((? super K key, ? super V value) -> {
            if (deep) {
                if (value instanceof Map) {
                    map.putAll(MapDecompression.getInstance().decompress(((Map)value).entrySet(), this.divider, null).toMap());
                } else {
                    map.put((String)key, value);
                }
            } else {
                map.put((String)key, value);
            }
        });
        return map;
    }

    @Override
    public int size() {
        return this.getValues(true).size();
    }

    @Override
    public boolean isEmpty() {
        return this.SOURCE.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        return false;
    }

    @Override
    public Object get(Object key) {
        String ke = (String)key;
        String[] a = ke.split(this.dividerAdapt());
        String k = a[Math.max(0, a.length - 1)];
        Map o = this.SOURCE;
        for (int i = 0; i < a.length - 1; ++i) {
            Map js;
            String pathKey = a[i];
            Object obj = o.get(pathKey);
            if (obj instanceof Map) {
                js = (Map)obj;
                if (js.containsKey(k)) {
                    return js.get(k);
                }
            } else {
                return obj;
            }
            o = js;
        }
        return o.get(k);
    }

    @Override
    @Nullable
    public Object put(String key, Object o) {
        String[] a = key.split(this.dividerAdapt());
        String k = a[Math.max(0, a.length - 1)];
        Map ob = this.SOURCE;
        for (int i = 0; i < a.length - 1; ++i) {
            String pathKey = a[i];
            Object os = ob.get(pathKey);
            if (os instanceof Map) {
                ob = (Map)os;
                continue;
            }
            HashMap n = new HashMap();
            ob.put(pathKey, n);
            ob = (Map)ob.get(pathKey);
        }
        if (o == null) {
            ob.remove(k);
            this.QUERY.remove(k);
            return null;
        }
        ob.put((String)k, (Object)o);
        return o;
    }

    @Override
    public Object remove(Object key) {
        return this.put((String)key, (Object)null);
    }

    @Override
    public void putAll(@NotNull Map<? extends String, ?> m) {
        if (m == null) {
            AtlasMap.$$$reportNull$$$0(0);
        }
        this.SOURCE.putAll(m);
    }

    @Override
    public void clear() {
        this.SOURCE.clear();
    }

    @Override
    @NotNull
    public Set<String> keySet() {
        Set<String> set = this.getKeys(true);
        if (set == null) {
            AtlasMap.$$$reportNull$$$0(1);
        }
        return set;
    }

    @Override
    @NotNull
    public Collection<Object> values() {
        Collection<Object> collection = this.getValues(true).values();
        if (collection == null) {
            AtlasMap.$$$reportNull$$$0(2);
        }
        return collection;
    }

    @Override
    @NotNull
    public Set<Map.Entry<String, Object>> entrySet() {
        Set<Map.Entry<String, Object>> set = this.getValues(true).entrySet();
        if (set == null) {
            AtlasMap.$$$reportNull$$$0(3);
        }
        return set;
    }

    @Override
    public Object getOrDefault(Object key, Object defaultValue) {
        Object o = this.get(key);
        if (o == null) {
            return defaultValue;
        }
        return o;
    }

    @Override
    public void forEach(BiConsumer<? super String, ? super Object> action) {
        this.getValues(true).forEach(action);
    }

    @Override
    public void replaceAll(BiFunction<? super String, ? super Object, ?> function) {
        this.getValues(true).replaceAll(function);
    }

    @Override
    @Nullable
    public Object putIfAbsent(String key, Object value) {
        Object o = this.get(key);
        if (o == null) {
            return this.put(key, value);
        }
        return o;
    }

    @Override
    public boolean remove(Object key, Object value) {
        Object o = this.get(key);
        if (o == null) {
            return false;
        }
        if (Objects.equals(o, value)) {
            this.put((String)key, (Object)null);
            return true;
        }
        return false;
    }

    @Override
    public boolean replace(String key, Object oldValue, Object newValue) {
        Object o = this.get(key);
        if (o == null) {
            return false;
        }
        if (Objects.equals(o, oldValue)) {
            this.put(key, newValue);
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public Object replace(String key, Object value) {
        Object o = this.get(key);
        if (o == null) {
            return null;
        }
        this.put(key, value);
        return value;
    }

    @Override
    public Object computeIfAbsent(String key, @NotNull Function<? super String, ?> mappingFunction) {
        Object t;
        if (mappingFunction == null) {
            AtlasMap.$$$reportNull$$$0(4);
        }
        if ((t = this.get(key)) == null) {
            return this.put(key, mappingFunction.apply(key));
        }
        return t;
    }

    @Override
    public Object computeIfPresent(String key, @NotNull BiFunction<? super String, ? super Object, ?> remappingFunction) {
        Object t;
        if (remappingFunction == null) {
            AtlasMap.$$$reportNull$$$0(5);
        }
        if ((t = this.get(key)) != null) {
            return this.put(key, remappingFunction.apply(key, t));
        }
        return null;
    }

    @Override
    public Object compute(String key, @NotNull BiFunction<? super String, ? super Object, ?> remappingFunction) {
        if (remappingFunction == null) {
            AtlasMap.$$$reportNull$$$0(6);
        }
        Object t = this.get(key);
        return this.put(key, remappingFunction.apply(key, t));
    }

    @Override
    public Object merge(String key, @NotNull Object value, @NotNull BiFunction<? super Object, ? super Object, ?> remappingFunction) {
        if (value == null) {
            AtlasMap.$$$reportNull$$$0(7);
        }
        if (remappingFunction == null) {
            AtlasMap.$$$reportNull$$$0(8);
        }
        return this.SOURCE.merge(key, value, remappingFunction);
    }

    @Override
    public char getDivider() {
        return this.divider;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "m";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/github/sanctum/labyrinth/data/AtlasMap";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mappingFunction";
                break;
            }
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remappingFunction";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/github/sanctum/labyrinth/data/AtlasMap";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "keySet";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "values";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "entrySet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "putAll";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "computeIfAbsent";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "computeIfPresent";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "compute";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "merge";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

