/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth.data;

import com.github.sanctum.panther.annotation.Removal;
import com.github.sanctum.panther.container.PantherEntryMap;
import com.github.sanctum.panther.container.PantherMap;
import com.github.sanctum.panther.util.WrongLoaderUsedException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.bukkit.plugin.Plugin;

public class AddonLoader {
    private static final Field PLUGIN_CLASS_MAP;
    private final PantherMap<String, List<String>> classMap = new PantherEntryMap<String, List<String>>();
    private final Plugin javaPlugin;
    private AddonClassLoader loader;

    private AddonLoader(Plugin javaPlugin) {
        this.javaPlugin = javaPlugin;
    }

    @Deprecated
    @Removal(inVersion="1.7.9")
    public static @Removal(inVersion="1.7.9") AddonLoader forPlugin(Plugin yourPlugin) {
        return new AddonLoader(yourPlugin);
    }

    public static AddonLoader newInstance(Plugin yourPlugin) {
        return new AddonLoader(yourPlugin);
    }

    public List<Class<?>> loadFile(File addonJar) throws IllegalArgumentException, IllegalStateException {
        JarFile jarFile;
        if (addonJar.isDirectory()) {
            throw new IllegalArgumentException("File must not be a directory");
        }
        if (!addonJar.getName().endsWith(".jar")) {
            throw new IllegalArgumentException("File must be a .jar");
        }
        try {
            jarFile = new JarFile(addonJar);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        List<Class<?>> classList = this.injectJars(addonJar.getPath(), (Map<URL, JarFile>)ImmutableMap.of((Object)this.getValidJarURL(addonJar).orElseThrow(IllegalStateException::new), (Object)jarFile));
        this.javaPlugin.getLogger().info(() -> "Loaded addon file " + addonJar.getName() + " successfully.");
        return classList;
    }

    public List<Class<?>> loadFolder(File folder) throws IllegalArgumentException {
        if (!folder.isDirectory()) {
            throw new IllegalArgumentException("File is not a folder!");
        }
        this.javaPlugin.getLogger().info(() -> "Processing folder '" + folder.getName() + "'");
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (File file : folder.listFiles()) {
            this.getValidJarURL(file).ifPresent(url -> {
                JarFile jarFile;
                try {
                    jarFile = new JarFile(file);
                }
                catch (IOException e) {
                    this.javaPlugin.getLogger().warning(e::getMessage);
                    return;
                }
                builder.put(url, (Object)jarFile);
            });
        }
        List<Class<?>> classes = this.injectJars(folder.getPath(), (Map<URL, JarFile>)builder.build());
        this.javaPlugin.getLogger().info(() -> "Loaded addon files from " + folder.getPath() + " successfully.");
        return classes;
    }

    public boolean unload(String name) throws ClassNotFoundException {
        if (this.loader != null) {
            Map<String, Class<?>> classes = this.getClassMap(this.javaPlugin);
            if (this.classMap.containsKey(name)) {
                for (String st : this.classMap.get(name)) {
                    classes.remove(st);
                }
                this.classMap.remove(name);
                return true;
            }
            List<String> list = this.locateList(name);
            if (classes.containsKey(name)) {
                classes.remove(name);
                if (list != null) {
                    list.remove(name);
                }
                return true;
            }
            throw new ClassNotFoundException("Class " + name + " not found, cannot unload.");
        }
        return false;
    }

    public boolean unload(Class<?> clazz) throws WrongLoaderUsedException {
        if (this.loader != null) {
            Map<String, Class<?>> classes = this.getClassMap(this.javaPlugin);
            String name = clazz.getName().replace("/", ".").substring(0, clazz.getName().length() - 6);
            List<String> list = this.locateList(name);
            if (list != null) {
                list.remove(name);
            }
            classes.remove(name);
            return this.loader.removeClass(clazz);
        }
        return false;
    }

    private List<String> locateList(String name) {
        for (List list : this.classMap.values()) {
            for (String s : list) {
                if (!s.equalsIgnoreCase(name)) continue;
                return list;
            }
        }
        return null;
    }

    private Optional<URL> getValidJarURL(File file) {
        if (file.getName().endsWith(".jar")) {
            try {
                URL url = file.toURI().toURL();
                return Optional.of(url);
            }
            catch (MalformedURLException e) {
                this.javaPlugin.getLogger().warning(e::getMessage);
                this.javaPlugin.getLogger().warning("This is very unusual, contact Labyrinth developers.");
            }
        }
        return Optional.empty();
    }

    private List<Class<?>> injectJars(String path, Map<URL, JarFile> jars) {
        AddonClassLoader addonClassLoader;
        if (jars.isEmpty()) {
            return ImmutableList.of();
        }
        this.loader = addonClassLoader = new AddonClassLoader(jars.keySet().toArray(new URL[0]));
        jars.values().forEach(jarFile -> jarFile.stream().map(ZipEntry::getName).filter(entryName -> entryName.contains(".class") && !entryName.contains("$")).map(classPath -> classPath.replace('/', '.')).map(className -> className.substring(0, className.length() - 6)).forEach(s -> addonClassLoader.injectClass(path, (String)s)));
        return addonClassLoader.loadedClasses;
    }

    Map<String, Class<?>> getClassMap(Plugin javaPlugin) throws IllegalStateException {
        try {
            return (Map)PLUGIN_CLASS_MAP.get(javaPlugin.getClass().getClassLoader());
        }
        catch (ClassCastException | IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    static {
        try {
            PLUGIN_CLASS_MAP = Class.forName("org.bukkit.plugin.java.PluginClassLoader").getDeclaredField("classes");
            PLUGIN_CLASS_MAP.setAccessible(true);
        }
        catch (ClassNotFoundException | NoSuchFieldException e) {
            throw new IllegalStateException("Unable to reach plugin class map", e);
        }
    }

    final class AddonClassLoader
    extends URLClassLoader {
        private final List<Class<?>> loadedClasses;

        private AddonClassLoader(URL[] urls) {
            super(urls, AddonLoader.this.javaPlugin.getClass().getClassLoader());
            this.loadedClasses = new ArrayList();
        }

        Class<?> resolveClass(String name) throws ClassNotFoundException {
            return this.loadClass(name, true);
        }

        boolean removeClass(Class<?> clazz) throws IllegalArgumentException {
            if (this.loadedClasses.contains(clazz)) {
                this.loadedClasses.remove(clazz);
                return true;
            }
            throw new IllegalArgumentException("Class " + clazz.getName() + " does not belong to this addon loader!");
        }

        void injectClass(String path, String className) {
            Class<?> resolvedClass;
            try {
                resolvedClass = this.resolveClass(className);
            }
            catch (ClassNotFoundException e) {
                AddonLoader.this.javaPlugin.getLogger().warning(() -> "Unable to inject '" + className + "'");
                AddonLoader.this.javaPlugin.getLogger().warning(e::getMessage);
                return;
            }
            AddonLoader.this.getClassMap(AddonLoader.this.javaPlugin).put(className, resolvedClass);
            ArrayList<String> classes = (ArrayList<String>)AddonLoader.this.classMap.get(path);
            if (classes != null) {
                classes.add(className);
            } else {
                classes = new ArrayList<String>();
                classes.add(className);
                AddonLoader.this.classMap.put(path, classes);
            }
            AddonLoader.this.javaPlugin.getLogger().finest(() -> "Loaded '" + className + "' successfully.");
            this.loadedClasses.add(resolvedClass);
        }
    }
}

