/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth.command;

import com.github.sanctum.labyrinth.Labyrinth;
import com.github.sanctum.labyrinth.command.LabyrinthCommandToken;
import com.github.sanctum.labyrinth.formatting.completion.SimpleTabCompletion;
import com.github.sanctum.labyrinth.formatting.string.MessageBreakdown;
import com.github.sanctum.labyrinth.library.Mailer;
import com.github.sanctum.panther.placeholder.Placeholder;
import com.github.sanctum.panther.placeholder.PlaceholderRegistration;
import com.github.sanctum.panther.util.TypeAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public final class LabyrinthCommand
extends Command {
    Labyrinth labyrinth;
    private final SimpleTabCompletion completion;
    private final TypeAdapter<Player> conversion;

    public LabyrinthCommand(@NotNull LabyrinthCommandToken token) throws IllegalAccessException {
        if (token == null) {
            LabyrinthCommand.$$$reportNull$$$0(0);
        }
        super("labyrinth");
        this.completion = SimpleTabCompletion.empty();
        this.conversion = () -> Player.class;
        if (!token.isValid()) {
            throw new IllegalAccessException("Invalid command token! Not permitted!");
        }
        this.labyrinth = token.get();
    }

    public boolean execute(@NotNull CommandSender sender, @NotNull String commandLabel, @NotNull String[] args) {
        if (sender == null) {
            LabyrinthCommand.$$$reportNull$$$0(1);
        }
        if (commandLabel == null) {
            LabyrinthCommand.$$$reportNull$$$0(2);
        }
        if (args == null) {
            LabyrinthCommand.$$$reportNull$$$0(3);
        }
        Mailer mailer = Mailer.empty(sender).prefix().start("&2Labyrinth").middle(":").finish();
        if (!sender.isOp() && !sender.hasPermission("labyrinth")) {
            mailer.chat("&cYou don't have access to labyrinth functions.").deploy();
            return true;
        }
        if (args.length == 0) {
            mailer.chat("&6Currently running version &r" + this.labyrinth.getDescription().getVersion()).queue();
            return true;
        }
        if (args.length == 1) {
            String label = args[0];
            if (label.equalsIgnoreCase("version")) {
                mailer.chat("&6Currently running version &r" + this.labyrinth.getDescription().getVersion()).queue();
                return true;
            }
            if (label.equalsIgnoreCase("placeholder")) {
                mailer.chat("&cInvalid usage: &6/" + commandLabel + " " + label + " <placeholder> | &8[playerName]").queue();
                return true;
            }
            return true;
        }
        if (args.length == 2) {
            String label = args[0];
            String argument = args[1];
            if (label.equalsIgnoreCase("paint")) {
                String[] s;
                MessageBreakdown breakdown = new MessageBreakdown(argument, 24, 24, '\u2588');
                for (String st : s = breakdown.read()) {
                    mailer.chat(st).deploy();
                }
                return true;
            }
            if (label.equalsIgnoreCase("placeholder")) {
                if (sender instanceof Player) {
                    sender.sendMessage(PlaceholderRegistration.getInstance().replaceAll(argument, this.conversion.cast(sender)));
                } else {
                    sender.sendMessage(PlaceholderRegistration.getInstance().replaceAll(argument, sender));
                }
                return true;
            }
            return true;
        }
        if (args.length == 3) {
            String label = args[0];
            String argument = args[1];
            if (label.equalsIgnoreCase("placeholder")) {
                if (sender instanceof Player) {
                    sender.sendMessage(PlaceholderRegistration.getInstance().replaceAll(argument, this.conversion.cast(sender)));
                } else {
                    sender.sendMessage(PlaceholderRegistration.getInstance().replaceAll(argument, sender));
                }
                return true;
            }
            return true;
        }
        return false;
    }

    @NotNull
    public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String alias, @NotNull String[] args) throws IllegalArgumentException {
        if (sender == null) {
            LabyrinthCommand.$$$reportNull$$$0(4);
        }
        if (alias == null) {
            LabyrinthCommand.$$$reportNull$$$0(5);
        }
        if (args == null) {
            LabyrinthCommand.$$$reportNull$$$0(6);
        }
        this.completion.fillArgs(args);
        this.completion.then(0, "placeholder", "version", "paint");
        ArrayList<String> placeholders = new ArrayList<String>();
        PlaceholderRegistration.getInstance().getHistory().entries().stream().sorted(Comparator.comparing(e -> ((Placeholder.Identifier)e.getKey()).get())).forEach(e -> {
            for (Placeholder placeholder : (List)e.getValue()) {
                String result = placeholder.toRaw();
                placeholders.add(placeholder.start() + ((Placeholder.Identifier)e.getKey()).get() + result.substring(1));
            }
        });
        this.completion.then(1, "placeholder", 0, placeholders);
        this.completion.then(2, "placeholder", 0, (Collection<String>)Arrays.stream(Bukkit.getOfflinePlayers()).map(OfflinePlayer::getName).collect(Collectors.toList()));
        List<String> list = this.completion.get();
        if (list == null) {
            LabyrinthCommand.$$$reportNull$$$0(7);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "token";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sender";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLabel";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alias";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/github/sanctum/labyrinth/command/LabyrinthCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/github/sanctum/labyrinth/command/LabyrinthCommand";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "tabComplete";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "tabComplete";
                break;
            }
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

