/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth;

import com.github.sanctum.labyrinth.LabyrinthProvider;
import com.github.sanctum.labyrinth.api.LabyrinthAPI;
import com.github.sanctum.labyrinth.api.PlaceholderFormatService;
import com.github.sanctum.labyrinth.api.Service;
import com.github.sanctum.labyrinth.command.LabyrinthCommand;
import com.github.sanctum.labyrinth.command.LabyrinthCommandToken;
import com.github.sanctum.labyrinth.data.AdvancedEconomyImplementation;
import com.github.sanctum.labyrinth.data.ChunkSerializable;
import com.github.sanctum.labyrinth.data.DataTable;
import com.github.sanctum.labyrinth.data.FileList;
import com.github.sanctum.labyrinth.data.FileManager;
import com.github.sanctum.labyrinth.data.ItemStackSerializable;
import com.github.sanctum.labyrinth.data.LegacyConfigLocation;
import com.github.sanctum.labyrinth.data.LocationSerializable;
import com.github.sanctum.labyrinth.data.MessageSerializable;
import com.github.sanctum.labyrinth.data.MetaTemplateSerializable;
import com.github.sanctum.labyrinth.data.PlayerPlaceholders;
import com.github.sanctum.labyrinth.data.RegionServicesManagerImpl;
import com.github.sanctum.labyrinth.data.ServiceManager;
import com.github.sanctum.labyrinth.data.ServiceType;
import com.github.sanctum.labyrinth.data.TemplateSerializable;
import com.github.sanctum.labyrinth.data.container.KeyedServiceManager;
import com.github.sanctum.labyrinth.data.container.PersistentContainer;
import com.github.sanctum.labyrinth.data.reload.PrintManager;
import com.github.sanctum.labyrinth.data.service.ExternalDataService;
import com.github.sanctum.labyrinth.data.service.LabyrinthOption;
import com.github.sanctum.labyrinth.data.service.PlayerSearch;
import com.github.sanctum.labyrinth.data.service.VentMapImpl;
import com.github.sanctum.labyrinth.event.DefaultEvent;
import com.github.sanctum.labyrinth.formatting.Message;
import com.github.sanctum.labyrinth.formatting.component.ActionComponent;
import com.github.sanctum.labyrinth.formatting.string.CustomColor;
import com.github.sanctum.labyrinth.interfacing.Token;
import com.github.sanctum.labyrinth.library.CommandUtils;
import com.github.sanctum.labyrinth.library.Cooldown;
import com.github.sanctum.labyrinth.library.Item;
import com.github.sanctum.labyrinth.library.ItemCompost;
import com.github.sanctum.labyrinth.library.Mailer;
import com.github.sanctum.labyrinth.library.NamespacedKey;
import com.github.sanctum.labyrinth.library.TimeWatch;
import com.github.sanctum.labyrinth.permissions.Permissions;
import com.github.sanctum.labyrinth.permissions.impl.DefaultImplementation;
import com.github.sanctum.labyrinth.permissions.impl.VaultImplementation;
import com.github.sanctum.labyrinth.task.SynchronousTaskChain;
import com.github.sanctum.labyrinth.task.TaskScheduler;
import com.github.sanctum.panther.event.Subscribe;
import com.github.sanctum.panther.event.Vent;
import com.github.sanctum.panther.event.VentMap;
import com.github.sanctum.panther.file.Configurable;
import com.github.sanctum.panther.file.Node;
import com.github.sanctum.panther.placeholder.PlaceholderRegistration;
import com.github.sanctum.panther.recursive.ServiceFactory;
import com.github.sanctum.panther.util.Applicable;
import com.github.sanctum.panther.util.Deployable;
import com.github.sanctum.panther.util.PantherLogger;
import com.github.sanctum.panther.util.TaskChain;
import com.github.sanctum.templates.MetaTemplate;
import com.github.sanctum.templates.Template;
import com.google.common.collect.ImmutableList;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.Collectors;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.serialization.ConfigurationSerialization;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.ServicePriority;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Vent.Link.Key(value="Core")
public final class Labyrinth
extends JavaPlugin
implements Vent.Host,
Listener,
LabyrinthAPI,
Message.Factory {
    private final ServiceManager serviceManager = new ServiceManager();
    private final KeyedServiceManager<Plugin> servicesManager = new KeyedServiceManager();
    private final LinkedList<Cooldown> cooldowns = new LinkedList();
    private final Map<String, ActionComponent> components = new HashMap<String, ActionComponent>();
    private final ConcurrentLinkedQueue<Integer> tasks = new ConcurrentLinkedQueue();
    private final Set<PersistentContainer> containers = new HashSet<PersistentContainer>();
    private final ItemCompost composter = new ItemCompost();
    private final PrintManager manager = new PrintManager();
    private final SynchronousTaskChain syncChain = new SynchronousTaskChain((Plugin)this);
    private Token<Labyrinth> validCommandToken;
    private boolean cachedIsLegacy;
    private boolean cachedIsNew;
    private boolean cachedNeedsLegacyLocation;
    private int cachedComponentRemoval;
    private long time;

    public void onLoad() {
        TaskChain.setChain(0, this.syncChain);
        this.validCommandToken = new LabyrinthCommandToken(this);
        PantherLogger.getInstance().setLogger(this.getLogger());
        if (VentMap.getInstance() instanceof VentMap.Default) {
            ServiceFactory.getInstance().getLoader(VentMap.class).supply(new VentMapImpl());
        }
    }

    public void onEnable() {
        this.time = System.currentTimeMillis();
        LabyrinthProvider.instance = this;
        this.getLogger().info("- Copyright Team Sanctum 2020, Open-source spigot development tool.");
        this.getLogger().info("- Loading user cache, please be patient...");
        FileManager manager = FileList.search((Plugin)this).get("Components", "Persistent");
        if (manager.getRoot().exists()) {
            FileManager n = manager.toJSON("components", "Persistent");
            Configurable c = n.getRoot();
            c.save();
            c.reload();
            manager.getRoot().delete();
        }
        PlayerSearch.reload().deploy();
        this.registerServices().deploy();
        this.registerJsonAdapters().deploy();
        this.registerYamlAdapters().deploy();
        this.getEventMap().subscribeAll(this, new DefaultEvent.Controller(), this);
        this.registerImplementations().deploy();
        this.registerHandshake().deploy();
        this.registerDefaultPlaceholders().deploy();
    }

    Deployable<Labyrinth> registerServices() {
        return Deployable.of(() -> {
            this.serviceManager.load(Service.TASK);
            this.serviceManager.load(Service.RECORDING);
            this.serviceManager.load(Service.DATA);
            this.serviceManager.load(Service.MESSENGER);
            this.serviceManager.load(Service.LEGACY);
            this.serviceManager.load(Service.COOLDOWNS);
            this.serviceManager.load(Service.COMPONENTS);
            this.serviceManager.load(new ServiceType<PlaceholderFormatService>(() -> (text, variable) -> {
                String result = text;
                if (Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI") && variable instanceof OfflinePlayer) {
                    result = PlaceholderAPI.setPlaceholders((OfflinePlayer)((OfflinePlayer)variable), (String)text);
                }
                return PlaceholderRegistration.getInstance().replaceAll(result, variable);
            }));
            this.servicesManager.register(new DefaultImplementation(), (Plugin)this, ServicePriority.Low);
            try {
                CommandUtils.register(new LabyrinthCommand((LabyrinthCommandToken)this.validCommandToken));
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            this.cachedIsLegacy = LabyrinthAPI.super.isLegacy();
            this.cachedIsNew = LabyrinthAPI.super.isNew();
            this.cachedNeedsLegacyLocation = LabyrinthAPI.super.isLegacyVillager();
            return this;
        }, 0);
    }

    Deployable<Labyrinth> registerImplementations() {
        return Deployable.of(() -> {
            TaskScheduler.of(() -> new AdvancedEconomyImplementation(this)).scheduleLater(12L).next(() -> new com.github.sanctum.labyrinth.data.VaultImplementation(this)).scheduleLater(12L).next(() -> {
                if (this.getServer().getPluginManager().isPluginEnabled("Vault")) {
                    VaultImplementation bridge = new VaultImplementation();
                    this.getServicesManager().register(bridge, bridge.getProvider(), ServicePriority.Normal);
                }
                Permissions instance = this.getServicesManager().load(Permissions.class);
                assert (instance != null);
                if (instance.getProvider().equals(this)) {
                    this.getLogger().info("- Using default labyrinth implementation for permissions (No provider).");
                } else if (instance instanceof VaultImplementation) {
                    this.getLogger().info("- Using " + instance.getProvider().getName() + " for permissions. (Vault)");
                } else {
                    this.getLogger().info("- Using " + instance.getProvider().getName() + " for permissions. (Provider)");
                }
            }).scheduleLater(12L);
            if (this.isLegacyVillager()) {
                ConfigurationSerialization.registerClass(LegacyConfigLocation.class);
            }
            if (LabyrinthOption.IMPL_REGION_SERVICES.enabled()) {
                RegionServicesManagerImpl.initialize(this);
            }
            return this;
        }, 0);
    }

    Deployable<Labyrinth> registerHandshake() {
        return Deployable.of(() -> {
            TaskScheduler.of(ExternalDataService.Handshake.getInstance(this)).schedule();
            return this;
        }, 0);
    }

    Deployable<Labyrinth> registerDefaultPlaceholders() {
        return Deployable.of(() -> {
            PlaceholderRegistration registration = PlaceholderRegistration.getInstance();
            registration.registerTranslation(new PlayerPlaceholders());
            return this;
        }, 0);
    }

    Deployable<Labyrinth> registerJsonAdapters() {
        return Deployable.of(() -> {
            Configurable.registerClass(ItemStackSerializable.class);
            Configurable.registerClass(LocationSerializable.class);
            Configurable.registerClass(TemplateSerializable.class);
            Configurable.registerClass(MetaTemplateSerializable.class);
            Configurable.registerClass(MessageSerializable.class);
            Configurable.registerClass(ChunkSerializable.class);
            Configurable.registerClass(CustomColor.class);
            return this;
        }, 0);
    }

    Deployable<Labyrinth> registerYamlAdapters() {
        return Deployable.of(() -> {
            ConfigurationSerialization.registerClass(CustomColor.class);
            ConfigurationSerialization.registerClass(Template.class);
            ConfigurationSerialization.registerClass(MetaTemplate.class);
            FileManager copy = FileList.search((Plugin)this).get("config");
            InputStream stream = this.getResource("config.yml");
            assert (stream != null);
            if (!copy.getRoot().exists()) {
                FileList.copy(stream, copy.getRoot().getParent());
            }
            this.cachedComponentRemoval = copy.read(f -> f.getInt("interactive-component-removal"));
            return this;
        }, 0);
    }

    public void onDisable() {
        Iterator<Object> iterator = this.tasks.iterator();
        while (iterator.hasNext()) {
            int id = iterator.next();
            this.getServer().getScheduler().cancelTask(id);
        }
        this.getScheduler(1).shutdown();
        this.getScheduler(0).shutdown();
        try {
            Thread.sleep(1L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!this.isLegacy() && !this.isModded()) {
            for (Item i : Item.getRegistered()) {
                Item.removeEntry(i);
            }
        }
    }

    @Subscribe(priority=Vent.Priority.LOW)
    public void onJoin(DefaultEvent.Join e) {
        PlayerSearch.of((OfflinePlayer)e.getPlayer());
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onComponent(PlayerCommandPreprocessEvent e) {
        String label = e.getMessage().split(" ")[0].replace("/", "");
        ActionComponent component = this.components.get(label);
        if (component != null) {
            Applicable action = component.action();
            if (!component.isMarked()) {
                if (!component.isTooltip()) {
                    TaskScheduler.of(action).schedule();
                    component.setMarked(true);
                    TaskScheduler.of(component::remove).scheduleLater(this.cachedComponentRemoval);
                } else {
                    TaskScheduler.of(action).schedule();
                }
            }
            e.setCancelled(true);
        }
    }

    @Override
    @NotNull
    public VentMap getEventMap() {
        VentMap ventMap = VentMap.getInstance();
        if (ventMap == null) {
            Labyrinth.$$$reportNull$$$0(0);
        }
        return ventMap;
    }

    @Override
    @NotNull
    public ConcurrentLinkedQueue<Integer> getConcurrentTaskIds() {
        ConcurrentLinkedQueue<Integer> concurrentLinkedQueue = this.tasks;
        if (concurrentLinkedQueue == null) {
            Labyrinth.$$$reportNull$$$0(1);
        }
        return concurrentLinkedQueue;
    }

    @Override
    public TaskChain getScheduler(int runtime) {
        if (runtime <= 1) {
            if (runtime == 0) {
                return this.syncChain;
            }
            if (runtime == 1) {
                return TaskChain.getAsynchronous();
            }
        }
        return this.syncChain;
    }

    @NotNull
    public LinkedList<Cooldown> getCooldowns() {
        LinkedList<Cooldown> linkedList = this.cooldowns;
        if (linkedList == null) {
            Labyrinth.$$$reportNull$$$0(2);
        }
        return linkedList;
    }

    @Override
    @Nullable
    public Cooldown getCooldown(final String id) {
        return this.cooldowns.stream().filter(c -> c.getId().equals(id)).findFirst().orElseGet(() -> {
            FileManager library = FileList.search((Plugin)this).get("cooldowns", "Persistent", Configurable.Type.JSON);
            if (library.read(f -> f.isNode("Library." + id)).booleanValue()) {
                Long b;
                final long time = library.read(f -> f.getLong("Library." + id + ".expiration"));
                final String s = library.read(f -> f.getString("Library." + id + ".descriptor"));
                Long a = time;
                int compareNum = a.compareTo(b = Long.valueOf(System.currentTimeMillis()));
                if (compareNum > 0) {
                    Cooldown toMake = new Cooldown(){

                        @Override
                        public String getId() {
                            return id;
                        }

                        @Override
                        public long getCooldown() {
                            return time;
                        }

                        @Override
                        public String getDescriptor() {
                            return s;
                        }
                    };
                    toMake.save();
                    return toMake;
                }
                DataTable table = DataTable.newTable();
                table.set("Library." + id, null);
                library.write(table);
            }
            return null;
        });
    }

    @Override
    public boolean remove(Cooldown cooldown) {
        if (!this.cooldowns.contains(cooldown)) {
            return false;
        }
        Node home = FileList.search(LabyrinthProvider.getInstance().getPluginInstance()).get("cooldowns", "Persistent", Configurable.Type.JSON).read(t -> t.getNode("Library." + cooldown.getId()));
        home.delete();
        home.save();
        TaskScheduler.of(() -> this.cooldowns.remove(cooldown)).schedule();
        return true;
    }

    @Override
    @NotNull
    public List<ActionComponent> getComponents() {
        List<ActionComponent> list = Collections.unmodifiableList(new ArrayList<ActionComponent>(this.components.values()));
        if (list == null) {
            Labyrinth.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Override
    public Deployable<Void> registerComponent(ActionComponent component) {
        return Deployable.of(() -> this.components.put(component.getId(), component), 0);
    }

    @Override
    public Deployable<Void> removeComponent(ActionComponent component) {
        return Deployable.of(() -> this.components.remove(component.getId()), 0);
    }

    @Override
    @NotNull
    public List<PersistentContainer> getContainers(Plugin plugin) {
        ImmutableList immutableList = ImmutableList.copyOf((Collection)this.containers.stream().filter(p -> p.getKey().getNamespace().equals(plugin.getName().toLowerCase(Locale.ROOT))).collect(Collectors.toSet()));
        if (immutableList == null) {
            Labyrinth.$$$reportNull$$$0(4);
        }
        return immutableList;
    }

    @Override
    @NotNull
    public PersistentContainer getContainer(@NotNull NamespacedKey namespacedKey) {
        if (namespacedKey == null) {
            Labyrinth.$$$reportNull$$$0(5);
        }
        PersistentContainer persistentContainer = this.containers.stream().filter(p -> p.getKey().equals(namespacedKey)).findFirst().orElseGet(() -> {
            PersistentContainer container = new PersistentContainer(namespacedKey);
            this.containers.add(container);
            return container;
        });
        if (persistentContainer == null) {
            Labyrinth.$$$reportNull$$$0(6);
        }
        return persistentContainer;
    }

    @Override
    public boolean isLegacy() {
        return this.cachedIsLegacy;
    }

    @Override
    public boolean isNew() {
        return this.cachedIsNew;
    }

    @Override
    public boolean isLegacyVillager() {
        return this.cachedNeedsLegacyLocation;
    }

    @Override
    public ItemCompost getItemComposter() {
        return this.composter;
    }

    @Override
    public PrintManager getLocalPrintManager() {
        return this.manager;
    }

    @Override
    public KeyedServiceManager<Plugin> getServicesManager() {
        return this.servicesManager;
    }

    @Override
    public ServiceManager getServiceManager() {
        return this.serviceManager;
    }

    @Override
    public Plugin getPluginInstance() {
        return this;
    }

    @Override
    @NotNull
    public Mailer getEmptyMailer() {
        Mailer mailer = Mailer.empty((Plugin)this);
        if (mailer == null) {
            Labyrinth.$$$reportNull$$$0(7);
        }
        return mailer;
    }

    @Override
    @NotNull
    public Mailer getEmptyMailer(CommandSender sender) {
        Mailer mailer = Mailer.empty(sender);
        if (mailer == null) {
            Labyrinth.$$$reportNull$$$0(8);
        }
        return mailer;
    }

    @Override
    @NotNull
    public Mailer getEmptyMailer(Plugin plugin) {
        Mailer mailer = Mailer.empty(plugin);
        if (mailer == null) {
            Labyrinth.$$$reportNull$$$0(9);
        }
        return mailer;
    }

    @Override
    @NotNull
    public TimeWatch.Recording getTimeActive() {
        TimeWatch.Recording recording = TimeWatch.Recording.subtract(this.time);
        if (recording == null) {
            Labyrinth.$$$reportNull$$$0(10);
        }
        return recording;
    }

    @Override
    @NotNull
    public TimeWatch.Recording getTimeFrom(Date date) {
        TimeWatch.Recording recording = this.getTimeFrom(date.getTime());
        if (recording == null) {
            Labyrinth.$$$reportNull$$$0(11);
        }
        return recording;
    }

    @Override
    @NotNull
    public TimeWatch.Recording getTimeFrom(long l) {
        TimeWatch.Recording recording = TimeWatch.Recording.subtract(l);
        if (recording == null) {
            Labyrinth.$$$reportNull$$$0(12);
        }
        return recording;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/github/sanctum/labyrinth/Labyrinth";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespacedKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getEventMap";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getConcurrentTaskIds";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCooldowns";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponents";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainers";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/github/sanctum/labyrinth/Labyrinth";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainer";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getEmptyMailer";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTimeActive";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getTimeFrom";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getContainer";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

