/*
 * Decompiled with CFR 0.152.
 */
package eu.luftiger.syncedweather.utils;

import eu.luftiger.syncedweather.SyncedWeather;
import eu.luftiger.syncedweather.model.Weather;
import eu.luftiger.syncedweather.utils.ConfigService;
import eu.luftiger.syncedweather.utils.ProtocolHandler;
import org.bukkit.Bukkit;
import org.bukkit.GameRule;
import org.bukkit.World;

public class WeatherService {
    private final ConfigService configService;
    private final ProtocolHandler protocolHandler;
    private final Weather weather;

    public WeatherService(SyncedWeather plugin) {
        this.configService = plugin.getConfigService();
        this.protocolHandler = plugin.getProtocolHandler();
        this.weather = new Weather(plugin);
    }

    public void setMinecraftWeather(String weatherName) {
        World world;
        if (weatherName.equalsIgnoreCase("rain")) {
            for (String worldName : this.configService.getConfig().getStringList("Worlds")) {
                world = Bukkit.getWorld((String)worldName);
                if (world == null) continue;
                world.setGameRule(GameRule.DO_WEATHER_CYCLE, (Object)false);
                world.setStorm(true);
            }
        } else if (weatherName.equalsIgnoreCase("thunderstorm")) {
            for (String worldName : this.configService.getConfig().getStringList("Worlds")) {
                world = Bukkit.getWorld((String)worldName);
                if (world == null) continue;
                world.setGameRule(GameRule.DO_WEATHER_CYCLE, (Object)false);
                world.setStorm(true);
                world.setThundering(true);
            }
        } else if (weatherName.equalsIgnoreCase("clear") || weatherName.equalsIgnoreCase("clouds") || weatherName.equalsIgnoreCase("snow")) {
            for (String worldName : this.configService.getConfig().getStringList("Worlds")) {
                world = Bukkit.getWorld((String)worldName);
                if (world == null) continue;
                world.setGameRule(GameRule.DO_WEATHER_CYCLE, (Object)false);
                world.setStorm(false);
                world.setThundering(false);
            }
        }
        switch (weatherName.toLowerCase()) {
            case "rain": {
                for (String worldName : this.configService.getConfig().getStringList("Worlds")) {
                    World world2 = Bukkit.getWorld((String)worldName);
                    if (world2 == null) continue;
                    world2.setGameRule(GameRule.DO_WEATHER_CYCLE, (Object)false);
                    world2.setStorm(true);
                }
                break;
            }
            case "thunderstorm": {
                for (String worldName : this.configService.getConfig().getStringList("Worlds")) {
                    World world3 = Bukkit.getWorld((String)worldName);
                    if (world3 == null) continue;
                    world3.setGameRule(GameRule.DO_WEATHER_CYCLE, (Object)false);
                    world3.setStorm(true);
                    world3.setThundering(true);
                }
                break;
            }
            case "clear": 
            case "clouds": {
                for (String worldName : this.configService.getConfig().getStringList("Worlds")) {
                    World world4 = Bukkit.getWorld((String)worldName);
                    if (world4 == null) continue;
                    world4.setGameRule(GameRule.DO_WEATHER_CYCLE, (Object)false);
                    world4.setStorm(false);
                    world4.setThundering(false);
                }
                break;
            }
            case "snow": {
                if (this.protocolHandler == null) break;
                for (String worldName : this.configService.getConfig().getStringList("Worlds")) {
                    World world5 = Bukkit.getWorld((String)worldName);
                    if (world5 == null) continue;
                    world5.setGameRule(GameRule.DO_WEATHER_CYCLE, (Object)false);
                    world5.setStorm(true);
                    this.protocolHandler.sendSnowbiome();
                }
                break;
            }
        }
    }

    public Weather getWeather() {
        return this.weather;
    }
}

