/*
 * Decompiled with CFR 0.152.
 */
package eu.luftiger.syncedweather.utils;

import eu.luftiger.syncedweather.SyncedWeather;
import eu.luftiger.syncedweather.model.Weather;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class Placeholder
extends PlaceholderExpansion {
    private final SyncedWeather plugin;
    private final Weather weather;

    public Placeholder(SyncedWeather plugin) {
        this.plugin = plugin;
        this.weather = plugin.getWeatherService().getWeather();
    }

    public boolean persist() {
        return true;
    }

    public boolean canRegister() {
        return true;
    }

    @NotNull
    public String getIdentifier() {
        return "syncedweather";
    }

    @NotNull
    public String getAuthor() {
        return this.plugin.getDescription().getAuthors().toString();
    }

    @NotNull
    public String getVersion() {
        return this.plugin.getDescription().getVersion();
    }

    public String onPlaceholderRequest(Player player, String indetifier) {
        if (indetifier.equals("temperatureC")) {
            return String.valueOf(this.weather.getTempC());
        }
        if (indetifier.equals("temperatureF")) {
            return String.valueOf(this.weather.getTempF());
        }
        if (indetifier.equals("wind_degree")) {
            return String.valueOf(this.weather.getWindDegree());
        }
        if (indetifier.equals("wind_compass_direction")) {
            if (this.weather.getWindDegree() <= 22.5 || this.weather.getWindDegree() >= 337.5) {
                return "N";
            }
            if (this.weather.getWindDegree() >= 22.5 && this.weather.getWindDegree() <= 67.5) {
                return "NO";
            }
            if (this.weather.getWindDegree() >= 67.5 && this.weather.getWindDegree() <= 112.5) {
                return "O";
            }
            if (this.weather.getWindDegree() >= 112.5 && this.weather.getWindDegree() <= 157.5) {
                return "SO";
            }
            if (this.weather.getWindDegree() >= 157.5 && this.weather.getWindDegree() <= 202.5) {
                return "S";
            }
            if (this.weather.getWindDegree() >= 202.5 && this.weather.getWindDegree() <= 247.5) {
                return "SW";
            }
            if (this.weather.getWindDegree() >= 247.5 && this.weather.getWindDegree() <= 292.5) {
                return "W";
            }
            if (this.weather.getWindDegree() >= 292.5 && this.weather.getWindDegree() <= 337.5) {
                return "NW";
            }
        }
        if (indetifier.equals("wind_speed")) {
            return String.valueOf(this.weather.getWindSpeed());
        }
        if (indetifier.equals("weather")) {
            if (this.weather.getWeatherName() != null) {
                return this.weather.getWeatherName();
            }
            return "unknown";
        }
        if (indetifier.equals("location")) {
            if (this.weather.getLocationName() != null) {
                return this.weather.getLocationName();
            }
            return "unknown";
        }
        return null;
    }
}

