/*
 * Decompiled with CFR 0.152.
 */
package eu.luftiger.syncedweather.scheduler;

import eu.luftiger.syncedweather.SyncedWeather;
import eu.luftiger.syncedweather.utils.ConfigService;
import eu.luftiger.syncedweather.utils.WeatherService;
import eu.luftiger.time.DateTime;
import eu.luftiger.time.DateTimeZone;
import org.bukkit.Bukkit;
import org.bukkit.GameRule;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class CheckUpTask {
    private final SyncedWeather plugin;
    private final ConfigService configService;
    private final WeatherService weatherService;
    private BukkitTask runnable;

    public CheckUpTask(SyncedWeather plugin) {
        this.plugin = plugin;
        this.configService = plugin.getConfigService();
        this.weatherService = plugin.getWeatherService();
    }

    public void start() {
        final DateTimeZone timeZone = DateTimeZone.forID(this.configService.getConfig().getString("TimeZone"));
        this.runnable = new BukkitRunnable(){
            int cycle = 0;

            public void run() {
                if (CheckUpTask.this.configService.getConfig().getBoolean("SyncTime")) {
                    DateTime dateTime = new DateTime(timeZone);
                    for (String worldName : CheckUpTask.this.configService.getConfig().getStringList("Worlds")) {
                        final World world = Bukkit.getWorld((String)worldName);
                        if (world == null) continue;
                        final double time = (double)(dateTime.getHourOfDay() * 1000 - 6000) + (double)dateTime.getMinuteOfHour() * 16.6;
                        Bukkit.getScheduler().runTask((Plugin)CheckUpTask.this.plugin, new Runnable(){

                            @Override
                            public void run() {
                                world.setGameRule(GameRule.DO_DAYLIGHT_CYCLE, (Object)false);
                                world.setTime((long)time);
                            }
                        });
                    }
                }
                if (CheckUpTask.this.configService.getConfig().getBoolean("SyncWeather")) {
                    ++this.cycle;
                    if (this.cycle == 2) {
                        CheckUpTask.this.weatherService.getWeather().update();
                        if (CheckUpTask.this.weatherService.getWeather().getWeatherName() != null) {
                            Bukkit.getScheduler().runTask((Plugin)CheckUpTask.this.plugin, new Runnable(){

                                @Override
                                public void run() {
                                    CheckUpTask.this.weatherService.setMinecraftWeather(CheckUpTask.this.weatherService.getWeather().getWeatherName());
                                }
                            });
                        }
                        this.cycle = 0;
                    }
                }
            }
        }.runTaskTimerAsynchronously((Plugin)this.plugin, 0L, 600L);
    }

    public void stop() {
        if (this.runnable != null) {
            this.runnable.cancel();
        }
    }
}

