/*
 * Decompiled with CFR 0.152.
 */
package eu.luftiger.syncedweather.model;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import eu.luftiger.syncedweather.SyncedWeather;
import eu.luftiger.syncedweather.utils.ConfigService;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;

public class Weather {
    private final SyncedWeather plugin;
    private final ConfigService configService;
    private String locationName;
    private String weatherName;
    private double tempF;
    private double tempC;
    private double windSpeed;
    private double windDegree;
    private Date sunrise;
    private Date sunset;

    public Weather(SyncedWeather plugin) {
        this.plugin = plugin;
        this.configService = plugin.getConfigService();
    }

    private static Map<String, Object> jsonToMap(String str) {
        return (Map)new Gson().fromJson(str, new TypeToken<HashMap<String, Object>>(){}.getType());
    }

    private static double round(double value) {
        long factor = (long)Math.pow(10.0, 2.0);
        long tmp = Math.round(value *= (double)factor);
        return (double)tmp / (double)factor;
    }

    public void update() {
        Map<Object, Object> respMap = new HashMap();
        String API_KEY = this.configService.getConfig().getString("API_KEY");
        String LOCATION = this.configService.getConfig().getString("Location");
        String urlString = "http://api.openweathermap.org/data/2.5/weather?q=" + LOCATION + "&appid=" + API_KEY + "&units=imperial";
        try {
            String line;
            StringBuilder result = new StringBuilder();
            URL url = new URL(urlString);
            URLConnection conn = url.openConnection();
            BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            while ((line = rd.readLine()) != null) {
                result.append(line);
            }
            rd.close();
            respMap = Weather.jsonToMap(result.toString());
        }
        catch (IOException e) {
            Bukkit.getLogger().warning("[SyncedWeather] There is an error with the request for the data: \u00a74" + e.getMessage().replace(" ", ""));
            return;
        }
        this.locationName = respMap.get("name").toString() + ", " + Weather.jsonToMap(respMap.get("sys").toString()).get("country").toString();
        DecimalFormat decimalFormat = new DecimalFormat("#.##");
        this.tempF = Weather.round(Double.parseDouble(Weather.jsonToMap(respMap.get("main").toString()).get("temp").toString()));
        this.tempC = Weather.round(Math.rint((this.tempF - 32.0) * 5.0 / 9.0));
        String rawInfo = respMap.get("weather").toString().replace("[", "").replace("]", "").replace("{", "").replace("}", "").replace(" ", "");
        ArrayList<String> weather = new ArrayList<String>();
        for (String s : rawInfo.split(",")) {
            weather.add(s.split("=")[1]);
        }
        if (weather.size() < 1) {
            Bukkit.getLogger().warning("[SyncedWeather] The weather station you have selected is not compatible!");
        }
        this.weatherName = (String)weather.get(1);
        this.windSpeed = Weather.round(Math.rint(Double.parseDouble(Weather.jsonToMap(respMap.get("wind").toString()).get("speed").toString())) * 3.6);
        this.windDegree = Weather.round(Double.parseDouble(Weather.jsonToMap(respMap.get("wind").toString()).get("deg").toString()));
    }

    public SyncedWeather getPlugin() {
        return this.plugin;
    }

    public ConfigService getConfigService() {
        return this.configService;
    }

    public String getLocationName() {
        return this.locationName;
    }

    public String getWeatherName() {
        return this.weatherName;
    }

    public double getTempF() {
        return this.tempF;
    }

    public double getTempC() {
        return this.tempC;
    }

    public double getWindSpeed() {
        return this.windSpeed;
    }

    public double getWindDegree() {
        return this.windDegree;
    }

    public Date getSunrise() {
        return this.sunrise;
    }

    public Date getSunset() {
        return this.sunset;
    }
}

